/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
 * WorkCenterCapacityInterval_2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityInterval_2Field
 * WorkCenterCapacityInterval_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapacityInterval_2Link
 * WorkCenterCapacityInterval_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#CAPACITY_ACTIVE_VERSION
 * CAPACITY_ACTIVE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#INTERVAL_END_DATE
 * INTERVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#INTERVAL_START_DATE
 * INTERVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#STD_AVAILABLE_CAPACITY_IS_VALID
 * STD_AVAILABLE_CAPACITY_IS_VALID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#AVAILABLE_CAPACITY_INTERVAL_DURN
 * AVAILABLE_CAPACITY_INTERVAL_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#SHIFT_SEQUENCE
 * SHIFT_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#WORK_DAY_RULE
 * WORK_DAY_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#CAPACITY_NUMBER_OF_SHIFTS
 * CAPACITY_NUMBER_OF_SHIFTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#CAPACITY_NUMBER_OF_CAPACITIES
 * CAPACITY_NUMBER_OF_CAPACITIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#CAPACITY_PLAN_UTILIZATION_PERCENT
 * CAPACITY_PLAN_UTILIZATION_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#CAPACITY_LAST_CHANGE_DATE_TIME
 * CAPACITY_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2#TO_CAPACITY_SHIFT
 * TO_CAPACITY_SHIFT}</li>
 * </ul>
 *
 */
public interface WorkCenterCapacityInterval_2Selectable extends EntitySelectable<WorkCenterCapacityInterval_2>
{

}
