/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
 * WorkCenterCapacityShift}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityShiftField
 * WorkCenterCapacityShiftField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapacityShiftLink
 * WorkCenterCapacityShiftLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#CAPACITY_CATEGORY_ALLOCATION
 * CAPACITY_CATEGORY_ALLOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#CAPACITY_ACTIVE_VERSION
 * CAPACITY_ACTIVE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#INTERVAL_END_DATE
 * INTERVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#WEEK_DAY
 * WEEK_DAY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#AVAILABLE_CAPACITY_SHIFT
 * AVAILABLE_CAPACITY_SHIFT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#INTERVAL_START_DATE
 * INTERVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#SHIFT_NAME
 * SHIFT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#SHIFT_DEF_VALIDITY_START
 * SHIFT_DEF_VALIDITY_START}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#SHIFT_DEF_VALIDITY_END
 * SHIFT_DEF_VALIDITY_END}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#SHIFT_START_TIME
 * SHIFT_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#SHIFT_END_TIME
 * SHIFT_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#CAPACITY_BREAK_DURATION
 * CAPACITY_BREAK_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#CAPACITY_PLAN_UTILIZATION_PERCENT
 * CAPACITY_PLAN_UTILIZATION_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#CAPACITY_NUMBER_OF_CAPACITIES
 * CAPACITY_NUMBER_OF_CAPACITIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#TOT_OPERATING_DURATION_IN_HOURS
 * TOT_OPERATING_DURATION_IN_HOURS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift#TOT_OPERATION_DURATION_UNIT
 * TOT_OPERATION_DURATION_UNIT}</li>
 * </ul>
 *
 */
public interface WorkCenterCapacityShiftSelectable extends EntitySelectable<WorkCenterCapacityShift>
{

}
