/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
 * WorkCenterCapacityShift_2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityShift_2Field
 * WorkCenterCapacityShift_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapacityShift_2Link
 * WorkCenterCapacityShift_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#CAPACITY_ACTIVE_VERSION
 * CAPACITY_ACTIVE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#INTERVAL_END_DATE
 * INTERVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#WEEK_DAY
 * WEEK_DAY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#AVAILABLE_CAPACITY_SHIFT
 * AVAILABLE_CAPACITY_SHIFT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#INTERVAL_START_DATE
 * INTERVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#WORK_DAY_RULE
 * WORK_DAY_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#SHIFT_DEFINITION
 * SHIFT_DEFINITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#SHIFT_START_TIME
 * SHIFT_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#SHIFT_END_TIME
 * SHIFT_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#SHIFT_DEF_VALIDITY_START_DATE
 * SHIFT_DEF_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#SHIFT_DEF_VALIDITY_END_DATE
 * SHIFT_DEF_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#CAPACITY_NUMBER_OF_CAPACITIES
 * CAPACITY_NUMBER_OF_CAPACITIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#CAPACITY_PLAN_UTILIZATION_PERCENT
 * CAPACITY_PLAN_UTILIZATION_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#CAPACITY_BREAK_DURATION
 * CAPACITY_BREAK_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#OPERATING_DURATION_IN_SECONDS
 * OPERATING_DURATION_IN_SECONDS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#TOT_OPERATING_DURATION_IN_SECONDS
 * TOT_OPERATING_DURATION_IN_SECONDS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2#CAPACITY_LAST_CHANGE_DATE_TIME
 * CAPACITY_LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface WorkCenterCapacityShift_2Selectable extends EntitySelectable<WorkCenterCapacityShift_2>
{

}
