/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation
 * WorkCenterDayOperation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterDayOperationField
 * WorkCenterDayOperationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterDayOperationLink
 * WorkCenterDayOperationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#MFG_ORDER_OPERATION_TEXT
 * MFG_ORDER_OPERATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OPERATION_IS_RELEASED
 * OPERATION_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OP_ERLST_SCHEDLD_EXEC_STRT_DTE
 * OP_ERLST_SCHEDLD_EXEC_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OP_ERLST_SCHEDLD_EXEC_STRT_TME
 * OP_ERLST_SCHEDLD_EXEC_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OP_ERLST_SCHEDLD_EXEC_END_DTE
 * OP_ERLST_SCHEDLD_EXEC_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OP_ERLST_SCHEDLD_EXEC_END_TME
 * OP_ERLST_SCHEDLD_EXEC_END_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OP_PLANNED_TOTAL_QUANTITY
 * OP_PLANNED_TOTAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OPERATION_UNIT
 * OPERATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#CONFIRMED_QUANTITY
 * CONFIRMED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#CONFIRMED_QUANTITY_IN_BASE_UNIT
 * CONFIRMED_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#CONFIRMED_QUANTITY_UNIT
 * CONFIRMED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS
 * ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#OP_ACTUAL_EXECUTION_DAYS
 * OP_ACTUAL_EXECUTION_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * </ul>
 *
 */
public interface WorkCenterDayOperationSelectable extends EntitySelectable<WorkCenterDayOperation>
{

}
