/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCentersField
 * WorkCentersField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCentersLink
 * WorkCentersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_DESC
 * WORK_CENTER_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_CATEGORY_CODE
 * WORK_CENTER_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_RESPONSIBLE
 * WORK_CENTER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_RESPONSIBLE_NAME
 * WORK_CENTER_RESPONSIBLE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#SUPPLY_AREA
 * SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_USAGE
 * WORK_CENTER_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_IS_TO_BE_DELETED
 * WORK_CENTER_IS_TO_BE_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FORMULA_PARAM1
 * WORK_CENTER_FORMULA_PARAM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FORMULA_PARAM2
 * WORK_CENTER_FORMULA_PARAM2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FORMULA_PARAM3
 * WORK_CENTER_FORMULA_PARAM3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FORMULA_PARAM4
 * WORK_CENTER_FORMULA_PARAM4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FORMULA_PARAM5
 * WORK_CENTER_FORMULA_PARAM5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FORMULA_PARAM6
 * WORK_CENTER_FORMULA_PARAM6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_VALUE1
 * WORK_CENTER_FMLA_PARAM_VALUE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_VALUE2
 * WORK_CENTER_FMLA_PARAM_VALUE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_VALUE3
 * WORK_CENTER_FMLA_PARAM_VALUE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_VALUE4
 * WORK_CENTER_FMLA_PARAM_VALUE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_VALUE5
 * WORK_CENTER_FMLA_PARAM_VALUE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_VALUE6
 * WORK_CENTER_FMLA_PARAM_VALUE6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_UNIT1
 * WORK_CENTER_FMLA_PARAM_UNIT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_UNIT2
 * WORK_CENTER_FMLA_PARAM_UNIT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_UNIT3
 * WORK_CENTER_FMLA_PARAM_UNIT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_UNIT4
 * WORK_CENTER_FMLA_PARAM_UNIT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_UNIT5
 * WORK_CENTER_FMLA_PARAM_UNIT5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_FMLA_PARAM_UNIT6
 * WORK_CENTER_FMLA_PARAM_UNIT6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#STANDARD_WORK_FORMULA_PARAM_GROUP
 * STANDARD_WORK_FORMULA_PARAM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_STD_VAL_MAINT_RULE1
 * WRK_CTR_STD_VAL_MAINT_RULE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_STD_VAL_MAINT_RULE2
 * WRK_CTR_STD_VAL_MAINT_RULE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_STD_VAL_MAINT_RULE3
 * WRK_CTR_STD_VAL_MAINT_RULE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_STD_VAL_MAINT_RULE4
 * WRK_CTR_STD_VAL_MAINT_RULE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_STD_VAL_MAINT_RULE5
 * WRK_CTR_STD_VAL_MAINT_RULE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_STD_VAL_MAINT_RULE6
 * WRK_CTR_STD_VAL_MAINT_RULE6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_STANDARD_WORK_QTY_UNIT1
 * WORK_CENTER_STANDARD_WORK_QTY_UNIT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_STANDARD_WORK_QTY_UNIT2
 * WORK_CENTER_STANDARD_WORK_QTY_UNIT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_STANDARD_WORK_QTY_UNIT3
 * WORK_CENTER_STANDARD_WORK_QTY_UNIT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_STANDARD_WORK_QTY_UNIT4
 * WORK_CENTER_STANDARD_WORK_QTY_UNIT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_STANDARD_WORK_QTY_UNIT5
 * WORK_CENTER_STANDARD_WORK_QTY_UNIT5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_STANDARD_WORK_QTY_UNIT6
 * WORK_CENTER_STANDARD_WORK_QTY_UNIT6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#OPERATION_CONTROL_PROFILE
 * OPERATION_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#MATL_COMP_IS_MARKED_FOR_BACKFLUSH
 * MATL_COMP_IS_MARKED_FOR_BACKFLUSH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_LOCATION
 * WORK_CENTER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_LOCATION_GROUP
 * WORK_CENTER_LOCATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_SETUP_SCHEDG_FMLA
 * WRK_CTR_SETUP_SCHEDG_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_PROCG_SCHEDG_FMLA
 * WRK_CTR_PROCG_SCHEDG_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_TEARDOWN_SCHEDG_FMLA
 * WRK_CTR_TEARDOWN_SCHEDG_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WRK_CTR_INT_PROCG_SCHEDG_FMLA
 * WRK_CTR_INT_PROCG_SCHEDG_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#WORK_CENTER_LAST_CHANGE_DATE_TIME
 * WORK_CENTER_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_CAPACITY
 * TO_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_WORK_CENTER_ALL_CAPACITY
 * TO_WORK_CENTER_ALL_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_WORK_CENTER_CAPACITY
 * TO_WORK_CENTER_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_WORK_CENTER_COST_CENTER
 * TO_WORK_CENTER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_WORK_CENTER_DESCRIPTION
 * TO_WORK_CENTER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_WORK_CENTER_QUEUING_OP
 * TO_WORK_CENTER_QUEUING_OP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters#TO_WORK_CENTER_TODAY_OP
 * TO_WORK_CENTER_TODAY_OP}</li>
 * </ul>
 *
 */
public interface WorkCentersSelectable extends EntitySelectable<WorkCenters>
{

}
