/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.field.TimeOverviewField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.selectable.TimeOverviewSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Daily Availability
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TimeOverview</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TimeOverview extends VdmEntity<TimeOverview>
{

    /**
     * Selector for all available fields of TimeOverview.
     *
     */
    public final static TimeOverviewSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Personworkagreementexternalid</b>
     * </p>
     *
     * @return Work Agreement Ext ID
     */
    @Key
    @SerializedName( "Personworkagreementexternalid" )
    @JsonProperty( "Personworkagreementexternalid" )
    @Nullable
    @ODataField( odataName = "Personworkagreementexternalid" )
    private String personworkagreementexternalid;
    /**
     * Use with available fluent helpers to apply the <b>Personworkagreementexternalid</b> field to query operations.
     *
     */
    public final static TimeOverviewField<String> PERSONWORKAGREEMENTEXTERNALID =
        new TimeOverviewField<String>("Personworkagreementexternalid");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Companycode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "Companycode" )
    @JsonProperty( "Companycode" )
    @Nullable
    @ODataField( odataName = "Companycode" )
    private String companycode;
    /**
     * Use with available fluent helpers to apply the <b>Companycode</b> field to query operations.
     *
     */
    public final static TimeOverviewField<String> COMPANYCODE = new TimeOverviewField<String>("Companycode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personworkagreement</b>
     * </p>
     *
     * @return Person Work Agreement
     */
    @SerializedName( "Personworkagreement" )
    @JsonProperty( "Personworkagreement" )
    @Nullable
    @ODataField( odataName = "Personworkagreement" )
    private String personworkagreement;
    /**
     * Use with available fluent helpers to apply the <b>Personworkagreement</b> field to query operations.
     *
     */
    public final static TimeOverviewField<String> PERSONWORKAGREEMENT =
        new TimeOverviewField<String>("Personworkagreement");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Calendardate</b>
     * </p>
     *
     * @return Calendar Date
     */
    @Key
    @SerializedName( "Calendardate" )
    @JsonProperty( "Calendardate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Calendardate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime calendardate;
    /**
     * Use with available fluent helpers to apply the <b>Calendardate</b> field to query operations.
     *
     */
    public final static TimeOverviewField<LocalDateTime> CALENDARDATE =
        new TimeOverviewField<LocalDateTime>("Calendardate");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Plannedworkinghours</b>
     * </p>
     *
     * @return Working hours
     */
    @SerializedName( "Plannedworkinghours" )
    @JsonProperty( "Plannedworkinghours" )
    @Nullable
    @ODataField( odataName = "Plannedworkinghours" )
    private BigDecimal plannedworkinghours;
    /**
     * Use with available fluent helpers to apply the <b>Plannedworkinghours</b> field to query operations.
     *
     */
    public final static TimeOverviewField<BigDecimal> PLANNEDWORKINGHOURS =
        new TimeOverviewField<BigDecimal>("Plannedworkinghours");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>Plannedstarttime</b>
     * </p>
     *
     * @return Work Start
     */
    @SerializedName( "Plannedstarttime" )
    @JsonProperty( "Plannedstarttime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "Plannedstarttime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime plannedstarttime;
    /**
     * Use with available fluent helpers to apply the <b>Plannedstarttime</b> field to query operations.
     *
     */
    public final static TimeOverviewField<LocalTime> PLANNEDSTARTTIME =
        new TimeOverviewField<LocalTime>("Plannedstarttime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>Plannedendtime</b>
     * </p>
     *
     * @return End of Work
     */
    @SerializedName( "Plannedendtime" )
    @JsonProperty( "Plannedendtime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "Plannedendtime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime plannedendtime;
    /**
     * Use with available fluent helpers to apply the <b>Plannedendtime</b> field to query operations.
     *
     */
    public final static TimeOverviewField<LocalTime> PLANNEDENDTIME =
        new TimeOverviewField<LocalTime>("Plannedendtime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Publicholidayclass</b>
     * </p>
     *
     * @return Holiday class
     */
    @SerializedName( "Publicholidayclass" )
    @JsonProperty( "Publicholidayclass" )
    @Nullable
    @ODataField( odataName = "Publicholidayclass" )
    private String publicholidayclass;
    /**
     * Use with available fluent helpers to apply the <b>Publicholidayclass</b> field to query operations.
     *
     */
    public final static TimeOverviewField<String> PUBLICHOLIDAYCLASS =
        new TimeOverviewField<String>("Publicholidayclass");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Isnonworkingday</b>
     * </p>
     *
     * @return Non working day
     */
    @SerializedName( "Isnonworkingday" )
    @JsonProperty( "Isnonworkingday" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Isnonworkingday" )
    private Boolean isnonworkingday;
    /**
     * Use with available fluent helpers to apply the <b>Isnonworkingday</b> field to query operations.
     *
     */
    public final static TimeOverviewField<Boolean> ISNONWORKINGDAY = new TimeOverviewField<Boolean>("Isnonworkingday");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Absencehours</b>
     * </p>
     *
     * @return Absence hours
     */
    @SerializedName( "Absencehours" )
    @JsonProperty( "Absencehours" )
    @Nullable
    @ODataField( odataName = "Absencehours" )
    private BigDecimal absencehours;
    /**
     * Use with available fluent helpers to apply the <b>Absencehours</b> field to query operations.
     *
     */
    public final static TimeOverviewField<BigDecimal> ABSENCEHOURS = new TimeOverviewField<BigDecimal>("Absencehours");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Attendancehours</b>
     * </p>
     *
     * @return Attendance hours
     */
    @SerializedName( "Attendancehours" )
    @JsonProperty( "Attendancehours" )
    @Nullable
    @ODataField( odataName = "Attendancehours" )
    private BigDecimal attendancehours;
    /**
     * Use with available fluent helpers to apply the <b>Attendancehours</b> field to query operations.
     *
     */
    public final static TimeOverviewField<BigDecimal> ATTENDANCEHOURS =
        new TimeOverviewField<BigDecimal>("Attendancehours");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Overtimehours</b>
     * </p>
     *
     * @return Overtime hours
     */
    @SerializedName( "Overtimehours" )
    @JsonProperty( "Overtimehours" )
    @Nullable
    @ODataField( odataName = "Overtimehours" )
    private BigDecimal overtimehours;
    /**
     * Use with available fluent helpers to apply the <b>Overtimehours</b> field to query operations.
     *
     */
    public final static TimeOverviewField<BigDecimal> OVERTIMEHOURS =
        new TimeOverviewField<BigDecimal>("Overtimehours");

    @Nonnull
    @Override
    public Class<TimeOverview> getType()
    {
        return TimeOverview.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Personworkagreementexternalid</b>
     * </p>
     *
     * @param personworkagreementexternalid
     *            Work Agreement Ext ID
     */
    public void setPersonworkagreementexternalid( @Nullable final String personworkagreementexternalid )
    {
        rememberChangedField("Personworkagreementexternalid", this.personworkagreementexternalid);
        this.personworkagreementexternalid = personworkagreementexternalid;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Companycode</b>
     * </p>
     *
     * @param companycode
     *            Company Code
     */
    public void setCompanycode( @Nullable final String companycode )
    {
        rememberChangedField("Companycode", this.companycode);
        this.companycode = companycode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personworkagreement</b>
     * </p>
     *
     * @param personworkagreement
     *            Person Work Agreement
     */
    public void setPersonworkagreement( @Nullable final String personworkagreement )
    {
        rememberChangedField("Personworkagreement", this.personworkagreement);
        this.personworkagreement = personworkagreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Calendardate</b>
     * </p>
     *
     * @param calendardate
     *            Calendar Date
     */
    public void setCalendardate( @Nullable final LocalDateTime calendardate )
    {
        rememberChangedField("Calendardate", this.calendardate);
        this.calendardate = calendardate;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Plannedworkinghours</b>
     * </p>
     *
     * @param plannedworkinghours
     *            Working hours
     */
    public void setPlannedworkinghours( @Nullable final BigDecimal plannedworkinghours )
    {
        rememberChangedField("Plannedworkinghours", this.plannedworkinghours);
        this.plannedworkinghours = plannedworkinghours;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>Plannedstarttime</b>
     * </p>
     *
     * @param plannedstarttime
     *            Work Start
     */
    public void setPlannedstarttime( @Nullable final LocalTime plannedstarttime )
    {
        rememberChangedField("Plannedstarttime", this.plannedstarttime);
        this.plannedstarttime = plannedstarttime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>Plannedendtime</b>
     * </p>
     *
     * @param plannedendtime
     *            End of Work
     */
    public void setPlannedendtime( @Nullable final LocalTime plannedendtime )
    {
        rememberChangedField("Plannedendtime", this.plannedendtime);
        this.plannedendtime = plannedendtime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Publicholidayclass</b>
     * </p>
     *
     * @param publicholidayclass
     *            Holiday class
     */
    public void setPublicholidayclass( @Nullable final String publicholidayclass )
    {
        rememberChangedField("Publicholidayclass", this.publicholidayclass);
        this.publicholidayclass = publicholidayclass;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Isnonworkingday</b>
     * </p>
     *
     * @param isnonworkingday
     *            Non working day
     */
    public void setIsnonworkingday( @Nullable final Boolean isnonworkingday )
    {
        rememberChangedField("Isnonworkingday", this.isnonworkingday);
        this.isnonworkingday = isnonworkingday;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Absencehours</b>
     * </p>
     *
     * @param absencehours
     *            Absence hours
     */
    public void setAbsencehours( @Nullable final BigDecimal absencehours )
    {
        rememberChangedField("Absencehours", this.absencehours);
        this.absencehours = absencehours;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Attendancehours</b>
     * </p>
     *
     * @param attendancehours
     *            Attendance hours
     */
    public void setAttendancehours( @Nullable final BigDecimal attendancehours )
    {
        rememberChangedField("Attendancehours", this.attendancehours);
        this.attendancehours = attendancehours;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>Overtimehours</b>
     * </p>
     *
     * @param overtimehours
     *            Overtime hours
     */
    public void setOvertimehours( @Nullable final BigDecimal overtimehours )
    {
        rememberChangedField("Overtimehours", this.overtimehours);
        this.overtimehours = overtimehours;
    }

    @Override
    protected String getEntityCollection()
    {
        return "TimeOverviewSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Personworkagreementexternalid", getPersonworkagreementexternalid());
        result.put("Companycode", getCompanycode());
        result.put("Calendardate", getCalendardate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Personworkagreementexternalid", getPersonworkagreementexternalid());
        values.put("Companycode", getCompanycode());
        values.put("Personworkagreement", getPersonworkagreement());
        values.put("Calendardate", getCalendardate());
        values.put("Plannedworkinghours", getPlannedworkinghours());
        values.put("Plannedstarttime", getPlannedstarttime());
        values.put("Plannedendtime", getPlannedendtime());
        values.put("Publicholidayclass", getPublicholidayclass());
        values.put("Isnonworkingday", getIsnonworkingday());
        values.put("Absencehours", getAbsencehours());
        values.put("Attendancehours", getAttendancehours());
        values.put("Overtimehours", getOvertimehours());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Personworkagreementexternalid") ) {
                final Object value = values.remove("Personworkagreementexternalid");
                if( (value == null) || (!value.equals(getPersonworkagreementexternalid())) ) {
                    setPersonworkagreementexternalid(((String) value));
                }
            }
            if( values.containsKey("Companycode") ) {
                final Object value = values.remove("Companycode");
                if( (value == null) || (!value.equals(getCompanycode())) ) {
                    setCompanycode(((String) value));
                }
            }
            if( values.containsKey("Personworkagreement") ) {
                final Object value = values.remove("Personworkagreement");
                if( (value == null) || (!value.equals(getPersonworkagreement())) ) {
                    setPersonworkagreement(((String) value));
                }
            }
            if( values.containsKey("Calendardate") ) {
                final Object value = values.remove("Calendardate");
                if( (value == null) || (!value.equals(getCalendardate())) ) {
                    setCalendardate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Plannedworkinghours") ) {
                final Object value = values.remove("Plannedworkinghours");
                if( (value == null) || (!value.equals(getPlannedworkinghours())) ) {
                    setPlannedworkinghours(((BigDecimal) value));
                }
            }
            if( values.containsKey("Plannedstarttime") ) {
                final Object value = values.remove("Plannedstarttime");
                if( (value == null) || (!value.equals(getPlannedstarttime())) ) {
                    setPlannedstarttime(((LocalTime) value));
                }
            }
            if( values.containsKey("Plannedendtime") ) {
                final Object value = values.remove("Plannedendtime");
                if( (value == null) || (!value.equals(getPlannedendtime())) ) {
                    setPlannedendtime(((LocalTime) value));
                }
            }
            if( values.containsKey("Publicholidayclass") ) {
                final Object value = values.remove("Publicholidayclass");
                if( (value == null) || (!value.equals(getPublicholidayclass())) ) {
                    setPublicholidayclass(((String) value));
                }
            }
            if( values.containsKey("Isnonworkingday") ) {
                final Object value = values.remove("Isnonworkingday");
                if( (value == null) || (!value.equals(getIsnonworkingday())) ) {
                    setIsnonworkingday(((Boolean) value));
                }
            }
            if( values.containsKey("Absencehours") ) {
                final Object value = values.remove("Absencehours");
                if( (value == null) || (!value.equals(getAbsencehours())) ) {
                    setAbsencehours(((BigDecimal) value));
                }
            }
            if( values.containsKey("Attendancehours") ) {
                final Object value = values.remove("Attendancehours");
                if( (value == null) || (!value.equals(getAttendancehours())) ) {
                    setAttendancehours(((BigDecimal) value));
                }
            }
            if( values.containsKey("Overtimehours") ) {
                final Object value = values.remove("Overtimehours");
                if( (value == null) || (!value.equals(getOvertimehours())) ) {
                    setOvertimehours(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> TimeOverviewField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TimeOverviewField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TimeOverviewField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TimeOverviewField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService.DEFAULT_SERVICE_PATH);
    }

}
