/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.selectable.TimeOverviewSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview TimeOverview} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class TimeOverviewByKeyFluentHelper
    extends
    FluentHelperByKey<TimeOverviewByKeyFluentHelper, TimeOverview, TimeOverviewSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview TimeOverview}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code TimeOverview}
     * @param personworkagreementexternalid
     *            Work Agreement Ext ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param companycode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code TimeOverview}
     * @param calendardate
     *            Calendar Date
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     */
    public TimeOverviewByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String personworkagreementexternalid,
        final String companycode,
        final LocalDateTime calendardate )
    {
        super(servicePath, entityCollection);
        this.key.put("Personworkagreementexternalid", personworkagreementexternalid);
        this.key.put("Companycode", companycode);
        this.key.put("Calendardate", calendardate);
    }

    @Override
    @Nonnull
    protected Class<TimeOverview> getEntityClass()
    {
        return TimeOverview.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
