/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WorkforceAvailabilityServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService WorkforceAvailabilityService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWorkforceAvailabilityServiceBatch
    extends
    BatchFluentHelperBasic<WorkforceAvailabilityServiceBatch, WorkforceAvailabilityServiceBatchChangeSet>
    implements
    WorkforceAvailabilityServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWorkforceAvailabilityServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWorkforceAvailabilityServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWorkforceAvailabilityServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWorkforceAvailabilityServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWorkforceAvailabilityServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkforceAvailabilityServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWorkforceAvailabilityServiceBatchChangeSet(this, service);
    }

}
