/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview;

/**
 * Implementation of the {@link WorkforceAvailabilityServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService WorkforceAvailabilityService}.
 *
 */
public class DefaultWorkforceAvailabilityServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WorkforceAvailabilityServiceBatch, WorkforceAvailabilityServiceBatchChangeSet>
    implements
    WorkforceAvailabilityServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService service;

    @SuppressWarnings( "deprecation" )
    DefaultWorkforceAvailabilityServiceBatchChangeSet(
        @Nonnull final DefaultWorkforceAvailabilityServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWorkforceAvailabilityServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkforceAvailabilityServiceBatchChangeSet createTimeOverview( @Nonnull final TimeOverview timeOverview )
    {
        return addRequestCreate(service::createTimeOverview, timeOverview);
    }

    @Nonnull
    @Override
    public WorkforceAvailabilityServiceBatchChangeSet updateTimeOverview( @Nonnull final TimeOverview timeOverview )
    {
        return addRequestUpdate(service::updateTimeOverview, timeOverview);
    }

    @Nonnull
    @Override
    public WorkforceAvailabilityServiceBatchChangeSet deleteTimeOverview( @Nonnull final TimeOverview timeOverview )
    {
        return addRequestDelete(service::deleteTimeOverview, timeOverview);
    }

}
