/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceAvailabilityService
 * WorkforceAvailabilityService}.
 *
 */
public interface WorkforceAvailabilityServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WorkforceAvailabilityServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WorkforceAvailabilityServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity and save it to the S/4HANA system.
     *
     * @param timeOverview
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *            TimeOverview} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforceAvailabilityServiceBatchChangeSet createTimeOverview( @Nonnull final TimeOverview timeOverview );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity and save it to the S/4HANA system.
     *
     * @param timeOverview
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *            TimeOverview} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforceAvailabilityServiceBatchChangeSet updateTimeOverview( @Nonnull final TimeOverview timeOverview );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity in the S/4HANA system.
     *
     * @param timeOverview
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *            TimeOverview} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforceAvailabilityServiceBatchChangeSet deleteTimeOverview( @Nonnull final TimeOverview timeOverview );

}
