/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview TimeOverview}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.field.TimeOverviewField
 * TimeOverviewField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.link.TimeOverviewLink
 * TimeOverviewLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#PERSONWORKAGREEMENTEXTERNALID
 * PERSONWORKAGREEMENTEXTERNALID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#COMPANYCODE
 * COMPANYCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#PERSONWORKAGREEMENT
 * PERSONWORKAGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#CALENDARDATE
 * CALENDARDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#PLANNEDWORKINGHOURS
 * PLANNEDWORKINGHOURS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#PLANNEDSTARTTIME
 * PLANNEDSTARTTIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#PLANNEDENDTIME
 * PLANNEDENDTIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#PUBLICHOLIDAYCLASS
 * PUBLICHOLIDAYCLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#ISNONWORKINGDAY
 * ISNONWORKINGDAY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#ABSENCEHOURS
 * ABSENCEHOURS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#ATTENDANCEHOURS
 * ATTENDANCEHOURS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview#OVERTIMEHOURS
 * OVERTIMEHOURS}</li>
 * </ul>
 *
 */
public interface TimeOverviewSelectable extends EntitySelectable<TimeOverview>
{

}
