/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SAP__CurrencyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable.SAP__CurrencySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__Currency</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__Currency extends VdmEntity<SAP__Currency>
{

    /**
     * Selector for all available fields of SAP__Currency.
     *
     */
    public final static SAP__CurrencySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyCode</b>
     * </p>
     *
     * @return Currency
     */
    @Key
    @SerializedName( "CurrencyCode" )
    @JsonProperty( "CurrencyCode" )
    @Nullable
    @ODataField( odataName = "CurrencyCode" )
    private String currencyCode;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyCode</b> field to query operations.
     *
     */
    public final static SAP__CurrencyField<String> CURRENCY_CODE = new SAP__CurrencyField<String>("CurrencyCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ISOCode</b>
     * </p>
     *
     * @return ISO Code
     */
    @SerializedName( "ISOCode" )
    @JsonProperty( "ISOCode" )
    @Nullable
    @ODataField( odataName = "ISOCode" )
    private String iSOCode;
    /**
     * Use with available fluent helpers to apply the <b>ISOCode</b> field to query operations.
     *
     */
    public final static SAP__CurrencyField<String> ISO_CODE = new SAP__CurrencyField<String>("ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Text</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "Text" )
    @JsonProperty( "Text" )
    @Nullable
    @ODataField( odataName = "Text" )
    private String text;
    /**
     * Use with available fluent helpers to apply the <b>Text</b> field to query operations.
     *
     */
    public final static SAP__CurrencyField<String> TEXT = new SAP__CurrencyField<String>("Text");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DecimalPlaces</b>
     * </p>
     *
     * @return Decimals
     */
    @SerializedName( "DecimalPlaces" )
    @JsonProperty( "DecimalPlaces" )
    @Nullable
    @ODataField( odataName = "DecimalPlaces" )
    private Short decimalPlaces;
    /**
     * Use with available fluent helpers to apply the <b>DecimalPlaces</b> field to query operations.
     *
     */
    public final static SAP__CurrencyField<Short> DECIMAL_PLACES = new SAP__CurrencyField<Short>("DecimalPlaces");

    @Nonnull
    @Override
    public Class<SAP__Currency> getType()
    {
        return SAP__Currency.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyCode</b>
     * </p>
     *
     * @param currencyCode
     *            Currency
     */
    public void setCurrencyCode( @Nullable final String currencyCode )
    {
        rememberChangedField("CurrencyCode", this.currencyCode);
        this.currencyCode = currencyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ISOCode</b>
     * </p>
     *
     * @param iSOCode
     *            ISO Code
     */
    public void setISOCode( @Nullable final String iSOCode )
    {
        rememberChangedField("ISOCode", this.iSOCode);
        this.iSOCode = iSOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Text</b>
     * </p>
     *
     * @param text
     *            Short Text
     */
    public void setText( @Nullable final String text )
    {
        rememberChangedField("Text", this.text);
        this.text = text;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DecimalPlaces</b>
     * </p>
     *
     * @param decimalPlaces
     *            Decimals
     */
    public void setDecimalPlaces( @Nullable final Short decimalPlaces )
    {
        rememberChangedField("DecimalPlaces", this.decimalPlaces);
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__Currencies";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CurrencyCode", getCurrencyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CurrencyCode", getCurrencyCode());
        values.put("ISOCode", getISOCode());
        values.put("Text", getText());
        values.put("DecimalPlaces", getDecimalPlaces());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CurrencyCode") ) {
                final Object value = values.remove("CurrencyCode");
                if( (value == null) || (!value.equals(getCurrencyCode())) ) {
                    setCurrencyCode(((String) value));
                }
            }
            if( values.containsKey("ISOCode") ) {
                final Object value = values.remove("ISOCode");
                if( (value == null) || (!value.equals(getISOCode())) ) {
                    setISOCode(((String) value));
                }
            }
            if( values.containsKey("Text") ) {
                final Object value = values.remove("Text");
                if( (value == null) || (!value.equals(getText())) ) {
                    setText(((String) value));
                }
            }
            if( values.containsKey("DecimalPlaces") ) {
                final Object value = values.remove("DecimalPlaces");
                if( (value == null) || (!value.equals(getDecimalPlaces())) ) {
                    setDecimalPlaces(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SAP__CurrencyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__CurrencyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__CurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__CurrencyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService.DEFAULT_SERVICE_PATH);
    }

}
