/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SAP__DocumentDescriptionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.link.SAP__DocumentDescriptionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.link.SAP__DocumentDescriptionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable.SAP__DocumentDescriptionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__DocumentDescription</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__DocumentDescription extends VdmEntity<SAP__DocumentDescription>
{

    /**
     * Selector for all available fields of SAP__DocumentDescription.
     *
     */
    public final static SAP__DocumentDescriptionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @return UUID
     */
    @Key
    @SerializedName( "Id" )
    @JsonProperty( "Id" )
    @Nullable
    @ODataField( odataName = "Id" )
    private UUID id;
    /**
     * Use with available fluent helpers to apply the <b>Id</b> field to query operations.
     *
     */
    public final static SAP__DocumentDescriptionField<UUID> ID = new SAP__DocumentDescriptionField<UUID>("Id");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedBy</b>
     * </p>
     *
     * @return The createdBy contained in this entity.
     */
    @SerializedName( "CreatedBy" )
    @JsonProperty( "CreatedBy" )
    @Nullable
    @ODataField( odataName = "CreatedBy" )
    private String createdBy;
    /**
     * Use with available fluent helpers to apply the <b>CreatedBy</b> field to query operations.
     *
     */
    public final static SAP__DocumentDescriptionField<String> CREATED_BY =
        new SAP__DocumentDescriptionField<String>("CreatedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreatedAt</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "CreatedAt" )
    @JsonProperty( "CreatedAt" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreatedAt",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime createdAt;
    /**
     * Use with available fluent helpers to apply the <b>CreatedAt</b> field to query operations.
     *
     */
    public final static SAP__DocumentDescriptionField<LocalDateTime> CREATED_AT =
        new SAP__DocumentDescriptionField<LocalDateTime>("CreatedAt");
    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @return The fileName contained in this entity.
     */
    @SerializedName( "FileName" )
    @JsonProperty( "FileName" )
    @Nullable
    @ODataField( odataName = "FileName" )
    private String fileName;
    /**
     * Use with available fluent helpers to apply the <b>FileName</b> field to query operations.
     *
     */
    public final static SAP__DocumentDescriptionField<String> FILE_NAME =
        new SAP__DocumentDescriptionField<String>("FileName");
    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Title</b>
     * </p>
     *
     * @return The title contained in this entity.
     */
    @SerializedName( "Title" )
    @JsonProperty( "Title" )
    @Nullable
    @ODataField( odataName = "Title" )
    private String title;
    /**
     * Use with available fluent helpers to apply the <b>Title</b> field to query operations.
     *
     */
    public final static SAP__DocumentDescriptionField<String> TITLE =
        new SAP__DocumentDescriptionField<String>("Title");
    /**
     * Navigation property <b>Format</b> for <b>SAP__DocumentDescription</b> to single <b>SAP__Format</b>.
     *
     */
    @SerializedName( "Format" )
    @JsonProperty( "Format" )
    @ODataField( odataName = "Format" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SAP__Format toFormat;
    /**
     * Navigation property <b>TableColumns</b> for <b>SAP__DocumentDescription</b> to multiple <b>SAP__TableColumns</b>.
     *
     */
    @SerializedName( "TableColumns" )
    @JsonProperty( "TableColumns" )
    @ODataField( odataName = "TableColumns" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SAP__TableColumns> toTableColumns;
    /**
     * Navigation property <b>CoverPage</b> for <b>SAP__DocumentDescription</b> to multiple <b>SAP__CoverPage</b>.
     *
     */
    @SerializedName( "CoverPage" )
    @JsonProperty( "CoverPage" )
    @ODataField( odataName = "CoverPage" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SAP__CoverPage> toCoverPage;
    /**
     * Navigation property <b>Signature</b> for <b>SAP__DocumentDescription</b> to single <b>SAP__Signature</b>.
     *
     */
    @SerializedName( "Signature" )
    @JsonProperty( "Signature" )
    @ODataField( odataName = "Signature" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SAP__Signature toSignature;
    /**
     * Navigation property <b>PDFStandard</b> for <b>SAP__DocumentDescription</b> to single <b>SAP__PDFStandard</b>.
     *
     */
    @SerializedName( "PDFStandard" )
    @JsonProperty( "PDFStandard" )
    @ODataField( odataName = "PDFStandard" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SAP__PDFStandard toPDFStandard;
    /**
     * Use with available fluent helpers to apply the <b>Format</b> navigation property to query operations.
     *
     */
    public final static SAP__DocumentDescriptionOneToOneLink<SAP__Format> TO_FORMAT =
        new SAP__DocumentDescriptionOneToOneLink<SAP__Format>("Format");
    /**
     * Use with available fluent helpers to apply the <b>TableColumns</b> navigation property to query operations.
     *
     */
    public final static SAP__DocumentDescriptionLink<SAP__TableColumns> TO_TABLE_COLUMNS =
        new SAP__DocumentDescriptionLink<SAP__TableColumns>("TableColumns");
    /**
     * Use with available fluent helpers to apply the <b>CoverPage</b> navigation property to query operations.
     *
     */
    public final static SAP__DocumentDescriptionLink<SAP__CoverPage> TO_COVER_PAGE =
        new SAP__DocumentDescriptionLink<SAP__CoverPage>("CoverPage");
    /**
     * Use with available fluent helpers to apply the <b>Signature</b> navigation property to query operations.
     *
     */
    public final static SAP__DocumentDescriptionOneToOneLink<SAP__Signature> TO_SIGNATURE =
        new SAP__DocumentDescriptionOneToOneLink<SAP__Signature>("Signature");
    /**
     * Use with available fluent helpers to apply the <b>PDFStandard</b> navigation property to query operations.
     *
     */
    public final static SAP__DocumentDescriptionOneToOneLink<SAP__PDFStandard> TO_PDF_STANDARD =
        new SAP__DocumentDescriptionOneToOneLink<SAP__PDFStandard>("PDFStandard");

    @Nonnull
    @Override
    public Class<SAP__DocumentDescription> getType()
    {
        return SAP__DocumentDescription.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *            UUID
     */
    public void setId( @Nullable final UUID id )
    {
        rememberChangedField("Id", this.id);
        this.id = id;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedBy</b>
     * </p>
     *
     * @param createdBy
     *            The createdBy to set.
     */
    public void setCreatedBy( @Nullable final String createdBy )
    {
        rememberChangedField("CreatedBy", this.createdBy);
        this.createdBy = createdBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreatedAt</b>
     * </p>
     *
     * @param createdAt
     *            Time Stamp
     */
    public void setCreatedAt( @Nullable final LocalDateTime createdAt )
    {
        rememberChangedField("CreatedAt", this.createdAt);
        this.createdAt = createdAt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @param fileName
     *            The fileName to set.
     */
    public void setFileName( @Nullable final String fileName )
    {
        rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Title</b>
     * </p>
     *
     * @param title
     *            The title to set.
     */
    public void setTitle( @Nullable final String title )
    {
        rememberChangedField("Title", this.title);
        this.title = title;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__MyDocumentDescriptions";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Id", getId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Id", getId());
        values.put("CreatedBy", getCreatedBy());
        values.put("CreatedAt", getCreatedAt());
        values.put("FileName", getFileName());
        values.put("Title", getTitle());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Id") ) {
                final Object value = values.remove("Id");
                if( (value == null) || (!value.equals(getId())) ) {
                    setId(((UUID) value));
                }
            }
            if( values.containsKey("CreatedBy") ) {
                final Object value = values.remove("CreatedBy");
                if( (value == null) || (!value.equals(getCreatedBy())) ) {
                    setCreatedBy(((String) value));
                }
            }
            if( values.containsKey("CreatedAt") ) {
                final Object value = values.remove("CreatedAt");
                if( (value == null) || (!value.equals(getCreatedAt())) ) {
                    setCreatedAt(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FileName") ) {
                final Object value = values.remove("FileName");
                if( (value == null) || (!value.equals(getFileName())) ) {
                    setFileName(((String) value));
                }
            }
            if( values.containsKey("Title") ) {
                final Object value = values.remove("Title");
                if( (value == null) || (!value.equals(getTitle())) ) {
                    setTitle(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Format") ) {
                final Object value = (values).remove("Format");
                if( value instanceof Map ) {
                    if( toFormat == null ) {
                        toFormat = new SAP__Format();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFormat.fromMap(inputMap);
                }
            }
            if( (values).containsKey("TableColumns") ) {
                final Object value = (values).remove("TableColumns");
                if( value instanceof Iterable ) {
                    if( toTableColumns == null ) {
                        toTableColumns = Lists.newArrayList();
                    } else {
                        toTableColumns = Lists.newArrayList(toTableColumns);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SAP__TableColumns entity;
                        if( toTableColumns.size() > i ) {
                            entity = toTableColumns.get(i);
                        } else {
                            entity = new SAP__TableColumns();
                            toTableColumns.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("CoverPage") ) {
                final Object value = (values).remove("CoverPage");
                if( value instanceof Iterable ) {
                    if( toCoverPage == null ) {
                        toCoverPage = Lists.newArrayList();
                    } else {
                        toCoverPage = Lists.newArrayList(toCoverPage);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SAP__CoverPage entity;
                        if( toCoverPage.size() > i ) {
                            entity = toCoverPage.get(i);
                        } else {
                            entity = new SAP__CoverPage();
                            toCoverPage.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("Signature") ) {
                final Object value = (values).remove("Signature");
                if( value instanceof Map ) {
                    if( toSignature == null ) {
                        toSignature = new SAP__Signature();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSignature.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PDFStandard") ) {
                final Object value = (values).remove("PDFStandard");
                if( value instanceof Map ) {
                    if( toPDFStandard == null ) {
                        toPDFStandard = new SAP__PDFStandard();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPDFStandard.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SAP__DocumentDescriptionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__DocumentDescriptionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__DocumentDescriptionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__DocumentDescriptionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFormat != null ) {
            (values).put("Format", toFormat);
        }
        if( toTableColumns != null ) {
            (values).put("TableColumns", toTableColumns);
        }
        if( toCoverPage != null ) {
            (values).put("CoverPage", toCoverPage);
        }
        if( toSignature != null ) {
            (values).put("Signature", toSignature);
        }
        if( toPDFStandard != null ) {
            (values).put("PDFStandard", toPDFStandard);
        }
        return values;
    }

    /**
     * Fetches the <b>SAP__Format</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>Format</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SAP__Format</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SAP__Format fetchFormat()
    {
        return fetchFieldAsSingle("Format", SAP__Format.class);
    }

    /**
     * Retrieval of associated <b>SAP__Format</b> entity (one to one). This corresponds to the OData navigation property
     * <b>Format</b>.
     * <p>
     * If the navigation property <b>Format</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SAP__Format</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SAP__Format getFormatOrFetch()
    {
        if( toFormat == null ) {
            toFormat = fetchFormat();
        }
        return toFormat;
    }

    /**
     * Retrieval of associated <b>SAP__Format</b> entity (one to one). This corresponds to the OData navigation property
     * <b>Format</b>.
     * <p>
     * If the navigation property for an entity <b>SAP__DocumentDescription</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Format</b> is already loaded, the result will contain the
     *         <b>SAP__Format</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<SAP__Format> getFormatIfPresent()
    {
        return Option.of(toFormat);
    }

    /**
     * Overwrites the associated <b>SAP__Format</b> entity for the loaded navigation property <b>Format</b>.
     *
     * @param value
     *            New <b>SAP__Format</b> entity.
     */
    public void setFormat( final SAP__Format value )
    {
        toFormat = value;
    }

    /**
     * Fetches the <b>SAP__TableColumns</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>TableColumns</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SAP__TableColumns</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SAP__TableColumns> fetchTableColumns()
    {
        return fetchFieldAsList("TableColumns", SAP__TableColumns.class);
    }

    /**
     * Retrieval of associated <b>SAP__TableColumns</b> entities (one to many). This corresponds to the OData navigation
     * property <b>TableColumns</b>.
     * <p>
     * If the navigation property <b>TableColumns</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SAP__TableColumns</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SAP__TableColumns> getTableColumnsOrFetch()
    {
        if( toTableColumns == null ) {
            toTableColumns = fetchTableColumns();
        }
        return toTableColumns;
    }

    /**
     * Retrieval of associated <b>SAP__TableColumns</b> entities (one to many). This corresponds to the OData navigation
     * property <b>TableColumns</b>.
     * <p>
     * If the navigation property for an entity <b>SAP__DocumentDescription</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>TableColumns</b> is already loaded, the result will contain
     *         the <b>SAP__TableColumns</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SAP__TableColumns>> getTableColumnsIfPresent()
    {
        return Option.of(toTableColumns);
    }

    /**
     * Overwrites the list of associated <b>SAP__TableColumns</b> entities for the loaded navigation property
     * <b>TableColumns</b>.
     * <p>
     * If the navigation property <b>TableColumns</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SAP__TableColumns</b> entities.
     */
    public void setTableColumns( @Nonnull final List<SAP__TableColumns> value )
    {
        if( toTableColumns == null ) {
            toTableColumns = Lists.newArrayList();
        }
        toTableColumns.clear();
        toTableColumns.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SAP__TableColumns</b> entities. This corresponds to the OData
     * navigation property <b>TableColumns</b>.
     * <p>
     * If the navigation property <b>TableColumns</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SAP__TableColumns</b> entities.
     */
    public void addTableColumns( SAP__TableColumns... entity )
    {
        if( toTableColumns == null ) {
            toTableColumns = Lists.newArrayList();
        }
        toTableColumns.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SAP__CoverPage</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>CoverPage</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SAP__CoverPage</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SAP__CoverPage> fetchCoverPage()
    {
        return fetchFieldAsList("CoverPage", SAP__CoverPage.class);
    }

    /**
     * Retrieval of associated <b>SAP__CoverPage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>CoverPage</b>.
     * <p>
     * If the navigation property <b>CoverPage</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SAP__CoverPage</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SAP__CoverPage> getCoverPageOrFetch()
    {
        if( toCoverPage == null ) {
            toCoverPage = fetchCoverPage();
        }
        return toCoverPage;
    }

    /**
     * Retrieval of associated <b>SAP__CoverPage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>CoverPage</b>.
     * <p>
     * If the navigation property for an entity <b>SAP__DocumentDescription</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>CoverPage</b> is already loaded, the result will contain
     *         the <b>SAP__CoverPage</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SAP__CoverPage>> getCoverPageIfPresent()
    {
        return Option.of(toCoverPage);
    }

    /**
     * Overwrites the list of associated <b>SAP__CoverPage</b> entities for the loaded navigation property
     * <b>CoverPage</b>.
     * <p>
     * If the navigation property <b>CoverPage</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SAP__CoverPage</b> entities.
     */
    public void setCoverPage( @Nonnull final List<SAP__CoverPage> value )
    {
        if( toCoverPage == null ) {
            toCoverPage = Lists.newArrayList();
        }
        toCoverPage.clear();
        toCoverPage.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SAP__CoverPage</b> entities. This corresponds to the OData navigation
     * property <b>CoverPage</b>.
     * <p>
     * If the navigation property <b>CoverPage</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SAP__CoverPage</b> entities.
     */
    public void addCoverPage( SAP__CoverPage... entity )
    {
        if( toCoverPage == null ) {
            toCoverPage = Lists.newArrayList();
        }
        toCoverPage.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SAP__Signature</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>Signature</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SAP__Signature</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SAP__Signature fetchSignature()
    {
        return fetchFieldAsSingle("Signature", SAP__Signature.class);
    }

    /**
     * Retrieval of associated <b>SAP__Signature</b> entity (one to one). This corresponds to the OData navigation
     * property <b>Signature</b>.
     * <p>
     * If the navigation property <b>Signature</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SAP__Signature</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SAP__Signature getSignatureOrFetch()
    {
        if( toSignature == null ) {
            toSignature = fetchSignature();
        }
        return toSignature;
    }

    /**
     * Retrieval of associated <b>SAP__Signature</b> entity (one to one). This corresponds to the OData navigation
     * property <b>Signature</b>.
     * <p>
     * If the navigation property for an entity <b>SAP__DocumentDescription</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Signature</b> is already loaded, the result will contain
     *         the <b>SAP__Signature</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<SAP__Signature> getSignatureIfPresent()
    {
        return Option.of(toSignature);
    }

    /**
     * Overwrites the associated <b>SAP__Signature</b> entity for the loaded navigation property <b>Signature</b>.
     *
     * @param value
     *            New <b>SAP__Signature</b> entity.
     */
    public void setSignature( final SAP__Signature value )
    {
        toSignature = value;
    }

    /**
     * Fetches the <b>SAP__PDFStandard</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>PDFStandard</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SAP__PDFStandard</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SAP__PDFStandard fetchPDFStandard()
    {
        return fetchFieldAsSingle("PDFStandard", SAP__PDFStandard.class);
    }

    /**
     * Retrieval of associated <b>SAP__PDFStandard</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PDFStandard</b>.
     * <p>
     * If the navigation property <b>PDFStandard</b> of a queried <b>SAP__DocumentDescription</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SAP__PDFStandard</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SAP__PDFStandard getPDFStandardOrFetch()
    {
        if( toPDFStandard == null ) {
            toPDFStandard = fetchPDFStandard();
        }
        return toPDFStandard;
    }

    /**
     * Retrieval of associated <b>SAP__PDFStandard</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PDFStandard</b>.
     * <p>
     * If the navigation property for an entity <b>SAP__DocumentDescription</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>PDFStandard</b> is already loaded, the result will contain
     *         the <b>SAP__PDFStandard</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SAP__PDFStandard> getPDFStandardIfPresent()
    {
        return Option.of(toPDFStandard);
    }

    /**
     * Overwrites the associated <b>SAP__PDFStandard</b> entity for the loaded navigation property <b>PDFStandard</b>.
     *
     * @param value
     *            New <b>SAP__PDFStandard</b> entity.
     */
    public void setPDFStandard( final SAP__PDFStandard value )
    {
        toPDFStandard = value;
    }

    /**
     * Helper class to allow for fluent creation of SAP__DocumentDescription instances.
     *
     */
    public final static class SAP__DocumentDescriptionBuilder
    {

        private SAP__Format toFormat;
        private List<SAP__TableColumns> toTableColumns = Lists.newArrayList();
        private List<SAP__CoverPage> toCoverPage = Lists.newArrayList();
        private SAP__Signature toSignature;
        private SAP__PDFStandard toPDFStandard;

        private SAP__DocumentDescription.SAP__DocumentDescriptionBuilder toFormat( final SAP__Format value )
        {
            toFormat = value;
            return this;
        }

        /**
         * Navigation property <b>Format</b> for <b>SAP__DocumentDescription</b> to single <b>SAP__Format</b>.
         *
         * @param value
         *            The SAP__Format to build this SAP__DocumentDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SAP__DocumentDescription.SAP__DocumentDescriptionBuilder format( final SAP__Format value )
        {
            return toFormat(value);
        }

        private SAP__DocumentDescription.SAP__DocumentDescriptionBuilder toTableColumns(
            final List<SAP__TableColumns> value )
        {
            toTableColumns.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>TableColumns</b> for <b>SAP__DocumentDescription</b> to multiple
         * <b>SAP__TableColumns</b>.
         *
         * @param value
         *            The SAP__TableColumnss to build this SAP__DocumentDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SAP__DocumentDescription.SAP__DocumentDescriptionBuilder tableColumns( SAP__TableColumns... value )
        {
            return toTableColumns(Lists.newArrayList(value));
        }

        private SAP__DocumentDescription.SAP__DocumentDescriptionBuilder toCoverPage( final List<SAP__CoverPage> value )
        {
            toCoverPage.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>CoverPage</b> for <b>SAP__DocumentDescription</b> to multiple <b>SAP__CoverPage</b>.
         *
         * @param value
         *            The SAP__CoverPages to build this SAP__DocumentDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SAP__DocumentDescription.SAP__DocumentDescriptionBuilder coverPage( SAP__CoverPage... value )
        {
            return toCoverPage(Lists.newArrayList(value));
        }

        private SAP__DocumentDescription.SAP__DocumentDescriptionBuilder toSignature( final SAP__Signature value )
        {
            toSignature = value;
            return this;
        }

        /**
         * Navigation property <b>Signature</b> for <b>SAP__DocumentDescription</b> to single <b>SAP__Signature</b>.
         *
         * @param value
         *            The SAP__Signature to build this SAP__DocumentDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SAP__DocumentDescription.SAP__DocumentDescriptionBuilder signature( final SAP__Signature value )
        {
            return toSignature(value);
        }

        private SAP__DocumentDescription.SAP__DocumentDescriptionBuilder toPDFStandard( final SAP__PDFStandard value )
        {
            toPDFStandard = value;
            return this;
        }

        /**
         * Navigation property <b>PDFStandard</b> for <b>SAP__DocumentDescription</b> to single <b>SAP__PDFStandard</b>.
         *
         * @param value
         *            The SAP__PDFStandard to build this SAP__DocumentDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SAP__DocumentDescription.SAP__DocumentDescriptionBuilder pdfStandard( final SAP__PDFStandard value )
        {
            return toPDFStandard(value);
        }

    }

}
