/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SAP__SignatureField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable.SAP__SignatureSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__Signature</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__Signature extends VdmEntity<SAP__Signature>
{

    /**
     * Selector for all available fields of SAP__Signature.
     *
     */
    public final static SAP__SignatureSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @return UUID
     */
    @Key
    @SerializedName( "Id" )
    @JsonProperty( "Id" )
    @Nullable
    @ODataField( odataName = "Id" )
    private UUID id;
    /**
     * Use with available fluent helpers to apply the <b>Id</b> field to query operations.
     *
     */
    public final static SAP__SignatureField<UUID> ID = new SAP__SignatureField<UUID>("Id");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DoSign</b>
     * </p>
     *
     * @return Indicator
     */
    @SerializedName( "DoSign" )
    @JsonProperty( "DoSign" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DoSign" )
    private Boolean doSign;
    /**
     * Use with available fluent helpers to apply the <b>DoSign</b> field to query operations.
     *
     */
    public final static SAP__SignatureField<Boolean> DO_SIGN = new SAP__SignatureField<Boolean>("DoSign");
    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Reason</b>
     * </p>
     *
     * @return The reason contained in this entity.
     */
    @SerializedName( "Reason" )
    @JsonProperty( "Reason" )
    @Nullable
    @ODataField( odataName = "Reason" )
    private String reason;
    /**
     * Use with available fluent helpers to apply the <b>Reason</b> field to query operations.
     *
     */
    public final static SAP__SignatureField<String> REASON = new SAP__SignatureField<String>("Reason");

    @Nonnull
    @Override
    public Class<SAP__Signature> getType()
    {
        return SAP__Signature.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *            UUID
     */
    public void setId( @Nullable final UUID id )
    {
        rememberChangedField("Id", this.id);
        this.id = id;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DoSign</b>
     * </p>
     *
     * @param doSign
     *            Indicator
     */
    public void setDoSign( @Nullable final Boolean doSign )
    {
        rememberChangedField("DoSign", this.doSign);
        this.doSign = doSign;
    }

    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Reason</b>
     * </p>
     *
     * @param reason
     *            The reason to set.
     */
    public void setReason( @Nullable final String reason )
    {
        rememberChangedField("Reason", this.reason);
        this.reason = reason;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__SignatureSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Id", getId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Id", getId());
        values.put("DoSign", getDoSign());
        values.put("Reason", getReason());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Id") ) {
                final Object value = values.remove("Id");
                if( (value == null) || (!value.equals(getId())) ) {
                    setId(((UUID) value));
                }
            }
            if( values.containsKey("DoSign") ) {
                final Object value = values.remove("DoSign");
                if( (value == null) || (!value.equals(getDoSign())) ) {
                    setDoSign(((Boolean) value));
                }
            }
            if( values.containsKey("Reason") ) {
                final Object value = values.remove("Reason");
                if( (value == null) || (!value.equals(getReason())) ) {
                    setReason(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SAP__SignatureField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__SignatureField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__SignatureField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__SignatureField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService.DEFAULT_SERVICE_PATH);
    }

}
