/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable.SAP__UnitOfMeasureSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
 * SAP__UnitOfMeasure} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SAP__UnitOfMeasureByKeyFluentHelper
    extends
    FluentHelperByKey<SAP__UnitOfMeasureByKeyFluentHelper, SAP__UnitOfMeasure, SAP__UnitOfMeasureSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SAP__UnitOfMeasure}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SAP__UnitOfMeasure}
     * @param unitCode
     *            Internal UoM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public SAP__UnitOfMeasureByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String unitCode )
    {
        super(servicePath, entityCollection);
        this.key.put("UnitCode", unitCode);
    }

    @Override
    @Nonnull
    protected Class<SAP__UnitOfMeasure> getEntityClass()
    {
        return SAP__UnitOfMeasure.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
