/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SkillTagField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable.SkillTagSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * SkillTags
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SkillTag</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SkillTag extends VdmEntity<SkillTag>
{

    /**
     * Selector for all available fields of SkillTag.
     *
     */
    public final static SkillTagSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PersonExternalId</b>
     * </p>
     *
     * @return Indicates an unique identifier assigned to workforce person.
     */
    @Key
    @SerializedName( "PersonExternalId" )
    @JsonProperty( "PersonExternalId" )
    @Nullable
    @ODataField( odataName = "PersonExternalId" )
    private String personExternalId;
    /**
     * Use with available fluent helpers to apply the <b>PersonExternalId</b> field to query operations.
     *
     */
    public final static SkillTagField<String> PERSON_EXTERNAL_ID = new SkillTagField<String>("PersonExternalId");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Tag</b>
     * </p>
     *
     * @return Indicates skill tags of workforce person.
     */
    @SerializedName( "Tag" )
    @JsonProperty( "Tag" )
    @Nullable
    @ODataField( odataName = "Tag" )
    private String tag;
    /**
     * Use with available fluent helpers to apply the <b>Tag</b> field to query operations.
     *
     */
    public final static SkillTagField<String> TAG = new SkillTagField<String>("Tag");

    @Nonnull
    @Override
    public Class<SkillTag> getType()
    {
        return SkillTag.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PersonExternalId</b>
     * </p>
     *
     * @param personExternalId
     *            Indicates an unique identifier assigned to workforce person.
     */
    public void setPersonExternalId( @Nullable final String personExternalId )
    {
        rememberChangedField("PersonExternalId", this.personExternalId);
        this.personExternalId = personExternalId;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Tag</b>
     * </p>
     *
     * @param tag
     *            Indicates skill tags of workforce person.
     */
    public void setTag( @Nullable final String tag )
    {
        rememberChangedField("Tag", this.tag);
        this.tag = tag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SkillTagSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PersonExternalId", getPersonExternalId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PersonExternalId", getPersonExternalId());
        values.put("Tag", getTag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PersonExternalId") ) {
                final Object value = values.remove("PersonExternalId");
                if( (value == null) || (!value.equals(getPersonExternalId())) ) {
                    setPersonExternalId(((String) value));
                }
            }
            if( values.containsKey("Tag") ) {
                final Object value = values.remove("Tag");
                if( (value == null) || (!value.equals(getTag())) ) {
                    setTag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SkillTagField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SkillTagField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SkillTagField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SkillTagField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService.DEFAULT_SERVICE_PATH);
    }

}
