/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable.SkillTagSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag SkillTag} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class SkillTagByKeyFluentHelper
    extends
    FluentHelperByKey<SkillTagByKeyFluentHelper, SkillTag, SkillTagSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag SkillTag} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SkillTag}
     * @param personExternalId
     *            Indicates an unique identifier assigned to workforce person.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SkillTag}
     */
    public SkillTagByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String personExternalId )
    {
        super(servicePath, entityCollection);
        this.key.put("PersonExternalId", personExternalId);
    }

    @Override
    @Nonnull
    protected Class<SkillTag> getEntityClass()
    {
        return SkillTag.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
