/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WorkforcePersonSkilltagServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService
 * WorkforcePersonSkilltagService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWorkforcePersonSkilltagServiceBatch
    extends
    BatchFluentHelperBasic<WorkforcePersonSkilltagServiceBatch, WorkforcePersonSkilltagServiceBatchChangeSet>
    implements
    WorkforcePersonSkilltagServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWorkforcePersonSkilltagServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWorkforcePersonSkilltagServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWorkforcePersonSkilltagServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWorkforcePersonSkilltagServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWorkforcePersonSkilltagServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWorkforcePersonSkilltagServiceBatchChangeSet(this, service);
    }

}
