/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag;

/**
 * Implementation of the {@link WorkforcePersonSkilltagServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService
 * WorkforcePersonSkilltagService}.
 *
 */
public class DefaultWorkforcePersonSkilltagServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WorkforcePersonSkilltagServiceBatch, WorkforcePersonSkilltagServiceBatchChangeSet>
    implements
    WorkforcePersonSkilltagServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService service;

    @SuppressWarnings( "deprecation" )
    DefaultWorkforcePersonSkilltagServiceBatchChangeSet(
        @Nonnull final DefaultWorkforcePersonSkilltagServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWorkforcePersonSkilltagServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet createSAP__ValueHelp(
        @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return addRequestCreate(service::createSAP__ValueHelp, sAP__ValueHelp);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet updateSAP__ValueHelp(
        @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return addRequestUpdate(service::updateSAP__ValueHelp, sAP__ValueHelp);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet deleteSAP__ValueHelp(
        @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return addRequestDelete(service::deleteSAP__ValueHelp, sAP__ValueHelp);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet createSkillTag( @Nonnull final SkillTag skillTag )
    {
        return addRequestCreate(service::createSkillTag, skillTag);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet deleteSkillTag( @Nonnull final SkillTag skillTag )
    {
        return addRequestDelete(service::deleteSkillTag, skillTag);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet createSAP__Currency(
        @Nonnull final SAP__Currency sAP__Currency )
    {
        return addRequestCreate(service::createSAP__Currency, sAP__Currency);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet updateSAP__Currency(
        @Nonnull final SAP__Currency sAP__Currency )
    {
        return addRequestUpdate(service::updateSAP__Currency, sAP__Currency);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet deleteSAP__Currency(
        @Nonnull final SAP__Currency sAP__Currency )
    {
        return addRequestDelete(service::deleteSAP__Currency, sAP__Currency);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet createSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return addRequestCreate(service::createSAP__UnitOfMeasure, sAP__UnitOfMeasure);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet updateSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return addRequestUpdate(service::updateSAP__UnitOfMeasure, sAP__UnitOfMeasure);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet deleteSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return addRequestDelete(service::deleteSAP__UnitOfMeasure, sAP__UnitOfMeasure);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet createSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return addRequestCreate(service::createSAP__DocumentDescription, sAP__DocumentDescription);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet updateSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return addRequestUpdate(service::updateSAP__DocumentDescription, sAP__DocumentDescription);
    }

    @Nonnull
    @Override
    public WorkforcePersonSkilltagServiceBatchChangeSet deleteSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return addRequestDelete(service::deleteSAP__DocumentDescription, sAP__DocumentDescription);
    }

}
