/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforcePersonSkilltagService
 * WorkforcePersonSkilltagService}.
 *
 */
public interface WorkforcePersonSkilltagServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WorkforcePersonSkilltagServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WorkforcePersonSkilltagServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp
     * SAP__ValueHelp} entity and save it to the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp
     *            SAP__ValueHelp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet createSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp SAP__ValueHelp}
     * entity and save it to the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp
     *            SAP__ValueHelp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet updateSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp SAP__ValueHelp}
     * entity in the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__ValueHelp
     *            SAP__ValueHelp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet deleteSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag
     * SkillTag} entity and save it to the S/4HANA system.
     *
     * @param skillTag
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag SkillTag}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet createSkillTag( @Nonnull final SkillTag skillTag );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag
     * SkillTag} entity in the S/4HANA system.
     *
     * @param skillTag
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag SkillTag}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet deleteSkillTag( @Nonnull final SkillTag skillTag );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency
     * SAP__Currency} entity and save it to the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency
     *            SAP__Currency} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet createSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency SAP__Currency}
     * entity and save it to the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency
     *            SAP__Currency} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet updateSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency SAP__Currency}
     * entity in the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency
     *            SAP__Currency} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet deleteSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet
        createSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet
        updateSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity in the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet
        deleteSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
     * SAP__DocumentDescription} entity and save it to the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet
        createSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
     * SAP__DocumentDescription} entity and save it to the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet
        updateSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
     * SAP__DocumentDescription} entity in the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkforcePersonSkilltagServiceBatchChangeSet
        deleteSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

}
