/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency SAP__Currency}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SAP__CurrencyField
 * SAP__CurrencyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.link.SAP__CurrencyLink
 * SAP__CurrencyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency#CURRENCY_CODE
 * CURRENCY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency#ISO_CODE
 * ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency#TEXT TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__Currency#DECIMAL_PLACES
 * DECIMAL_PLACES}</li>
 * </ul>
 *
 */
public interface SAP__CurrencySelectable extends EntitySelectable<SAP__Currency>
{

}
