/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription
 * SAP__DocumentDescription}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SAP__DocumentDescriptionField
 * SAP__DocumentDescriptionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.link.SAP__DocumentDescriptionLink
 * SAP__DocumentDescriptionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#ID
 * ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#CREATED_BY
 * CREATED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#CREATED_AT
 * CREATED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#FILE_NAME
 * FILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#TITLE
 * TITLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#TO_FORMAT
 * TO_FORMAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#TO_TABLE_COLUMNS
 * TO_TABLE_COLUMNS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#TO_COVER_PAGE
 * TO_COVER_PAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#TO_SIGNATURE
 * TO_SIGNATURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SAP__DocumentDescription#TO_PDF_STANDARD
 * TO_PDF_STANDARD}</li>
 * </ul>
 *
 */
public interface SAP__DocumentDescriptionSelectable extends EntitySelectable<SAP__DocumentDescription>
{

}
