/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag SkillTag}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.field.SkillTagField
 * SkillTagField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.link.SkillTagLink SkillTagLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag#PERSON_EXTERNAL_ID
 * PERSON_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcepersonskilltag.SkillTag#TAG TAG}</li>
 * </ul>
 *
 */
public interface SkillTagSelectable extends EntitySelectable<SkillTag>
{

}
