/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>TimeSheetDataFields</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TimeSheetDataFields extends VdmComplex<TimeSheetDataFields>
{

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SenderCostCenter</b>
     * </p>
     *
     * @param senderCostCenter
     *
     * @return Sender Cost Center
     */
    @SerializedName( "SenderCostCenter" )
    @JsonProperty( "SenderCostCenter" )
    @Nullable
    @ODataField( odataName = "SenderCostCenter" )
    private String senderCostCenter;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReceiverCostCenter</b>
     * </p>
     *
     * @param receiverCostCenter
     *
     * @return Receiver Cost Center
     */
    @SerializedName( "ReceiverCostCenter" )
    @JsonProperty( "ReceiverCostCenter" )
    @Nullable
    @ODataField( odataName = "ReceiverCostCenter" )
    private String receiverCostCenter;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *
     * @return Internal Order
     */
    @SerializedName( "InternalOrder" )
    @JsonProperty( "InternalOrder" )
    @Nullable
    @ODataField( odataName = "InternalOrder" )
    private String internalOrder;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @param activityType
     *
     * @return Activity Type
     */
    @SerializedName( "ActivityType" )
    @JsonProperty( "ActivityType" )
    @Nullable
    @ODataField( odataName = "ActivityType" )
    private String activityType;
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *
     * @return Work Item
     */
    @SerializedName( "WorkItem" )
    @JsonProperty( "WorkItem" )
    @Nullable
    @ODataField( odataName = "WorkItem" )
    private String workItem;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @param billingControlCategory
     *
     * @return Billing Control Category
     */
    @SerializedName( "BillingControlCategory" )
    @JsonProperty( "BillingControlCategory" )
    @Nullable
    @ODataField( odataName = "BillingControlCategory" )
    private String billingControlCategory;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *
     * @return Purchase Order
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *
     * @return Purchase Order Item
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetTaskType</b>
     * </p>
     *
     * @param timeSheetTaskType
     *
     * @return Time Sheet Task Type
     */
    @SerializedName( "TimeSheetTaskType" )
    @JsonProperty( "TimeSheetTaskType" )
    @Nullable
    @ODataField( odataName = "TimeSheetTaskType" )
    private String timeSheetTaskType;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetTaskLevel</b>
     * </p>
     *
     * @param timeSheetTaskLevel
     *
     * @return Time Sheet Task Level
     */
    @SerializedName( "TimeSheetTaskLevel" )
    @JsonProperty( "TimeSheetTaskLevel" )
    @Nullable
    @ODataField( odataName = "TimeSheetTaskLevel" )
    private String timeSheetTaskLevel;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetTaskComponent</b>
     * </p>
     *
     * @param timeSheetTaskComponent
     *
     * @return Time Sheet Task Component
     */
    @SerializedName( "TimeSheetTaskComponent" )
    @JsonProperty( "TimeSheetTaskComponent" )
    @Nullable
    @ODataField( odataName = "TimeSheetTaskComponent" )
    private String timeSheetTaskComponent;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetNote</b>
     * </p>
     *
     * @param timeSheetNote
     *
     * @return Time Sheet Note
     */
    @SerializedName( "TimeSheetNote" )
    @JsonProperty( "TimeSheetNote" )
    @Nullable
    @ODataField( odataName = "TimeSheetNote" )
    private String timeSheetNote;
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>RecordedHours</b>
     * </p>
     *
     * @param recordedHours
     *
     * @return Recorded Hours
     */
    @SerializedName( "RecordedHours" )
    @JsonProperty( "RecordedHours" )
    @Nullable
    @ODataField( odataName = "RecordedHours" )
    private BigDecimal recordedHours;
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>RecordedQuantity</b>
     * </p>
     *
     * @param recordedQuantity
     *
     * @return Recorded Quantity
     */
    @SerializedName( "RecordedQuantity" )
    @JsonProperty( "RecordedQuantity" )
    @Nullable
    @ODataField( odataName = "RecordedQuantity" )
    private BigDecimal recordedQuantity;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>HoursUnitOfMeasure</b>
     * </p>
     *
     * @param hoursUnitOfMeasure
     *
     * @return Hours Unit Of Measure
     */
    @SerializedName( "HoursUnitOfMeasure" )
    @JsonProperty( "HoursUnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "HoursUnitOfMeasure" )
    private String hoursUnitOfMeasure;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>RejectionReason</b>
     * </p>
     *
     * @param rejectionReason
     *
     * @return Rejection Reason
     */
    @SerializedName( "RejectionReason" )
    @JsonProperty( "RejectionReason" )
    @Nullable
    @ODataField( odataName = "RejectionReason" )
    private String rejectionReason;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetWrkLocCode</b>
     * </p>
     *
     * @param timeSheetWrkLocCode
     *
     * @return Time Sheet Work Location Code
     */
    @SerializedName( "TimeSheetWrkLocCode" )
    @JsonProperty( "TimeSheetWrkLocCode" )
    @Nullable
    @ODataField( odataName = "TimeSheetWrkLocCode" )
    private String timeSheetWrkLocCode;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *
     * @return Time Sheet Overtime Category
     */
    @SerializedName( "TimeSheetOvertimeCategory" )
    @JsonProperty( "TimeSheetOvertimeCategory" )
    @Nullable
    @ODataField( odataName = "TimeSheetOvertimeCategory" )
    private String timeSheetOvertimeCategory;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SenderPubSecFund</b>
     * </p>
     *
     * @param senderPubSecFund
     *
     * @return Sender Fund
     */
    @SerializedName( "SenderPubSecFund" )
    @JsonProperty( "SenderPubSecFund" )
    @Nullable
    @ODataField( odataName = "SenderPubSecFund" )
    private String senderPubSecFund;
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property from the Odata EDM: <b>SendingPubSecFunctionalArea</b>
     * </p>
     *
     * @param sendingPubSecFunctionalArea
     *
     * @return Sender Functional Area
     */
    @SerializedName( "SendingPubSecFunctionalArea" )
    @JsonProperty( "SendingPubSecFunctionalArea" )
    @Nullable
    @ODataField( odataName = "SendingPubSecFunctionalArea" )
    private String sendingPubSecFunctionalArea;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>SenderPubSecGrant</b>
     * </p>
     *
     * @param senderPubSecGrant
     *
     * @return Sender Grant
     */
    @SerializedName( "SenderPubSecGrant" )
    @JsonProperty( "SenderPubSecGrant" )
    @Nullable
    @ODataField( odataName = "SenderPubSecGrant" )
    private String senderPubSecGrant;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SenderPubSecBudgetPeriod</b>
     * </p>
     *
     * @param senderPubSecBudgetPeriod
     *
     * @return Sender Budget Period
     */
    @SerializedName( "SenderPubSecBudgetPeriod" )
    @JsonProperty( "SenderPubSecBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "SenderPubSecBudgetPeriod" )
    private String senderPubSecBudgetPeriod;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecFund</b>
     * </p>
     *
     * @param receiverPubSecFund
     *
     * @return Receiver Fund
     */
    @SerializedName( "ReceiverPubSecFund" )
    @JsonProperty( "ReceiverPubSecFund" )
    @Nullable
    @ODataField( odataName = "ReceiverPubSecFund" )
    private String receiverPubSecFund;
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecFuncnlArea</b>
     * </p>
     *
     * @param receiverPubSecFuncnlArea
     *
     * @return Receivier Functiona Area
     */
    @SerializedName( "ReceiverPubSecFuncnlArea" )
    @JsonProperty( "ReceiverPubSecFuncnlArea" )
    @Nullable
    @ODataField( odataName = "ReceiverPubSecFuncnlArea" )
    private String receiverPubSecFuncnlArea;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecGrant</b>
     * </p>
     *
     * @param receiverPubSecGrant
     *
     * @return Receiver Grant
     */
    @SerializedName( "ReceiverPubSecGrant" )
    @JsonProperty( "ReceiverPubSecGrant" )
    @Nullable
    @ODataField( odataName = "ReceiverPubSecGrant" )
    private String receiverPubSecGrant;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecBudgetPeriod</b>
     * </p>
     *
     * @param receiverPubSecBudgetPeriod
     *
     * @return Receiver Budget Period
     */
    @SerializedName( "ReceiverPubSecBudgetPeriod" )
    @JsonProperty( "ReceiverPubSecBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "ReceiverPubSecBudgetPeriod" )
    private String receiverPubSecBudgetPeriod;

    @Nonnull
    @Override
    public Class<TimeSheetDataFields> getType()
    {
        return TimeSheetDataFields.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("SenderCostCenter", getSenderCostCenter());
        values.put("ReceiverCostCenter", getReceiverCostCenter());
        values.put("InternalOrder", getInternalOrder());
        values.put("ActivityType", getActivityType());
        values.put("WBSElement", getWBSElement());
        values.put("WorkItem", getWorkItem());
        values.put("BillingControlCategory", getBillingControlCategory());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("TimeSheetTaskType", getTimeSheetTaskType());
        values.put("TimeSheetTaskLevel", getTimeSheetTaskLevel());
        values.put("TimeSheetTaskComponent", getTimeSheetTaskComponent());
        values.put("TimeSheetNote", getTimeSheetNote());
        values.put("RecordedHours", getRecordedHours());
        values.put("RecordedQuantity", getRecordedQuantity());
        values.put("HoursUnitOfMeasure", getHoursUnitOfMeasure());
        values.put("RejectionReason", getRejectionReason());
        values.put("TimeSheetWrkLocCode", getTimeSheetWrkLocCode());
        values.put("TimeSheetOvertimeCategory", getTimeSheetOvertimeCategory());
        values.put("SenderPubSecFund", getSenderPubSecFund());
        values.put("SendingPubSecFunctionalArea", getSendingPubSecFunctionalArea());
        values.put("SenderPubSecGrant", getSenderPubSecGrant());
        values.put("SenderPubSecBudgetPeriod", getSenderPubSecBudgetPeriod());
        values.put("ReceiverPubSecFund", getReceiverPubSecFund());
        values.put("ReceiverPubSecFuncnlArea", getReceiverPubSecFuncnlArea());
        values.put("ReceiverPubSecGrant", getReceiverPubSecGrant());
        values.put("ReceiverPubSecBudgetPeriod", getReceiverPubSecBudgetPeriod());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("SenderCostCenter") ) {
                final Object value = values.remove("SenderCostCenter");
                if( (value == null) || (!value.equals(getSenderCostCenter())) ) {
                    setSenderCostCenter(((String) value));
                }
            }
            if( values.containsKey("ReceiverCostCenter") ) {
                final Object value = values.remove("ReceiverCostCenter");
                if( (value == null) || (!value.equals(getReceiverCostCenter())) ) {
                    setReceiverCostCenter(((String) value));
                }
            }
            if( values.containsKey("InternalOrder") ) {
                final Object value = values.remove("InternalOrder");
                if( (value == null) || (!value.equals(getInternalOrder())) ) {
                    setInternalOrder(((String) value));
                }
            }
            if( values.containsKey("ActivityType") ) {
                final Object value = values.remove("ActivityType");
                if( (value == null) || (!value.equals(getActivityType())) ) {
                    setActivityType(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("WorkItem") ) {
                final Object value = values.remove("WorkItem");
                if( (value == null) || (!value.equals(getWorkItem())) ) {
                    setWorkItem(((String) value));
                }
            }
            if( values.containsKey("BillingControlCategory") ) {
                final Object value = values.remove("BillingControlCategory");
                if( (value == null) || (!value.equals(getBillingControlCategory())) ) {
                    setBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("TimeSheetTaskType") ) {
                final Object value = values.remove("TimeSheetTaskType");
                if( (value == null) || (!value.equals(getTimeSheetTaskType())) ) {
                    setTimeSheetTaskType(((String) value));
                }
            }
            if( values.containsKey("TimeSheetTaskLevel") ) {
                final Object value = values.remove("TimeSheetTaskLevel");
                if( (value == null) || (!value.equals(getTimeSheetTaskLevel())) ) {
                    setTimeSheetTaskLevel(((String) value));
                }
            }
            if( values.containsKey("TimeSheetTaskComponent") ) {
                final Object value = values.remove("TimeSheetTaskComponent");
                if( (value == null) || (!value.equals(getTimeSheetTaskComponent())) ) {
                    setTimeSheetTaskComponent(((String) value));
                }
            }
            if( values.containsKey("TimeSheetNote") ) {
                final Object value = values.remove("TimeSheetNote");
                if( (value == null) || (!value.equals(getTimeSheetNote())) ) {
                    setTimeSheetNote(((String) value));
                }
            }
            if( values.containsKey("RecordedHours") ) {
                final Object value = values.remove("RecordedHours");
                if( (value == null) || (!value.equals(getRecordedHours())) ) {
                    setRecordedHours(((BigDecimal) value));
                }
            }
            if( values.containsKey("RecordedQuantity") ) {
                final Object value = values.remove("RecordedQuantity");
                if( (value == null) || (!value.equals(getRecordedQuantity())) ) {
                    setRecordedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("HoursUnitOfMeasure") ) {
                final Object value = values.remove("HoursUnitOfMeasure");
                if( (value == null) || (!value.equals(getHoursUnitOfMeasure())) ) {
                    setHoursUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("RejectionReason") ) {
                final Object value = values.remove("RejectionReason");
                if( (value == null) || (!value.equals(getRejectionReason())) ) {
                    setRejectionReason(((String) value));
                }
            }
            if( values.containsKey("TimeSheetWrkLocCode") ) {
                final Object value = values.remove("TimeSheetWrkLocCode");
                if( (value == null) || (!value.equals(getTimeSheetWrkLocCode())) ) {
                    setTimeSheetWrkLocCode(((String) value));
                }
            }
            if( values.containsKey("TimeSheetOvertimeCategory") ) {
                final Object value = values.remove("TimeSheetOvertimeCategory");
                if( (value == null) || (!value.equals(getTimeSheetOvertimeCategory())) ) {
                    setTimeSheetOvertimeCategory(((String) value));
                }
            }
            if( values.containsKey("SenderPubSecFund") ) {
                final Object value = values.remove("SenderPubSecFund");
                if( (value == null) || (!value.equals(getSenderPubSecFund())) ) {
                    setSenderPubSecFund(((String) value));
                }
            }
            if( values.containsKey("SendingPubSecFunctionalArea") ) {
                final Object value = values.remove("SendingPubSecFunctionalArea");
                if( (value == null) || (!value.equals(getSendingPubSecFunctionalArea())) ) {
                    setSendingPubSecFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("SenderPubSecGrant") ) {
                final Object value = values.remove("SenderPubSecGrant");
                if( (value == null) || (!value.equals(getSenderPubSecGrant())) ) {
                    setSenderPubSecGrant(((String) value));
                }
            }
            if( values.containsKey("SenderPubSecBudgetPeriod") ) {
                final Object value = values.remove("SenderPubSecBudgetPeriod");
                if( (value == null) || (!value.equals(getSenderPubSecBudgetPeriod())) ) {
                    setSenderPubSecBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("ReceiverPubSecFund") ) {
                final Object value = values.remove("ReceiverPubSecFund");
                if( (value == null) || (!value.equals(getReceiverPubSecFund())) ) {
                    setReceiverPubSecFund(((String) value));
                }
            }
            if( values.containsKey("ReceiverPubSecFuncnlArea") ) {
                final Object value = values.remove("ReceiverPubSecFuncnlArea");
                if( (value == null) || (!value.equals(getReceiverPubSecFuncnlArea())) ) {
                    setReceiverPubSecFuncnlArea(((String) value));
                }
            }
            if( values.containsKey("ReceiverPubSecGrant") ) {
                final Object value = values.remove("ReceiverPubSecGrant");
                if( (value == null) || (!value.equals(getReceiverPubSecGrant())) ) {
                    setReceiverPubSecGrant(((String) value));
                }
            }
            if( values.containsKey("ReceiverPubSecBudgetPeriod") ) {
                final Object value = values.remove("ReceiverPubSecBudgetPeriod");
                if( (value == null) || (!value.equals(getReceiverPubSecBudgetPeriod())) ) {
                    setReceiverPubSecBudgetPeriod(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SenderCostCenter</b>
     * </p>
     *
     * @param senderCostCenter
     *            Sender Cost Center
     */
    public void setSenderCostCenter( @Nullable final String senderCostCenter )
    {
        rememberChangedField("SenderCostCenter", this.senderCostCenter);
        this.senderCostCenter = senderCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReceiverCostCenter</b>
     * </p>
     *
     * @param receiverCostCenter
     *            Receiver Cost Center
     */
    public void setReceiverCostCenter( @Nullable final String receiverCostCenter )
    {
        rememberChangedField("ReceiverCostCenter", this.receiverCostCenter);
        this.receiverCostCenter = receiverCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *            Internal Order
     */
    public void setInternalOrder( @Nullable final String internalOrder )
    {
        rememberChangedField("InternalOrder", this.internalOrder);
        this.internalOrder = internalOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @param activityType
     *            Activity Type
     */
    public void setActivityType( @Nullable final String activityType )
    {
        rememberChangedField("ActivityType", this.activityType);
        this.activityType = activityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            WBS Element
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *            Work Item
     */
    public void setWorkItem( @Nullable final String workItem )
    {
        rememberChangedField("WorkItem", this.workItem);
        this.workItem = workItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @param billingControlCategory
     *            Billing Control Category
     */
    public void setBillingControlCategory( @Nullable final String billingControlCategory )
    {
        rememberChangedField("BillingControlCategory", this.billingControlCategory);
        this.billingControlCategory = billingControlCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Purchase Order Item
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetTaskType</b>
     * </p>
     *
     * @param timeSheetTaskType
     *            Time Sheet Task Type
     */
    public void setTimeSheetTaskType( @Nullable final String timeSheetTaskType )
    {
        rememberChangedField("TimeSheetTaskType", this.timeSheetTaskType);
        this.timeSheetTaskType = timeSheetTaskType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetTaskLevel</b>
     * </p>
     *
     * @param timeSheetTaskLevel
     *            Time Sheet Task Level
     */
    public void setTimeSheetTaskLevel( @Nullable final String timeSheetTaskLevel )
    {
        rememberChangedField("TimeSheetTaskLevel", this.timeSheetTaskLevel);
        this.timeSheetTaskLevel = timeSheetTaskLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetTaskComponent</b>
     * </p>
     *
     * @param timeSheetTaskComponent
     *            Time Sheet Task Component
     */
    public void setTimeSheetTaskComponent( @Nullable final String timeSheetTaskComponent )
    {
        rememberChangedField("TimeSheetTaskComponent", this.timeSheetTaskComponent);
        this.timeSheetTaskComponent = timeSheetTaskComponent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetNote</b>
     * </p>
     *
     * @param timeSheetNote
     *            Time Sheet Note
     */
    public void setTimeSheetNote( @Nullable final String timeSheetNote )
    {
        rememberChangedField("TimeSheetNote", this.timeSheetNote);
        this.timeSheetNote = timeSheetNote;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>RecordedHours</b>
     * </p>
     *
     * @param recordedHours
     *            Recorded Hours
     */
    public void setRecordedHours( @Nullable final BigDecimal recordedHours )
    {
        rememberChangedField("RecordedHours", this.recordedHours);
        this.recordedHours = recordedHours;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>RecordedQuantity</b>
     * </p>
     *
     * @param recordedQuantity
     *            Recorded Quantity
     */
    public void setRecordedQuantity( @Nullable final BigDecimal recordedQuantity )
    {
        rememberChangedField("RecordedQuantity", this.recordedQuantity);
        this.recordedQuantity = recordedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>HoursUnitOfMeasure</b>
     * </p>
     *
     * @param hoursUnitOfMeasure
     *            Hours Unit Of Measure
     */
    public void setHoursUnitOfMeasure( @Nullable final String hoursUnitOfMeasure )
    {
        rememberChangedField("HoursUnitOfMeasure", this.hoursUnitOfMeasure);
        this.hoursUnitOfMeasure = hoursUnitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>RejectionReason</b>
     * </p>
     *
     * @param rejectionReason
     *            Rejection Reason
     */
    public void setRejectionReason( @Nullable final String rejectionReason )
    {
        rememberChangedField("RejectionReason", this.rejectionReason);
        this.rejectionReason = rejectionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetWrkLocCode</b>
     * </p>
     *
     * @param timeSheetWrkLocCode
     *            Time Sheet Work Location Code
     */
    public void setTimeSheetWrkLocCode( @Nullable final String timeSheetWrkLocCode )
    {
        rememberChangedField("TimeSheetWrkLocCode", this.timeSheetWrkLocCode);
        this.timeSheetWrkLocCode = timeSheetWrkLocCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *            Time Sheet Overtime Category
     */
    public void setTimeSheetOvertimeCategory( @Nullable final String timeSheetOvertimeCategory )
    {
        rememberChangedField("TimeSheetOvertimeCategory", this.timeSheetOvertimeCategory);
        this.timeSheetOvertimeCategory = timeSheetOvertimeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SenderPubSecFund</b>
     * </p>
     *
     * @param senderPubSecFund
     *            Sender Fund
     */
    public void setSenderPubSecFund( @Nullable final String senderPubSecFund )
    {
        rememberChangedField("SenderPubSecFund", this.senderPubSecFund);
        this.senderPubSecFund = senderPubSecFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property from the Odata EDM: <b>SendingPubSecFunctionalArea</b>
     * </p>
     *
     * @param sendingPubSecFunctionalArea
     *            Sender Functional Area
     */
    public void setSendingPubSecFunctionalArea( @Nullable final String sendingPubSecFunctionalArea )
    {
        rememberChangedField("SendingPubSecFunctionalArea", this.sendingPubSecFunctionalArea);
        this.sendingPubSecFunctionalArea = sendingPubSecFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>SenderPubSecGrant</b>
     * </p>
     *
     * @param senderPubSecGrant
     *            Sender Grant
     */
    public void setSenderPubSecGrant( @Nullable final String senderPubSecGrant )
    {
        rememberChangedField("SenderPubSecGrant", this.senderPubSecGrant);
        this.senderPubSecGrant = senderPubSecGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SenderPubSecBudgetPeriod</b>
     * </p>
     *
     * @param senderPubSecBudgetPeriod
     *            Sender Budget Period
     */
    public void setSenderPubSecBudgetPeriod( @Nullable final String senderPubSecBudgetPeriod )
    {
        rememberChangedField("SenderPubSecBudgetPeriod", this.senderPubSecBudgetPeriod);
        this.senderPubSecBudgetPeriod = senderPubSecBudgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecFund</b>
     * </p>
     *
     * @param receiverPubSecFund
     *            Receiver Fund
     */
    public void setReceiverPubSecFund( @Nullable final String receiverPubSecFund )
    {
        rememberChangedField("ReceiverPubSecFund", this.receiverPubSecFund);
        this.receiverPubSecFund = receiverPubSecFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecFuncnlArea</b>
     * </p>
     *
     * @param receiverPubSecFuncnlArea
     *            Receivier Functiona Area
     */
    public void setReceiverPubSecFuncnlArea( @Nullable final String receiverPubSecFuncnlArea )
    {
        rememberChangedField("ReceiverPubSecFuncnlArea", this.receiverPubSecFuncnlArea);
        this.receiverPubSecFuncnlArea = receiverPubSecFuncnlArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecGrant</b>
     * </p>
     *
     * @param receiverPubSecGrant
     *            Receiver Grant
     */
    public void setReceiverPubSecGrant( @Nullable final String receiverPubSecGrant )
    {
        rememberChangedField("ReceiverPubSecGrant", this.receiverPubSecGrant);
        this.receiverPubSecGrant = receiverPubSecGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReceiverPubSecBudgetPeriod</b>
     * </p>
     *
     * @param receiverPubSecBudgetPeriod
     *            Receiver Budget Period
     */
    public void setReceiverPubSecBudgetPeriod( @Nullable final String receiverPubSecBudgetPeriod )
    {
        rememberChangedField("ReceiverPubSecBudgetPeriod", this.receiverPubSecBudgetPeriod);
        this.receiverPubSecBudgetPeriod = receiverPubSecBudgetPeriod;
    }

}
