/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.field.TimeSheetEntryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.selectable.TimeSheetEntrySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Workforce Timesheet
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TimeSheetEntry</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TimeSheetEntry extends VdmEntity<TimeSheetEntry>
{

    /**
     * Selector for all available fields of TimeSheetEntry.
     *
     */
    public final static TimeSheetEntrySelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetDataFields</b>
     * </p>
     *
     * @return The timeSheetDataFields contained in this entity.
     */
    @SerializedName( "TimeSheetDataFields" )
    @JsonProperty( "TimeSheetDataFields" )
    @Nullable
    @ODataField( odataName = "TimeSheetDataFields" )
    private TimeSheetDataFields timeSheetDataFields;
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreementExternalID</b>
     * </p>
     *
     * @return Person Work Agreement External ID
     */
    @Key
    @SerializedName( "PersonWorkAgreementExternalID" )
    @JsonProperty( "PersonWorkAgreementExternalID" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreementExternalID" )
    private String personWorkAgreementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreementExternalID</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> PERSON_WORK_AGREEMENT_EXTERNAL_ID =
        new TimeSheetEntryField<String>("PersonWorkAgreementExternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> COMPANY_CODE = new TimeSheetEntryField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetRecord</b>
     * </p>
     *
     * @return Time Sheet Record
     */
    @Key
    @SerializedName( "TimeSheetRecord" )
    @JsonProperty( "TimeSheetRecord" )
    @Nullable
    @ODataField( odataName = "TimeSheetRecord" )
    private String timeSheetRecord;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetRecord</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> TIME_SHEET_RECORD =
        new TimeSheetEntryField<String>("TimeSheetRecord");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @return Person Work Agreement
     */
    @SerializedName( "PersonWorkAgreement" )
    @JsonProperty( "PersonWorkAgreement" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreement" )
    private String personWorkAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreement</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> PERSON_WORK_AGREEMENT =
        new TimeSheetEntryField<String>("PersonWorkAgreement");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetDate</b>
     * </p>
     *
     * @return Time Sheet Date
     */
    @SerializedName( "TimeSheetDate" )
    @JsonProperty( "TimeSheetDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TimeSheetDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime timeSheetDate;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetDate</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<LocalDateTime> TIME_SHEET_DATE =
        new TimeSheetEntryField<LocalDateTime>("TimeSheetDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetIsReleasedOnSave</b>
     * </p>
     *
     * @return Time sheet Is Released On Save
     */
    @SerializedName( "TimeSheetIsReleasedOnSave" )
    @JsonProperty( "TimeSheetIsReleasedOnSave" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TimeSheetIsReleasedOnSave" )
    private Boolean timeSheetIsReleasedOnSave;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetIsReleasedOnSave</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<Boolean> TIME_SHEET_IS_RELEASED_ON_SAVE =
        new TimeSheetEntryField<Boolean>("TimeSheetIsReleasedOnSave");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetPredecessorRecord</b>
     * </p>
     *
     * @return Time Sheet Predecessor Record
     */
    @SerializedName( "TimeSheetPredecessorRecord" )
    @JsonProperty( "TimeSheetPredecessorRecord" )
    @Nullable
    @ODataField( odataName = "TimeSheetPredecessorRecord" )
    private String timeSheetPredecessorRecord;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetPredecessorRecord</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> TIME_SHEET_PREDECESSOR_RECORD =
        new TimeSheetEntryField<String>("TimeSheetPredecessorRecord");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetStatus</b>
     * </p>
     *
     * @return Time Sheet Status
     */
    @SerializedName( "TimeSheetStatus" )
    @JsonProperty( "TimeSheetStatus" )
    @Nullable
    @ODataField( odataName = "TimeSheetStatus" )
    private String timeSheetStatus;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetStatus</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> TIME_SHEET_STATUS =
        new TimeSheetEntryField<String>("TimeSheetStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetIsExecutedInTestRun</b>
     * </p>
     *
     * @return Times Sheet Is Executed In Test Run
     */
    @SerializedName( "TimeSheetIsExecutedInTestRun" )
    @JsonProperty( "TimeSheetIsExecutedInTestRun" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TimeSheetIsExecutedInTestRun" )
    private Boolean timeSheetIsExecutedInTestRun;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetIsExecutedInTestRun</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<Boolean> TIME_SHEET_IS_EXECUTED_IN_TEST_RUN =
        new TimeSheetEntryField<Boolean>("TimeSheetIsExecutedInTestRun");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOperation</b>
     * </p>
     *
     * @return Time Sheet Operation
     */
    @SerializedName( "TimeSheetOperation" )
    @JsonProperty( "TimeSheetOperation" )
    @Nullable
    @ODataField( odataName = "TimeSheetOperation" )
    private String timeSheetOperation;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetOperation</b> field to query operations.
     *
     */
    public final static TimeSheetEntryField<String> TIME_SHEET_OPERATION =
        new TimeSheetEntryField<String>("TimeSheetOperation");

    @Nonnull
    @Override
    public Class<TimeSheetEntry> getType()
    {
        return TimeSheetEntry.class;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetDataFields</b>
     * </p>
     *
     * @param timeSheetDataFields
     *            The timeSheetDataFields to set.
     */
    public void setTimeSheetDataFields( @Nullable final TimeSheetDataFields timeSheetDataFields )
    {
        rememberChangedField("TimeSheetDataFields", this.timeSheetDataFields);
        this.timeSheetDataFields = timeSheetDataFields;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreementExternalID</b>
     * </p>
     *
     * @param personWorkAgreementExternalID
     *            Person Work Agreement External ID
     */
    public void setPersonWorkAgreementExternalID( @Nullable final String personWorkAgreementExternalID )
    {
        rememberChangedField("PersonWorkAgreementExternalID", this.personWorkAgreementExternalID);
        this.personWorkAgreementExternalID = personWorkAgreementExternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetRecord</b>
     * </p>
     *
     * @param timeSheetRecord
     *            Time Sheet Record
     */
    public void setTimeSheetRecord( @Nullable final String timeSheetRecord )
    {
        rememberChangedField("TimeSheetRecord", this.timeSheetRecord);
        this.timeSheetRecord = timeSheetRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @param personWorkAgreement
     *            Person Work Agreement
     */
    public void setPersonWorkAgreement( @Nullable final String personWorkAgreement )
    {
        rememberChangedField("PersonWorkAgreement", this.personWorkAgreement);
        this.personWorkAgreement = personWorkAgreement;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetDate</b>
     * </p>
     *
     * @param timeSheetDate
     *            Time Sheet Date
     */
    public void setTimeSheetDate( @Nullable final LocalDateTime timeSheetDate )
    {
        rememberChangedField("TimeSheetDate", this.timeSheetDate);
        this.timeSheetDate = timeSheetDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetIsReleasedOnSave</b>
     * </p>
     *
     * @param timeSheetIsReleasedOnSave
     *            Time sheet Is Released On Save
     */
    public void setTimeSheetIsReleasedOnSave( @Nullable final Boolean timeSheetIsReleasedOnSave )
    {
        rememberChangedField("TimeSheetIsReleasedOnSave", this.timeSheetIsReleasedOnSave);
        this.timeSheetIsReleasedOnSave = timeSheetIsReleasedOnSave;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetPredecessorRecord</b>
     * </p>
     *
     * @param timeSheetPredecessorRecord
     *            Time Sheet Predecessor Record
     */
    public void setTimeSheetPredecessorRecord( @Nullable final String timeSheetPredecessorRecord )
    {
        rememberChangedField("TimeSheetPredecessorRecord", this.timeSheetPredecessorRecord);
        this.timeSheetPredecessorRecord = timeSheetPredecessorRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetStatus</b>
     * </p>
     *
     * @param timeSheetStatus
     *            Time Sheet Status
     */
    public void setTimeSheetStatus( @Nullable final String timeSheetStatus )
    {
        rememberChangedField("TimeSheetStatus", this.timeSheetStatus);
        this.timeSheetStatus = timeSheetStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetIsExecutedInTestRun</b>
     * </p>
     *
     * @param timeSheetIsExecutedInTestRun
     *            Times Sheet Is Executed In Test Run
     */
    public void setTimeSheetIsExecutedInTestRun( @Nullable final Boolean timeSheetIsExecutedInTestRun )
    {
        rememberChangedField("TimeSheetIsExecutedInTestRun", this.timeSheetIsExecutedInTestRun);
        this.timeSheetIsExecutedInTestRun = timeSheetIsExecutedInTestRun;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOperation</b>
     * </p>
     *
     * @param timeSheetOperation
     *            Time Sheet Operation
     */
    public void setTimeSheetOperation( @Nullable final String timeSheetOperation )
    {
        rememberChangedField("TimeSheetOperation", this.timeSheetOperation);
        this.timeSheetOperation = timeSheetOperation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "TimeSheetEntryCollection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PersonWorkAgreementExternalID", getPersonWorkAgreementExternalID());
        result.put("CompanyCode", getCompanyCode());
        result.put("TimeSheetRecord", getTimeSheetRecord());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("TimeSheetDataFields", getTimeSheetDataFields());
        values.put("PersonWorkAgreementExternalID", getPersonWorkAgreementExternalID());
        values.put("CompanyCode", getCompanyCode());
        values.put("TimeSheetRecord", getTimeSheetRecord());
        values.put("PersonWorkAgreement", getPersonWorkAgreement());
        values.put("TimeSheetDate", getTimeSheetDate());
        values.put("TimeSheetIsReleasedOnSave", getTimeSheetIsReleasedOnSave());
        values.put("TimeSheetPredecessorRecord", getTimeSheetPredecessorRecord());
        values.put("TimeSheetStatus", getTimeSheetStatus());
        values.put("TimeSheetIsExecutedInTestRun", getTimeSheetIsExecutedInTestRun());
        values.put("TimeSheetOperation", getTimeSheetOperation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PersonWorkAgreementExternalID") ) {
                final Object value = values.remove("PersonWorkAgreementExternalID");
                if( (value == null) || (!value.equals(getPersonWorkAgreementExternalID())) ) {
                    setPersonWorkAgreementExternalID(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("TimeSheetRecord") ) {
                final Object value = values.remove("TimeSheetRecord");
                if( (value == null) || (!value.equals(getTimeSheetRecord())) ) {
                    setTimeSheetRecord(((String) value));
                }
            }
            if( values.containsKey("PersonWorkAgreement") ) {
                final Object value = values.remove("PersonWorkAgreement");
                if( (value == null) || (!value.equals(getPersonWorkAgreement())) ) {
                    setPersonWorkAgreement(((String) value));
                }
            }
            if( values.containsKey("TimeSheetDate") ) {
                final Object value = values.remove("TimeSheetDate");
                if( (value == null) || (!value.equals(getTimeSheetDate())) ) {
                    setTimeSheetDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TimeSheetIsReleasedOnSave") ) {
                final Object value = values.remove("TimeSheetIsReleasedOnSave");
                if( (value == null) || (!value.equals(getTimeSheetIsReleasedOnSave())) ) {
                    setTimeSheetIsReleasedOnSave(((Boolean) value));
                }
            }
            if( values.containsKey("TimeSheetPredecessorRecord") ) {
                final Object value = values.remove("TimeSheetPredecessorRecord");
                if( (value == null) || (!value.equals(getTimeSheetPredecessorRecord())) ) {
                    setTimeSheetPredecessorRecord(((String) value));
                }
            }
            if( values.containsKey("TimeSheetStatus") ) {
                final Object value = values.remove("TimeSheetStatus");
                if( (value == null) || (!value.equals(getTimeSheetStatus())) ) {
                    setTimeSheetStatus(((String) value));
                }
            }
            if( values.containsKey("TimeSheetIsExecutedInTestRun") ) {
                final Object value = values.remove("TimeSheetIsExecutedInTestRun");
                if( (value == null) || (!value.equals(getTimeSheetIsExecutedInTestRun())) ) {
                    setTimeSheetIsExecutedInTestRun(((Boolean) value));
                }
            }
            if( values.containsKey("TimeSheetOperation") ) {
                final Object value = values.remove("TimeSheetOperation");
                if( (value == null) || (!value.equals(getTimeSheetOperation())) ) {
                    setTimeSheetOperation(((String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("TimeSheetDataFields") ) {
                final Object value = values.remove("TimeSheetDataFields");
                if( value instanceof Map ) {
                    if( getTimeSheetDataFields() == null ) {
                        setTimeSheetDataFields(new TimeSheetDataFields());
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    getTimeSheetDataFields().fromMap(inputMap);
                }
                if( (value == null) && (getTimeSheetDataFields() != null) ) {
                    setTimeSheetDataFields(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> TimeSheetEntryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TimeSheetEntryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TimeSheetEntryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TimeSheetEntryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService.DEFAULT_SERVICE_PATH);
    }

}
