/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.selectable.TimeSheetEntrySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry TimeSheetEntry} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class TimeSheetEntryByKeyFluentHelper
    extends
    FluentHelperByKey<TimeSheetEntryByKeyFluentHelper, TimeSheetEntry, TimeSheetEntrySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry TimeSheetEntry}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param personWorkAgreementExternalID
     *            Person Work Agreement External ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code TimeSheetEntry}
     * @param servicePath
     *            Service path to be used to fetch a single {@code TimeSheetEntry}
     * @param timeSheetRecord
     *            Time Sheet Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public TimeSheetEntryByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String personWorkAgreementExternalID,
        final String companyCode,
        final String timeSheetRecord )
    {
        super(servicePath, entityCollection);
        this.key.put("PersonWorkAgreementExternalID", personWorkAgreementExternalID);
        this.key.put("CompanyCode", companyCode);
        this.key.put("TimeSheetRecord", timeSheetRecord);
    }

    @Override
    @Nonnull
    protected Class<TimeSheetEntry> getEntityClass()
    {
        return TimeSheetEntry.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
