/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WorkforceTimesheetServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService WorkforceTimesheetService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWorkforceTimesheetServiceBatch
    extends
    BatchFluentHelperBasic<WorkforceTimesheetServiceBatch, WorkforceTimesheetServiceBatchChangeSet>
    implements
    WorkforceTimesheetServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWorkforceTimesheetServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWorkforceTimesheetServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWorkforceTimesheetServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWorkforceTimesheetServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWorkforceTimesheetServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkforceTimesheetServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWorkforceTimesheetServiceBatchChangeSet(this, service);
    }

}
