/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry;

/**
 * Implementation of the {@link WorkforceTimesheetServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService WorkforceTimesheetService}.
 *
 */
public class DefaultWorkforceTimesheetServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WorkforceTimesheetServiceBatch, WorkforceTimesheetServiceBatchChangeSet>
    implements
    WorkforceTimesheetServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService service;

    @SuppressWarnings( "deprecation" )
    DefaultWorkforceTimesheetServiceBatchChangeSet(
        @Nonnull final DefaultWorkforceTimesheetServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkforceTimesheetService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWorkforceTimesheetServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkforceTimesheetServiceBatchChangeSet createTimeSheetEntry( @Nonnull final TimeSheetEntry timeSheetEntry )
    {
        return addRequestCreate(service::createTimeSheetEntry, timeSheetEntry);
    }

}
