/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry TimeSheetEntry}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.field.TimeSheetEntryField
 * TimeSheetEntryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.link.TimeSheetEntryLink
 * TimeSheetEntryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#PERSON_WORK_AGREEMENT_EXTERNAL_ID
 * PERSON_WORK_AGREEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_RECORD
 * TIME_SHEET_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#PERSON_WORK_AGREEMENT
 * PERSON_WORK_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_DATE
 * TIME_SHEET_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_IS_RELEASED_ON_SAVE
 * TIME_SHEET_IS_RELEASED_ON_SAVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_PREDECESSOR_RECORD
 * TIME_SHEET_PREDECESSOR_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_STATUS
 * TIME_SHEET_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_IS_EXECUTED_IN_TEST_RUN
 * TIME_SHEET_IS_EXECUTED_IN_TEST_RUN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry#TIME_SHEET_OPERATION
 * TIME_SHEET_OPERATION}</li>
 * </ul>
 *
 */
public interface TimeSheetEntrySelectable extends EntitySelectable<TimeSheetEntry>
{

}
