/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.AllowlistByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.AllowlistFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.batch.AllowlistIntercompanyPostingServiceBatch;

/**
 * <p>
 *
 * The service returns allowlist of sender/receiver company code combinations for intercompany postings. Filters,
 * sorting, and other OData operations can be used..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2f/23aff8bdcc449ebd2cba390d360527/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FCO_ICO_RESTRICTION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FCO_ICO_RESTRICTION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Block Intercompany Postings Integration(SAP_COM_0745)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O54'>Overhead Cost Accounting(O54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Company Code</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface AllowlistIntercompanyPostingService extends BatchService<AllowlistIntercompanyPostingServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FCO_ICO_RESTRICTION";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    AllowlistIntercompanyPostingService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist
     * Allowlist} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist
     *         Allowlist} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.AllowlistFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AllowlistFluentHelper getAllAllowlist();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist
     * Allowlist} entity using key fields.
     *
     * @param senderCompanyCode
     *            Sender Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param receiverCompanyCode
     *            Receiver Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist
     *         Allowlist} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.AllowlistByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AllowlistByKeyFluentHelper getAllowlistByKey( final String senderCompanyCode, final String receiverCompanyCode );

}
