/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AssignDocumentToBusinessObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.CreateUrlAsAttachmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttchByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttchCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttchFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetAllOriginalsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetAttachmentCountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetSAPObjectDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.LinkAttachmentToSAPObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.RenameAttachmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.batch.AttachmentServiceBatch;

/**
 * <p>
 *
 * This service allows you to manage attachments and attachment URLs for business objects. You can perform operations
 * such as create, read, rename, and deletion of attachments. You can also read an existing document info record (DIR),
 * and add attachments to it. The service returns an appropriate success or error response while performing the
 * attachment operations.
 *
 * Consumers of this service can configure the Harmonized Document Management (HDM) functionality to support attachments
 * from various document frameworks such as Generic Object Services (GOS), Document Management System (DMS), and
 * ArchiveLink. If this configuration has been maintained, this service also supports uploading and downloading of
 * attachments that are larger than 100MB.
 *
 * If the HDM configuration has not been maintained for a business object, then this service supports attachments only
 * from the GOS and DMS document frameworks. For more information on HDM, refer to the Business Documentation linked
 * below. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2e/1be0a60d08400b8e4b1f6b57140a28/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CV_ATTACHMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CV_ATTACHMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Posting Integration(SAP_COM_0002), Business Partner, Customer and Supplier Integration(SAP_COM_0008),
 * Purchase Order Integration(SAP_COM_0053), Commercial Project Integration(SAP_COM_0054), Supplier Invoice
 * Integration(SAP_COM_0057), Distributed Manufacturing Integration(SAP_COM_0077), Purchase Requisition
 * Integration(SAP_COM_0102), Product Lifecycle Management - Master Data Integration(SAP_COM_0105), Sales Order
 * Integration(SAP_COM_0109), Billing Integration(SAP_COM_0120), Quality Notification and Defect Processing
 * Integration(SAP_COM_0153), Legal Document Integration(SAP_COM_0178), SAP S/4HANA Procurement Hub - Ariba GB - Hub to
 * Ariba GB Integration(SAP_COM_0292), Enterprise Project Integration(SAP_COM_0308), Service Order OData
 * Integration(SAP_COM_0350), Service Quotation Integration(SAP_COM_0355), Joint Venture Partner Billing Files
 * Integration(SAP_COM_0381), Warehousing - Attachment Service Integration(SAP_COM_0386), Asset Management Master Data
 * Integration(SAP_COM_0395), Maintenance Processing Integration(SAP_COM_0397), SAP S/4HANA Procurement Hub - Central
 * Invoice Satellite Integration(SAP_COM_0516), Next-Generation Buying Experience Integration(SAP_COM_0545), Business
 * Solution Order Integration(SAP_COM_0706), Service Order Template Integration(SAP_COM_0715), Service - Repair Order
 * Integration(SAP_COM_0742), Service - Repair Quotation Integration(SAP_COM_0744), Transportation Management - Freight
 * Agreement Integration(SAP_COM_0756), Procurement - Supplier Quotation Management Integration(SAP_COM_0760), Warranty
 * Claim Management Integration(SAP_COM_0766), Product Compliance - Integration(SAP_COM_0797)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O58'>Accounting and Financial Close(O58)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1RO'>Master Data Integration(1RO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4N6'>SAP Central Invoice Management Backend Enablement(4N6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4R2'>Service Procurement with Ariba Network and SAP
 * Fieldglass(4R2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1A8'>Internal Project Management - Project-Based
 * Services(1A8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J11'>Customer Project Management - Project-Based
 * Services(J11)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital
 * Manufacturing Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2NV'>Guided Buying Capability with SAP
 * Ariba Buying(2NV)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/O8J'>Requisitioning(O8J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONV'>Guided Buying Capability with SAP Ariba Buying(ONV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/18J'>Requisitioning(18J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AI'>Next-Generation Buying Experience(4AI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QI'>Opportunity-to-Order with Third-Party Sales Force Automation Apps
 * (Deprecated)(1QI)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2TY'>B2B Order Fulfillment with SAP Commerce
 * Cloud(2TY)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1Z6'>External Billing(1Z6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OZ6'>External Billing(OZ6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3EN'>Guided Buying for Central Procurement with SAP Ariba
 * Buying(3EN)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NT'>Project Control - Finance(1NT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YF'>Project Review(1YF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONT'>Project Control - Finance(ONT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OYF'>Project Review(OYF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3F7'>Joint Venture Accounting(3F7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3BR'>Warehouse Inbound Processing(3BR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3BS'>Warehouse Outbound Processing(3BS)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3DV'>Warehouse Production Integration(3DV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/41G'>Central Invoicing(41G)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4GT'>Solution Order Management(4GT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3EP'>Order-Based Transportation Consolidation – Outbound(3EP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4MO'>Manual Transportation Planning – Outbound(4MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/5OS'>Manual Transportation Planning – Inbound(5OS)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/5VV'>Order-Based Transportation Consolidation - Inbound(5VV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/5XC'>Stock Transport Order-Based Transportation
 * Consolidation(5XC)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/5XD'>Manual Transportation Planning - Stock
 * Transport Order(5XD)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/64A'>Manual Transportation Planning for
 * Ocean Freight - Outbound(64A)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/64B'>Manual Transportation Planning
 * for Ocean Freight - Inbound(64B)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/64C'>Manual Transportation
 * Planning for Ocean Freight - STO(64C)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/6B2'>Manual Transportation
 * Planning for Air Freight - Outbound(6B2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/6B3'>Manual
 * Transportation Planning for Air Freight - Inbound(6B3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6B4'>Manual Transportation Planning for Air Freight - STO(6B4)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6BG'>Intercompany Transportation - Outbound(6BG)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6BH'>Intercompany Transportation - Stock Transport Order(6BH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/5HR'>Warranty Claim Management - Supplier Recovery
 * Processing(5HR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/OHR'>Warranty Claim Management - Supplier
 * Recovery Processing(OHR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/31G'>Chemical Compliance Approval for
 * Purchased Material and Supplier(31G)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/31H'>Assess Marketability of
 * a Product(31H)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3FC'>Assess Dangerous Goods for a
 * Product(3FC)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3VR'>Manage Safety Data Sheets for
 * Products(3VR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4OL'>Substance Volume Tracking(4OL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6AV'>Request Regulatory Documentation from Service
 * Provider(6AV)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Attachment</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface AttachmentService extends BatchService<AttachmentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CV_ATTACHMENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    AttachmentService withServicePath( @Nonnull final String servicePath );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     * AttachmentContent} entity and save it to the S/4HANA system.
     *
     * @param attachmentContent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     *            AttachmentContent} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     *         AttachmentContent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AttachmentContentCreateFluentHelper createAttachmentContent( @Nonnull final AttachmentContent attachmentContent );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     * AttachmentContent} entity in the S/4HANA system.
     *
     * @param attachmentContent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     *            AttachmentContent} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
     *         AttachmentContent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AttachmentContentDeleteFluentHelper deleteAttachmentContent( @Nonnull final AttachmentContent attachmentContent );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     * AttachmentHarmonizedOperation} entity using key fields.
     *
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *         AttachmentHarmonizedOperation} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AttachmentHarmonizedOperationByKeyFluentHelper getAttachmentHarmonizedOperationByKey(
        final String logicalDocument,
        final String archiveDocumentID,
        final String linkedSAPObjectKey,
        final String sAPObjectType,
        final String harmonizedDocumentType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     * AttachmentHarmonizedOperation} entity and save it to the S/4HANA system.
     *
     * @param attachmentHarmonizedOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *            AttachmentHarmonizedOperation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *         AttachmentHarmonizedOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AttachmentHarmonizedOperationCreateFluentHelper createAttachmentHarmonizedOperation(
        @Nonnull final AttachmentHarmonizedOperation attachmentHarmonizedOperation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     * AttachmentHarmonizedOperation} entity in the S/4HANA system.
     *
     * @param attachmentHarmonizedOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *            AttachmentHarmonizedOperation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     *         AttachmentHarmonizedOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AttachmentHarmonizedOperationDeleteFluentHelper deleteAttachmentHarmonizedOperation(
        @Nonnull final AttachmentHarmonizedOperation attachmentHarmonizedOperation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     * DocumentInfoRecordAttch} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     *         DocumentInfoRecordAttch} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttchFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordAttchFluentHelper getAllDocumentInfoRecordAttch();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     * DocumentInfoRecordAttch} entity using key fields.
     *
     * @param documentInfoRecordDocType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocNumber
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentInfoRecordDocPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentInfoRecordDocVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     *         DocumentInfoRecordAttch} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttchByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordAttchByKeyFluentHelper getDocumentInfoRecordAttchByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     * DocumentInfoRecordAttch} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecordAttch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     *            DocumentInfoRecordAttch} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttch
     *         DocumentInfoRecordAttch} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.DocumentInfoRecordAttchCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DocumentInfoRecordAttchCreateFluentHelper
        createDocumentInfoRecordAttch( @Nonnull final DocumentInfoRecordAttch documentInfoRecordAttch );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetAllOriginals</b> OData function import.
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetAllOriginals</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetAllOriginalsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetAllOriginalsFluentHelper getAllOriginals(
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String businessObjectTypeName,
        @Nullable final String semanticObject );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetAllOriginals</b> OData function import.
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetAllOriginals</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetAllOriginalsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetAllOriginalsFluentHelper getAllOriginals(
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String businessObjectTypeName,
        @Nullable final String semanticObject,
        @Nullable final String sAPObjectType,
        @Nullable final String sAPObjectNodeType );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetAttachmentCount</b> OData function import.
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetAttachmentCount</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetAttachmentCountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetAttachmentCountFluentHelper getAttachmentCount(
        @Nullable final String businessObjectTypeName,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String semanticObject );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetAttachmentCount</b> OData function import.
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetAttachmentCount</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetAttachmentCountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetAttachmentCountFluentHelper getAttachmentCount(
        @Nullable final String businessObjectTypeName,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String semanticObject,
        @Nullable final String sAPObjectType,
        @Nullable final String sAPObjectNodeType );

    /**
     * <p>
     * Creates a fluent helper for the <b>RenameAttachment</b> OData function import.
     * </p>
     *
     * @param documentInfoRecordDocType
     *            DocumentInfoRecordDocType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     *            </p>
     * @param fileName
     *            FileName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 255
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FileName</b>
     *            </p>
     * @param documentInfoRecordDocNumber
     *            DocumentInfoRecordDocNumber
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     *            </p>
     * @param documentInfoRecordDocPart
     *            DocumentInfoRecordDocPart
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     *            </p>
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param documentInfoRecordDocVersion
     *            DocumentInfoRecordDocVersion
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LogicalDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RenameAttachment</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.RenameAttachmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RenameAttachmentFluentHelper renameAttachment(
        @Nullable final String documentInfoRecordDocType,
        @Nullable final String documentInfoRecordDocVersion,
        @Nonnull final String logicalDocument,
        @Nonnull final String archiveDocumentID,
        @Nullable final String businessObjectTypeName,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String semanticObject,
        @Nonnull final String fileName,
        @Nullable final String documentInfoRecordDocNumber,
        @Nullable final String documentInfoRecordDocPart );

    /**
     * <p>
     * Creates a fluent helper for the <b>RenameAttachment</b> OData function import.
     * </p>
     *
     * @param documentInfoRecordDocType
     *            DocumentInfoRecordDocType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     *            </p>
     * @param fileName
     *            FileName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 255
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FileName</b>
     *            </p>
     * @param documentInfoRecordDocNumber
     *            DocumentInfoRecordDocNumber
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     *            </p>
     * @param documentInfoRecordDocPart
     *            DocumentInfoRecordDocPart
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     *            </p>
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param documentInfoRecordDocVersion
     *            DocumentInfoRecordDocVersion
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LogicalDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RenameAttachment</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.RenameAttachmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RenameAttachmentFluentHelper renameAttachment(
        @Nullable final String documentInfoRecordDocType,
        @Nullable final String documentInfoRecordDocVersion,
        @Nonnull final String logicalDocument,
        @Nonnull final String archiveDocumentID,
        @Nullable final String businessObjectTypeName,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String semanticObject,
        @Nonnull final String fileName,
        @Nullable final String documentInfoRecordDocNumber,
        @Nullable final String documentInfoRecordDocPart,
        @Nullable final String sAPObjectNodeType,
        @Nullable final String sAPObjectType );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetSAPObjectDocumentType</b> OData function import.
     * </p>
     *
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetSAPObjectDocumentType</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.GetSAPObjectDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetSAPObjectDocumentFluentHelper
        getSAPObjectDocumentType( @Nullable final String sAPObjectNodeType, @Nonnull final String sAPObjectType );

    /**
     * <p>
     * Creates a fluent helper for the <b>LinkAttachmentToSAPObject</b> OData function import.
     * </p>
     *
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HarmonizedDocumentType</b>
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LogicalDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>LinkAttachmentToSAPObject</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.LinkAttachmentToSAPObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LinkAttachmentToSAPObjectFluentHelper linkAttachmentToSAPObject(
        @Nonnull final String linkedSAPObjectKey,
        @Nonnull final String harmonizedDocumentType,
        @Nonnull final String archiveDocumentID,
        @Nonnull final String logicalDocument,
        @Nullable final String sAPObjectNodeType,
        @Nonnull final String sAPObjectType );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignDocumentToBusinessObject</b> OData function import.
     * </p>
     *
     * @param targetLinkedSAPObjectKey
     *            TargetLinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetLinkedSAPObjectKey</b>
     *            </p>
     * @param sourceSAPObjectNodeType
     *            SourceSAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceSAPObjectNodeType</b>
     *            </p>
     * @param sourceSAPObjectType
     *            SourceSAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceSAPObjectType</b>
     *            </p>
     * @param sourceLinkedSAPObjectKey
     *            SourceLinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceLinkedSAPObjectKey</b>
     *            </p>
     * @param targetBusinessObjectTypeName
     *            TargetBusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetBusinessObjectTypeName</b>
     *            </p>
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param targetSAPObjectNodeType
     *            TargetSAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetSAPObjectNodeType</b>
     *            </p>
     * @param sourceBusinessObjectTypeName
     *            SourceBusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceBusinessObjectTypeName</b>
     *            </p>
     * @param targetSAPObjectType
     *            TargetSAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetSAPObjectType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignDocumentToBusinessObject</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AssignDocumentToBusinessObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignDocumentToBusinessObjectFluentHelper assignDocumentToBusinessObject(
        @Nullable final String targetSAPObjectType,
        @Nullable final String targetSAPObjectNodeType,
        @Nullable final String targetBusinessObjectTypeName,
        @Nonnull final String targetLinkedSAPObjectKey,
        @Nullable final String archiveDocumentID,
        @Nullable final String sourceSAPObjectType,
        @Nullable final String sourceSAPObjectNodeType,
        @Nullable final String sourceBusinessObjectTypeName,
        @Nonnull final String sourceLinkedSAPObjectKey );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateUrlAsAttachment</b> OData function import.
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param urlDescription
     *            UrlDescription
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 255
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UrlDescription</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param url
     *            Url
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4096
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Url</b>
     *            </p>
     * @param mIMEType
     *            MIMEType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MIMEType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateUrlAsAttachment</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.CreateUrlAsAttachmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateUrlAsAttachmentFluentHelper createUrlAsAttachment(
        @Nullable final String semanticObject,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String businessObjectTypeName,
        @Nonnull final String url,
        @Nonnull final String urlDescription,
        @Nonnull final String mIMEType );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateUrlAsAttachment</b> OData function import.
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     *            </p>
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessObjectTypeName</b>
     *            </p>
     * @param urlDescription
     *            UrlDescription
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 255
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UrlDescription</b>
     *            </p>
     * @param semanticObject
     *            SemanticObject
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SemanticObject</b>
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HarmonizedDocumentType</b>
     *            </p>
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectNodeType</b>
     *            </p>
     * @param url
     *            Url
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4096
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Url</b>
     *            </p>
     * @param mIMEType
     *            MIMEType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MIMEType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateUrlAsAttachment</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.CreateUrlAsAttachmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateUrlAsAttachmentFluentHelper createUrlAsAttachment(
        @Nullable final String semanticObject,
        @Nonnull final String linkedSAPObjectKey,
        @Nullable final String businessObjectTypeName,
        @Nonnull final String url,
        @Nonnull final String urlDescription,
        @Nonnull final String mIMEType,
        @Nullable final String sAPObjectNodeType,
        @Nullable final String sAPObjectType,
        @Nullable final String harmonizedDocumentType );

}
