/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetailByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetailFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.batch.BankDetailServiceBatch;

/**
 * <p>
 *
 * The service contains bank country, bank key, bank name, SWIFT code, bank group, bank number, region, street name,
 * city, and branch. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/34/c80bfa05f740bca57c17b941bc28bf/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BANKDETAIL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BANKDETAIL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Bank Integration(SAP_COM_0127), Employee Central Financial Master Data Integration(SAP_COM_0441)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J77'>Advanced Bank Account Management(J77)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O77'>Advanced Bank Account Management(O77)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee Central(JB1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AJ'>Financial Master Data for SAP SuccessFactors Employee
 * Central(4AJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bank</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BankDetailService extends BatchService<BankDetailServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BANKDETAIL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BankDetailService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail BankDetail}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail BankDetail} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetailFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankDetailFluentHelper getAllBankDetail();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail BankDetail}
     * entity using key fields.
     *
     * @param bankInternalID
     *            Bank Keys
     *            <p>
     *            Constraints: Not nullable, Maximum length: 15
     *            </p>
     * @param bankCountry
     *            Country/Region Key of Bank
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetail BankDetail} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetailByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankDetailByKeyFluentHelper getBankDetailByKey( final String bankCountry, final String bankInternalID );

}
