/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.StartReconcileFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.batch.BankReconciliationStatementServiceBatch;

/**
 * <p>
 *
 * The service contains bank reconciliation items, bank reconciliation statements, journal entry items and bank
 * statement items. The bank reconciliation items provide the G/L account balance, bank account balance and
 * reconciliation status of all house bank accounts. The “StartReconcile” operation can start automatic reconciliation
 * and generate bank reconciliation statement in the backend. If there are any issues when the bank reconciliation
 * statement is created, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c5/b27deb56a04ff98e944a737ea0c890/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CN_BANK_RECONCILIAITON_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CN_BANK_RECONCILIAITON_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Bank Reconciliation Integration(SAP_COM_0388)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1EG'>Bank Integration with File Interface(1EG)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bank Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BankReconciliationStatementService extends BatchService<BankReconciliationStatementServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CN_BANK_RECONCILIAITON_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BankReconciliationStatementService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem
     * BankStatementItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem
     *         BankStatementItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankStatementItemFluentHelper getAllBankStatementItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem
     * BankStatementItem} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param houseBankAccount
     *            Account ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param bankReconciliationDate
     *            Reconciliation Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param bankStatementShortID
     *            Short Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param houseBank
     *            House Bank
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param bankStatementItem
     *            Memo Record No.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItem
     *         BankStatementItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankStatementItemByKeyFluentHelper getBankStatementItemByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate,
        final String bankStatementShortID,
        final String bankStatementItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem
     * BankReconciliationItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem
     *         BankReconciliationItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankReconciliationItemFluentHelper getAllBankReconciliationItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem
     * BankReconciliationItem} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param houseBankAccount
     *            Account ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param bankReconciliationDate
     *            Reconciliation Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param houseBank
     *            House Bank
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem
     *         BankReconciliationItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankReconciliationItemByKeyFluentHelper getBankReconciliationItemByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement
     * BankReconciliationStatement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement
     *         BankReconciliationStatement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankReconciliationStatementFluentHelper getAllBankReconciliationStatement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement
     * BankReconciliationStatement} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param houseBankAccount
     *            Account ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param bankReconciliationDate
     *            Reconciliation Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param houseBank
     *            House Bank
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatement
     *         BankReconciliationStatement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BankReconciliationStatementByKeyFluentHelper getBankReconciliationStatementByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem
     * JournalEntryItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem
     *         JournalEntryItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JournalEntryItemFluentHelper getAllJournalEntryItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem
     * JournalEntryItem} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param houseBankAccount
     *            Account ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param bankReconciliationDate
     *            Reconciliation Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param accountingDocumentItem
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param houseBank
     *            House Bank
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param accountingDocument
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItem
     *         JournalEntryItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JournalEntryItemByKeyFluentHelper getJournalEntryItemByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate,
        final String fiscalYear,
        final String accountingDocument,
        final String accountingDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>StartReconcile</b> OData function import.
     * </p>
     *
     * @param companyCode
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompanyCode</b>
     *            </p>
     * @param houseBankAccount
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HouseBankAccount</b>
     *            </p>
     * @param bankReconciliationDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BankReconciliationDate</b>
     *            </p>
     * @param houseBank
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HouseBank</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>StartReconcile</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.StartReconcileFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StartReconcileFluentHelper startReconcile(
        @Nonnull final String companyCode,
        @Nonnull final String houseBank,
        @Nonnull final String houseBankAccount,
        @Nonnull final LocalDateTime bankReconciliationDate );

}
