/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.CalculateAvailabilityTimeseriesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.DetermineAvailabilityAtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.DetermineAvailabilityOfFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.batch.BasicProductAvailabilityInformationServiceBatch;

/**
 * <p>
 * The availability information calculated by the service could, for example, be used by webshops to display up-to-date
 * product availability information to increase the chance of customers placing orders or by suppliers to inform their
 * customers when required products will be available and in which quantities.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ba/15d698dd474a57ad340f9acff13b99/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_AVAILY_INFO_BASIC?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_AVAILY_INFO_BASIC</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Availability Information Integration(SAP_COM_0115)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing(1JW)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2LN'>Basic Available-to-Promise Processing(2LN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Available To Promise</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BasicProductAvailabilityInformationService
    extends
    BatchService<BasicProductAvailabilityInformationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCT_AVAILY_INFO_BASIC";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BasicProductAvailabilityInformationService withServicePath( @Nonnull final String servicePath );

    /**
     * <p>
     * Creates a fluent helper for the <b>DetermineAvailabilityAt</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param aTPCheckingRule
     *            Checking rule
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ATPCheckingRule</b>
     *            </p>
     * @param requestedUTCDateTime
     *            Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestedUTCDateTime</b>
     *            </p>
     * @param supplyingPlant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplyingPlant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DetermineAvailabilityAt</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.DetermineAvailabilityAtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DetermineAvailabilityAtFluentHelper determineAvailabilityAt(
        @Nonnull final String supplyingPlant,
        @Nonnull final String material,
        @Nonnull final String aTPCheckingRule,
        @Nonnull final ZonedDateTime requestedUTCDateTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>DetermineAvailabilityOf</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param aTPCheckingRule
     *            Checking rule
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ATPCheckingRule</b>
     *            </p>
     * @param supplyingPlant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplyingPlant</b>
     *            </p>
     * @param requestedQuantityInBaseUnit
     *            Requested Qty
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestedQuantityInBaseUnit</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DetermineAvailabilityOf</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.DetermineAvailabilityOfFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DetermineAvailabilityOfFluentHelper determineAvailabilityOf(
        @Nonnull final BigDecimal requestedQuantityInBaseUnit,
        @Nonnull final String material,
        @Nonnull final String supplyingPlant,
        @Nonnull final String aTPCheckingRule );

    /**
     * <p>
     * Creates a fluent helper for the <b>CalculateAvailabilityTimeseries</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param aTPCheckingRule
     *            Checking rule
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ATPCheckingRule</b>
     *            </p>
     * @param supplyingPlant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplyingPlant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CalculateAvailabilityTimeseries</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.CalculateAvailabilityTimeseriesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalculateAvailabilityTimeseriesFluentHelper calculateAvailabilityTimeseries(
        @Nonnull final String aTPCheckingRule,
        @Nonnull final String material,
        @Nonnull final String supplyingPlant );

}
