/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.batch.BatchServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound API enables you to read, create and change batches. Additionally, it is possible to retrieve
 * and to edit the related classification data. The service is based on the OData protocol, and can be consumed by
 * external systems and user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/48/b3c2ac60154137bb1d6411c7047e16/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BATCH_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BATCH_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Batch Management OData Integration(SAP_COM_0337), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BLF'>Batch Management(BLF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Batch</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BatchService extends com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService<BatchServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BATCH_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BatchService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entities.
     *
     * @return A fluent helper to fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch
     *         Batch} entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchFluentHelper getAllBatch();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity using key
     * fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param batchIdentifyingPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch
     *         Batch} entity using key fields. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchByKeyFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchByKeyFluentHelper
        getBatchByKey( final String material, final String batchIdentifyingPlant, final String batch );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity and save it to
     * the S/4HANA system.
     *
     * @param batch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity object that will
     *            be created in the S/4HANA system.
     * @return A fluent helper to create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch
     *         Batch} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCreateFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchCreateFluentHelper createBatch( @Nonnull final Batch batch );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity and save
     * it to the S/4HANA system.
     *
     * @param batch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity object that will
     *            be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch Batch} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchUpdateFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchUpdateFluentHelper updateBatch( @Nonnull final Batch batch );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchCharcFluentHelper getAllBatchCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity
     * using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param batchIdentifyingPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcByKeyFluentHelper getBatchCharcByKey(
        final String material,
        final String batchIdentifyingPlant,
        final String batch,
        final String charcInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity and
     * save it to the S/4HANA system.
     *
     * @param batchCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity object
     *            that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc BatchCharc} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcCreateFluentHelper createBatchCharc( @Nonnull final BatchCharc batchCharc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcValueFluentHelper getAllBatchCharcValue();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     * entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param batchIdentifyingPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcValueByKeyFluentHelper getBatchCharcValueByKey(
        final String material,
        final String batchIdentifyingPlant,
        final String batch,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     * entity and save it to the S/4HANA system.
     *
     * @param batchCharcValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcValueCreateFluentHelper createBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue
     * BatchCharcValue} entity and save it to the S/4HANA system.
     *
     * @param batchCharcValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcValueUpdateFluentHelper updateBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue
     * BatchCharcValue} entity in the S/4HANA system.
     *
     * @param batchCharcValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue BatchCharcValue} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchCharcValueDeleteFluentHelper deleteBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchClassFluentHelper getAllBatchClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity
     * using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param batchIdentifyingPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchClassByKeyFluentHelper
        getBatchClassByKey( final String material, final String batchIdentifyingPlant, final String batch );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity and
     * save it to the S/4HANA system.
     *
     * @param batchClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity object
     *            that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchClassCreateFluentHelper createBatchClass( @Nonnull final BatchClass batchClass );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass}
     * entity in the S/4HANA system.
     *
     * @param batchClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity object
     *            that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass BatchClass} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchClassDeleteFluentHelper deleteBatchClass( @Nonnull final BatchClass batchClass );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchPlantFluentHelper getAllBatchPlant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity
     * using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchPlantByKeyFluentHelper getBatchPlantByKey( final String material, final String batch, final String plant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity
     * and save it to the S/4HANA system.
     *
     * @param batchPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity object
     *            that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant BatchPlant} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchPlantUpdateFluentHelper updateBatchPlant( @Nonnull final BatchPlant batchPlant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    BatchTextFluentHelper getAllBatchText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity using
     * key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param batchIdentifyingPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchTextByKeyFluentHelper getBatchTextByKey(
        final String material,
        final String batchIdentifyingPlant,
        final String batch,
        final String language );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity
     * and save it to the S/4HANA system.
     *
     * @param batchText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity object
     *            that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchTextUpdateFluentHelper updateBatchText( @Nonnull final BatchText batchText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity
     * in the S/4HANA system.
     *
     * @param batchText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity object
     *            that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText BatchText} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BatchTextDeleteFluentHelper deleteBatchText( @Nonnull final BatchText batchText );

}
