/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.BOMComparisonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResultFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.batch.BillOfMaterialComparisonServiceBatch;

/**
 * <p>
 *
 * This service enables you to compare two bills of material (BOMs) by comparing their BOM item attributes..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/48/9007ed0e07467bb9efbf1f5616b36e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILLOFMATERIAL_COMPARISON_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILLOFMATERIAL_COMPARISON_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BillOfMaterialComparisonService extends BatchService<BillOfMaterialComparisonServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BILLOFMATERIAL_COMPARISON_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BillOfMaterialComparisonService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
     * ComparisonResult} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
     *         ComparisonResult} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResultFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ComparisonResultFluentHelper getAllComparisonResult();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
     * ComparisonResult} entity using key fields.
     *
     * @param bOMComparisonUUID
     *            GUID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
     *         ComparisonResult} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResultByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ComparisonResultByKeyFluentHelper getComparisonResultByKey( final byte[] bOMComparisonUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>BOMComparison</b> OData function import.
     * </p>
     *
     * @param isBOMItemNumber
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemNumber</b>
     *            </p>
     * @param bOMVariantSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantSecondary</b>
     *            </p>
     * @param isBOMItemDescription
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemDescription</b>
     *            </p>
     * @param changeNumberPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumberPrimary</b>
     *            </p>
     * @param isBOMItemCategory
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemCategory</b>
     *            </p>
     * @param plantSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantSecondary</b>
     *            </p>
     * @param changeNumberSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumberSecondary</b>
     *            </p>
     * @param bOMVersionSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVersionSecondary</b>
     *            </p>
     * @param bOMVariantPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantPrimary</b>
     *            </p>
     * @param isBOMItemQuantity
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemQuantity</b>
     *            </p>
     * @param materialSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialSecondary</b>
     *            </p>
     * @param bOMVariantUsagePrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantUsagePrimary</b>
     *            </p>
     * @param plantPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantPrimary</b>
     *            </p>
     * @param bOMValidityDatePrimary
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMValidityDatePrimary</b>
     *            </p>
     * @param bOMVariantUsageSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantUsageSecondary</b>
     *            </p>
     * @param bOMValidityDateSecondary
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMValidityDateSecondary</b>
     *            </p>
     * @param bOMVersionPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVersionPrimary</b>
     *            </p>
     * @param materialPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialPrimary</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>BOMComparison</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.BOMComparisonFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMComparisonFluentHelper bOMComparison(
        @Nonnull final LocalDateTime bOMValidityDateSecondary,
        @Nonnull final String bOMVersionSecondary,
        @Nonnull final String bOMVariantSecondary,
        @Nonnull final String bOMVariantUsageSecondary,
        @Nonnull final String plantSecondary,
        @Nonnull final String materialSecondary,
        @Nonnull final String changeNumberPrimary,
        @Nonnull final LocalDateTime bOMValidityDatePrimary,
        @Nonnull final String bOMVersionPrimary,
        @Nonnull final String bOMVariantPrimary,
        @Nonnull final String bOMVariantUsagePrimary,
        @Nonnull final String plantPrimary,
        @Nonnull final String materialPrimary,
        @Nonnull final Boolean isBOMItemNumber,
        @Nonnull final Boolean isBOMItemDescription,
        @Nonnull final Boolean isBOMItemCategory,
        @Nonnull final String changeNumberSecondary,
        @Nonnull final Boolean isBOMItemQuantity );

}
