/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.ExplodeBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.ReleaseVersionBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.batch.BillOfMaterialsServiceBatch;

/**
 * <p>
 *
 * The service enables you to read, create, and update bills of material with and without version. The service is based
 * on the OData protocol and can be consumed in SAP Fiori apps and on other user interfaces.
 *
 * The service contains either no header, one header, or multiple headers for the specified material and none or more
 * items for each header. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/15/3a455816dda007e10000000a441470/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILL_OF_MATERIAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILL_OF_MATERIAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions Management(1NR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master Management(1R3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2105 (May 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface BillOfMaterialsService extends BatchService<BillOfMaterialsServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BILL_OF_MATERIAL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BillOfMaterialsService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     * BillOfMaterial} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialFluentHelper getAllBillOfMaterial();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     * BillOfMaterial} entity using key fields.
     *
     * @param billOfMaterialHeaderUUID
     *            Global identification of a BOM header change status
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialByKeyFluentHelper getBillOfMaterialByKey( final UUID billOfMaterialHeaderUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     * BillOfMaterial} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     *            BillOfMaterial} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialCreateFluentHelper createBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     * BillOfMaterial} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     *            BillOfMaterial} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUpdateFluentHelper updateBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     * BillOfMaterialItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *         BillOfMaterialItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialItemFluentHelper getAllBillOfMaterialItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     * BillOfMaterialItem} entity using key fields.
     *
     * @param billOfMaterialItemUUID
     *            Global identification of an item's change status
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *         BillOfMaterialItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialItemByKeyFluentHelper getBillOfMaterialItemByKey( final UUID billOfMaterialItemUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     * BillOfMaterialItem} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterialItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *            BillOfMaterialItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *         BillOfMaterialItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialItemCreateFluentHelper
        createBillOfMaterialItem( @Nonnull final BillOfMaterialItem billOfMaterialItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     * BillOfMaterialItem} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterialItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *            BillOfMaterialItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *         BillOfMaterialItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialItemUpdateFluentHelper
        updateBillOfMaterialItem( @Nonnull final BillOfMaterialItem billOfMaterialItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage
     * BillOfMaterialUsage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage
     *         BillOfMaterialUsage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageFluentHelper getAllBillOfMaterialUsage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage
     * BillOfMaterialUsage} entity using key fields.
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage
     *         BillOfMaterialUsage} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageByKeyFluentHelper getBillOfMaterialUsageByKey( final String billOfMaterialVariantUsage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageText
     * BillOfMaterialUsageText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageText
     *         BillOfMaterialUsageText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageTextFluentHelper getAllBillOfMaterialUsageText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageText
     * BillOfMaterialUsageText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageText
     *         BillOfMaterialUsageText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageTextByKeyFluentHelper
        getBillOfMaterialUsageTextByKey( final String language, final String billOfMaterialVariantUsage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory
     * BOMItemCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory
     *         BOMItemCategory} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryFluentHelper getAllBOMItemCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory
     * BOMItemCategory} entity using key fields.
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory
     *         BOMItemCategory} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryByKeyFluentHelper getBOMItemCategoryByKey( final String billOfMaterialItemCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText
     * BOMItemCategoryText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText
     *         BOMItemCategoryText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryTextFluentHelper getAllBOMItemCategoryText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText
     * BOMItemCategoryText} entity using key fields.
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText
     *         BOMItemCategoryText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryTextByKeyFluentHelper
        getBOMItemCategoryTextByKey( final String language, final String billOfMaterialItemCategory );

    /**
     * <p>
     * Creates a fluent helper for the <b>ExplodeBOM</b> OData function import.
     * </p>
     *
     * @param bOMItmQtyIsScrapRelevant
     *            Exceptions
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItmQtyIsScrapRelevant</b>
     *            </p>
     * @param sparePartFltrType
     *            Spare Part Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SparePartFltrType</b>
     *            </p>
     * @param bOMExplosionLevel
     *            Explosion level
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionLevel</b>
     *            </p>
     * @param bOMExplosionIsLimited
     *            Limited Explosion
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionIsLimited</b>
     *            </p>
     * @param bOMExplosionApplication
     *            BOM Application
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionApplication</b>
     *            </p>
     * @param requiredQuantity
     *            Base quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequiredQuantity</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialHeaderUUID
     *            ID hdr chge status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param billOfMaterialItemCategory
     *            Item Category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     *            </p>
     * @param bOMExplosionIsMultilevel
     *            Multi-lev.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionIsMultilevel</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param materialProvisionFltrType
     *            Mat. Provision Ind.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialProvisionFltrType</b>
     *            </p>
     * @param bOMExplosionAssembly
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionAssembly</b>
     *            </p>
     * @param bOMExplosionDate
     *            Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ExplodeBOM</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.ExplodeBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ExplodeBOMFluentHelper explodeBOM(
        @Nonnull final UUID billOfMaterialHeaderUUID,
        @Nullable final String material,
        @Nullable final String plant,
        @Nullable final String billOfMaterialVariant,
        @Nullable final String bOMExplosionApplication,
        @Nullable final BigDecimal requiredQuantity,
        @Nullable final String engineeringChangeDocument,
        @Nullable final Boolean bOMExplosionIsLimited,
        @Nullable final String bOMItmQtyIsScrapRelevant,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String bOMExplosionAssembly,
        @Nullable final LocalDateTime bOMExplosionDate,
        @Nullable final BigDecimal bOMExplosionLevel,
        @Nullable final Boolean bOMExplosionIsMultilevel,
        @Nullable final String materialProvisionFltrType,
        @Nullable final String sparePartFltrType );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseVersionBOM</b> OData function import.
     * </p>
     *
     * @param stlnr
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Stlnr</b>
     *            </p>
     * @param billOfMaterialHeaderUUID
     *            ID hdr chge status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     *            </p>
     * @param versnlastind
     *            Latest Rel Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Versnlastind</b>
     *            </p>
     * @param stlty
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Stlty</b>
     *            </p>
     * @param versnst
     *            BOM Version Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Versnst</b>
     *            </p>
     * @param stlal
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Stlal</b>
     *            </p>
     * @param bomVersn
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BomVersn</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseVersionBOM</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.ReleaseVersionBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseVersionBOMFluentHelper releaseVersionBOM(
        @Nonnull final UUID billOfMaterialHeaderUUID,
        @Nullable final String stlnr,
        @Nullable final String stlty,
        @Nullable final String stlal,
        @Nullable final String bomVersn,
        @Nullable final String versnst,
        @Nullable final Boolean versnlastind );

}
