/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ConvertItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.DeleteBOMHeaderWithECNFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.DeleteBOMItemWithECNFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ExplodeBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ReleaseVersionBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.UpdateBOMItemWithECNFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.batch.BillOfMaterialsV2ServiceBatch;

/**
 * <p>
 *
 * The service enables you to read, create, update, and delete bills of material with and without version. The service
 * is based on the OData protocol and can be consumed in SAP Fiori apps and on other user interfaces.
 *
 * The service contains either no header, one header, or multiple headers for the specified material and none or more
 * items for each header..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8a/8b08aab6cd47f4a3e35e8bd8d86ca2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILL_OF_MATERIAL_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILL_OF_MATERIAL_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BillOfMaterialsV2Service extends BatchService<BillOfMaterialsV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BILL_OF_MATERIAL_SRV;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BillOfMaterialsV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *         MaterialBOMItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMItemFluentHelper getAllMaterialBOMItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity using key fields.
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *         MaterialBOMItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMItemByKeyFluentHelper getMaterialBOMItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String billOfMaterialItemNodeNumber,
        final String headerChangeDocument,
        final String material,
        final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *            MaterialBOMItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *         MaterialBOMItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMItemCreateFluentHelper createMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *            MaterialBOMItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *         MaterialBOMItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMItemUpdateFluentHelper updateMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity in the S/4HANA system.
     *
     * @param materialBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *            MaterialBOMItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *         MaterialBOMItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMItemDeleteFluentHelper deleteMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *         MaterialBOMSubItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMSubItemFluentHelper getAllMaterialBOMSubItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity using key fields.
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param bOMSubItemNumberValue
     *            Undefined range (can be used for patch levels)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Character field, 8 characters long
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOMItemInternalChangeCount
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *         MaterialBOMSubItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMSubItemByKeyFluentHelper getMaterialBOMSubItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String billOfMaterialItemNodeNumber,
        final String headerChangeDocument,
        final String material,
        final String plant,
        final String bOMItemInternalChangeCount,
        final String bOMSubItemNumberValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMSubItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *            MaterialBOMSubItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *         MaterialBOMSubItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMSubItemCreateFluentHelper
        createMaterialBOMSubItem( @Nonnull final MaterialBOMSubItem materialBOMSubItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMSubItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *            MaterialBOMSubItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *         MaterialBOMSubItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMSubItemUpdateFluentHelper
        updateMaterialBOMSubItem( @Nonnull final MaterialBOMSubItem materialBOMSubItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity in the S/4HANA system.
     *
     * @param materialBOMSubItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *            MaterialBOMSubItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *         MaterialBOMSubItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMSubItemDeleteFluentHelper
        deleteMaterialBOMSubItem( @Nonnull final MaterialBOMSubItem materialBOMSubItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsage
     * BillOfMaterialUsage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsage
     *         BillOfMaterialUsage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageFluentHelper getAllBillOfMaterialUsage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsage
     * BillOfMaterialUsage} entity using key fields.
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsage
     *         BillOfMaterialUsage} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageByKeyFluentHelper getBillOfMaterialUsageByKey( final String billOfMaterialVariantUsage );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText
     * BillOfMaterialUsageText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText
     *         BillOfMaterialUsageText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageTextFluentHelper getAllBillOfMaterialUsageText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText
     * BillOfMaterialUsageText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText
     *         BillOfMaterialUsageText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillOfMaterialUsageTextByKeyFluentHelper
        getBillOfMaterialUsageTextByKey( final String language, final String billOfMaterialVariantUsage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMFluentHelper getAllMaterialBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMByKeyFluentHelper getMaterialBOMByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String engineeringChangeDocument,
        final String material,
        final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity and save it to the S/4HANA system.
     *
     * @param materialBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMCreateFluentHelper createMaterialBOM( @Nonnull final MaterialBOM materialBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity and save it to the S/4HANA system.
     *
     * @param materialBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMUpdateFluentHelper updateMaterialBOM( @Nonnull final MaterialBOM materialBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity in the S/4HANA system.
     *
     * @param materialBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialBOMDeleteFluentHelper deleteMaterialBOM( @Nonnull final MaterialBOM materialBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategory
     * BOMItemCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategory
     *         BOMItemCategory} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryFluentHelper getAllBOMItemCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategory
     * BOMItemCategory} entity using key fields.
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategory
     *         BOMItemCategory} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryByKeyFluentHelper getBOMItemCategoryByKey( final String billOfMaterialItemCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryText
     * BOMItemCategoryText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryText
     *         BOMItemCategoryText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryTextFluentHelper getAllBOMItemCategoryText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryText
     * BOMItemCategoryText} entity using key fields.
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryText
     *         BOMItemCategoryText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryTextByKeyFluentHelper
        getBOMItemCategoryTextByKey( final String language, final String billOfMaterialItemCategory );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *         MBOMItmObjDpnAssignment} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MBOMItmObjDpnAssignmentFluentHelper getAllMBOMItmObjDpnAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entity using key fields.
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param objectDependencyName
     *            Name of Dependency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *         MBOMItmObjDpnAssignment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MBOMItmObjDpnAssignmentByKeyFluentHelper getMBOMItmObjDpnAssignmentByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String headerChangeDocument,
        final String material,
        final String plant,
        final String billOfMaterialItemNodeNumber,
        final String objectDependencyName );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entity and save it to the S/4HANA system.
     *
     * @param mBOMItmObjDpnAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *            MBOMItmObjDpnAssignment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *         MBOMItmObjDpnAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MBOMItmObjDpnAssignmentUpdateFluentHelper
        updateMBOMItmObjDpnAssignment( @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entity in the S/4HANA system.
     *
     * @param mBOMItmObjDpnAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *            MBOMItmObjDpnAssignment} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *         MBOMItmObjDpnAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MBOMItmObjDpnAssignmentDeleteFluentHelper
        deleteMBOMItmObjDpnAssignment( @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConvertItem</b> OData function import.
     * </p>
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HeaderChangeDocument</b>
     *            </p>
     * @param bOMItemDescription
     *            Item Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemDescription</b>
     *            </p>
     * @param billOfMaterialComponent
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialComponent</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param purchasingGroup
     *            Purchasing Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchasingGroup</b>
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param materialGroup
     *            Material Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 9
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialGroup</b>
     *            </p>
     * @param materialPriceUnitQty
     *            Price unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param materialComponentPrice
     *            Price
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 12, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialComponentPrice</b>
     *            </p>
     * @param billOfMaterialItemCategory
     *            Item Category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     *            </p>
     * @param currency
     *            Currency
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 5
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Currency</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConvertItem</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ConvertItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConvertItemFluentHelper convertItem(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String billOfMaterialComponent,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String bOMItemDescription,
        @Nullable final String purchasingGroup,
        @Nullable final String materialGroup,
        @Nullable final BigDecimal materialPriceUnitQty,
        @Nullable final String currency,
        @Nullable final BigDecimal materialComponentPrice );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteBOMItemWithECN</b> OData function import.
     * </p>
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HeaderChangeDocument</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param engineeringChangeDocForEdit
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteBOMItemWithECN</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.DeleteBOMItemWithECNFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteBOMItemWithECNFluentHelper deleteBOMItemWithECN(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit );

    /**
     * <p>
     * Creates a fluent helper for the <b>UpdateBOMItemWithECN</b> OData function import.
     * </p>
     *
     * @param deliveryDurationInDays
     *            Delivery time (days)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDurationInDays</b>
     *            </p>
     * @param isMaterialProvision
     *            Mat. Provision Ind.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsMaterialProvision</b>
     *            </p>
     * @param productionSupplyArea
     *            Prodn Supply Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductionSupplyArea</b>
     *            </p>
     * @param followUpGroup
     *            Follow-up group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FollowUpGroup</b>
     *            </p>
     * @param goodsReceiptDuration
     *            GR processing time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>GoodsReceiptDuration</b>
     *            </p>
     * @param validityEndDate
     *            Valid to
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param explosionType
     *            Explosion type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ExplosionType</b>
     *            </p>
     * @param materialIsCoProduct
     *            Co-product
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialIsCoProduct</b>
     *            </p>
     * @param materialPriceUnitQty
     *            Price unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     *            </p>
     * @param bOMItemSorter
     *            Sort String
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemSorter</b>
     *            </p>
     * @param chgToEngineeringChgDocument
     *            Change Number To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     *            </p>
     * @param formulaKey
     *            VSI Formula
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FormulaKey</b>
     *            </p>
     * @param operationScrapInPercent
     *            Operation Scrap in %
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OperationScrapInPercent</b>
     *            </p>
     * @param bOMItemDescription
     *            Item Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemDescription</b>
     *            </p>
     * @param engineeringChangeDocForEdit
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     *            </p>
     * @param preliminaryComponent
     *            Material Description
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PreliminaryComponent</b>
     *            </p>
     * @param billOfMaterialItemObjectType
     *            Object Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemObjectType</b>
     *            </p>
     * @param alternativeItemPriority
     *            Priority
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeItemPriority</b>
     *            </p>
     * @param requiredComponent
     *            Required Component
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequiredComponent</b>
     *            </p>
     * @param bOMItemRecordCreationDate
     *            Created On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemRecordCreationDate</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param bOMItemCreatedByUser
     *            Created By
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemCreatedByUser</b>
     *            </p>
     * @param creditor
     *            Supplier
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Creditor</b>
     *            </p>
     * @param resultingItemCategory
     *            Res. item category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ResultingItemCategory</b>
     *            </p>
     * @param costElement
     *            Cost element
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CostElement</b>
     *            </p>
     * @param prodOrderIssueLocation
     *            Storage Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProdOrderIssueLocation</b>
     *            </p>
     * @param isAssembly
     *            Single-Character Flag
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsAssembly</b>
     *            </p>
     * @param purchasingOrganization
     *            Purch. Organization
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchasingOrganization</b>
     *            </p>
     * @param alternativeItemGroup
     *            AltItemGroup
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeItemGroup</b>
     *            </p>
     * @param dependencyObjectNumber
     *            Assignment number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DependencyObjectNumber</b>
     *            </p>
     * @param inheritedNodeNumberForBOMItem
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InheritedNodeNumberForBOMItem</b>
     *            </p>
     * @param bOMItemIsCostingRelevant
     *            Relevancy to costing
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsCostingRelevant</b>
     *            </p>
     * @param classNumber
     *            Class
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ClassNumber</b>
     *            </p>
     * @param billOfMaterialItemUUID
     *            ID item chge status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     *            </p>
     * @param isDeleted
     *            Deletion Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsDeleted</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param bOMItemIsSalesRelevant
     *            Relevant to sales
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsSalesRelevant</b>
     *            </p>
     * @param materialComponentPrice
     *            Price
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 12, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialComponentPrice</b>
     *            </p>
     * @param leadTimeOffset
     *            Lead-time offset
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LeadTimeOffset</b>
     *            </p>
     * @param lastChangeDateTime
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LastChangeDateTime</b>
     *            </p>
     * @param currency
     *            Currency
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 5
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Currency</b>
     *            </p>
     * @param isConfigurableBOM
     *            Selection indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsConfigurableBOM</b>
     *            </p>
     * @param opsLeadTimeOffsetUnit
     *            Operation LTO unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     *            </p>
     * @param bOMItemLastChangeDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemLastChangeDate</b>
     *            </p>
     * @param specialProcurementType
     *            Special Procurement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SpecialProcurementType</b>
     *            </p>
     * @param discontinuationGroup
     *            Discont. group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DiscontinuationGroup</b>
     *            </p>
     * @param bOMItemLastChangedByUser
     *            Changed By
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemLastChangedByUser</b>
     *            </p>
     * @param operationLeadTimeOffset
     *            Oper. LT offset
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OperationLeadTimeOffset</b>
     *            </p>
     * @param bOMItemInternalChangeCount
     *            Counter
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     *            </p>
     * @param isNetScrap
     *            Net Scrap Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsNetScrap</b>
     *            </p>
     * @param billOfMaterialItemUnit
     *            Component UoM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentPart</b>
     *            </p>
     * @param billOfMaterialComponent
     *            Component
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialComponent</b>
     *            </p>
     * @param docNumber
     *            Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocNumber</b>
     *            </p>
     * @param unitOfMeasureForSize1To3
     *            Size unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasureForSize1To3</b>
     *            </p>
     * @param bOMItemIsSparePart
     *            Spare Part Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsSparePart</b>
     *            </p>
     * @param usageProbabilityPercent
     *            Usage Probability
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UsageProbabilityPercent</b>
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentVersion</b>
     *            </p>
     * @param distrKeyCompConsumption
     *            Distribution key
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DistrKeyCompConsumption</b>
     *            </p>
     * @param bOMItemHasFixedQuantity
     *            Fixed Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemHasFixedQuantity</b>
     *            </p>
     * @param bOMIsRecursive
     *            Recursive
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMIsRecursive</b>
     *            </p>
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HeaderChangeDocument</b>
     *            </p>
     * @param componentScrapInPercent
     *            Component Scrap (%)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ComponentScrapInPercent</b>
     *            </p>
     * @param purchasingGroup
     *            Purchasing Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchasingGroup</b>
     *            </p>
     * @param bOMItemText2
     *            Item Text 2
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemText2</b>
     *            </p>
     * @param materialGroup
     *            Material Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 9
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialGroup</b>
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ClassType</b>
     *            </p>
     * @param bOMItemIsPlantMaintRelevant
     *            Plant maintenance
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsPlantMaintRelevant</b>
     *            </p>
     * @param identifierBOMItem
     *            Item identification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IdentifierBOMItem</b>
     *            </p>
     * @param variableSizeItemQuantity
     *            No. of VSI Required
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>VariableSizeItemQuantity</b>
     *            </p>
     * @param documentType
     *            Document Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentType</b>
     *            </p>
     * @param isBOMRecursiveAllowed
     *            Recurs. allowed
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMRecursiveAllowed</b>
     *            </p>
     * @param isBulkMaterial
     *            Bulk Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBulkMaterial</b>
     *            </p>
     * @param quantityVariableSizeItem
     *            VSI Quantity per PC
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityVariableSizeItem</b>
     *            </p>
     * @param size3
     *            Size 3
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Size3</b>
     *            </p>
     * @param variableSizeCompUnitOfMeasure
     *            Var-size item unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>VariableSizeCompUnitOfMeasure</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param size1
     *            Size 1
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Size1</b>
     *            </p>
     * @param size2
     *            Size 2
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Size2</b>
     *            </p>
     * @param billOfMaterialItemNumber
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param multipleSelectionAllowed
     *            Multiple Selection
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MultipleSelectionAllowed</b>
     *            </p>
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     *            </p>
     * @param validityStartDate
     *            Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityStartDate</b>
     *            </p>
     * @param isSubItem
     *            Sub-item indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsSubItem</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param componentDescription
     *            Item Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ComponentDescription</b>
     *            </p>
     * @param isALE
     *            ALE indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsALE</b>
     *            </p>
     * @param alternativeItemStrategy
     *            Strategy
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeItemStrategy</b>
     *            </p>
     * @param referencePoint
     *            Reference point
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 20
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReferencePoint</b>
     *            </p>
     * @param isClassificationRelevant
     *            as selection cond.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsClassificationRelevant</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialItemQuantity
     *            Component Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     *            </p>
     * @param isProductionRelevant
     *            Production relevant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsProductionRelevant</b>
     *            </p>
     * @param billOfMaterialItemCategory
     *            Item Category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     *            </p>
     * @param isEngineeringRelevant
     *            Engineering/design
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsEngineeringRelevant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UpdateBOMItemWithECN</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.UpdateBOMItemWithECNFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UpdateBOMItemWithECNFluentHelper updateBOMItemWithECN(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final UUID billOfMaterialItemUUID,
        @Nullable final String bOMItemInternalChangeCount,
        @Nullable final LocalDateTime validityStartDate,
        @Nullable final LocalDateTime validityEndDate,
        @Nullable final String engineeringChangeDocForEdit,
        @Nullable final String engineeringChangeDocument,
        @Nullable final String chgToEngineeringChgDocument,
        @Nullable final String inheritedNodeNumberForBOMItem,
        @Nullable final LocalDateTime bOMItemRecordCreationDate,
        @Nullable final String bOMItemCreatedByUser,
        @Nullable final LocalDateTime bOMItemLastChangeDate,
        @Nullable final String bOMItemLastChangedByUser,
        @Nullable final String billOfMaterialComponent,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String billOfMaterialItemNumber,
        @Nullable final String billOfMaterialItemUnit,
        @Nullable final BigDecimal billOfMaterialItemQuantity,
        @Nullable final String isAssembly,
        @Nullable final Boolean isSubItem,
        @Nullable final String bOMItemSorter,
        @Nullable final Boolean bOMItemHasFixedQuantity,
        @Nullable final String purchasingGroup,
        @Nullable final String currency,
        @Nullable final BigDecimal materialComponentPrice,
        @Nullable final String identifierBOMItem,
        @Nullable final BigDecimal materialPriceUnitQty,
        @Nullable final BigDecimal componentScrapInPercent,
        @Nullable final BigDecimal operationScrapInPercent,
        @Nullable final Boolean isNetScrap,
        @Nullable final BigDecimal variableSizeItemQuantity,
        @Nullable final String variableSizeCompUnitOfMeasure,
        @Nullable final BigDecimal quantityVariableSizeItem,
        @Nullable final String formulaKey,
        @Nullable final String componentDescription,
        @Nullable final String bOMItemDescription,
        @Nullable final String bOMItemText2,
        @Nullable final String materialGroup,
        @Nullable final String documentType,
        @Nullable final String docNumber,
        @Nullable final String documentVersion,
        @Nullable final String documentPart,
        @Nullable final String classNumber,
        @Nullable final String classType,
        @Nullable final String resultingItemCategory,
        @Nullable final String dependencyObjectNumber,
        @Nullable final String billOfMaterialItemObjectType,
        @Nullable final Boolean isClassificationRelevant,
        @Nullable final Boolean isBulkMaterial,
        @Nullable final String bOMItemIsSparePart,
        @Nullable final String bOMItemIsSalesRelevant,
        @Nullable final Boolean isProductionRelevant,
        @Nullable final Boolean bOMItemIsPlantMaintRelevant,
        @Nullable final String bOMItemIsCostingRelevant,
        @Nullable final Boolean isEngineeringRelevant,
        @Nullable final String specialProcurementType,
        @Nullable final Boolean isBOMRecursiveAllowed,
        @Nullable final BigDecimal operationLeadTimeOffset,
        @Nullable final String opsLeadTimeOffsetUnit,
        @Nullable final String isMaterialProvision,
        @Nullable final Boolean bOMIsRecursive,
        @Nullable final Boolean documentIsCreatedByCAD,
        @Nullable final String distrKeyCompConsumption,
        @Nullable final BigDecimal deliveryDurationInDays,
        @Nullable final String creditor,
        @Nullable final String costElement,
        @Nullable final BigDecimal size1,
        @Nullable final BigDecimal size2,
        @Nullable final BigDecimal size3,
        @Nullable final String unitOfMeasureForSize1To3,
        @Nullable final BigDecimal goodsReceiptDuration,
        @Nullable final String purchasingOrganization,
        @Nullable final Boolean requiredComponent,
        @Nullable final Boolean multipleSelectionAllowed,
        @Nullable final String prodOrderIssueLocation,
        @Nullable final Boolean materialIsCoProduct,
        @Nullable final String explosionType,
        @Nullable final String alternativeItemGroup,
        @Nullable final String alternativeItemPriority,
        @Nullable final String alternativeItemStrategy,
        @Nullable final BigDecimal usageProbabilityPercent,
        @Nullable final String followUpGroup,
        @Nullable final String discontinuationGroup,
        @Nullable final String isConfigurableBOM,
        @Nullable final String referencePoint,
        @Nullable final BigDecimal leadTimeOffset,
        @Nullable final String productionSupplyArea,
        @Nullable final Boolean isDeleted,
        @Nullable final Boolean isALE,
        @Nullable final ZonedDateTime lastChangeDateTime,
        @Nullable final String preliminaryComponent );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteBOMHeaderWithECN</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param engineeringChangeDocForEdit
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteBOMHeaderWithECN</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.DeleteBOMHeaderWithECNFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteBOMHeaderWithECNFluentHelper deleteBOMHeaderWithECN(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit );

    /**
     * <p>
     * Creates a fluent helper for the <b>ExplodeBOM</b> OData function import.
     * </p>
     *
     * @param finalPriceIndicator
     *            Display Price Data
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FinalPriceIndicator</b>
     *            </p>
     * @param bOMItmQtyIsScrapRelevant
     *            Exceptions
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItmQtyIsScrapRelevant</b>
     *            </p>
     * @param sparePartFltrType
     *            Spare Part Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SparePartFltrType</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param bOMExplosionLevel
     *            Explosion level
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionLevel</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param bOMExplosionIsLimited
     *            Limited Explosion
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionIsLimited</b>
     *            </p>
     * @param bOMExplosionApplication
     *            BOM Application
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionApplication</b>
     *            </p>
     * @param bOMHeaderBaseUnit
     *            Base Unit of Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     *            </p>
     * @param requiredQuantity
     *            Component Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequiredQuantity</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param bOMExplosionIsAlternatePrio
     *            Alternative priority
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionIsAlternatePrio</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterialItemCategory
     *            Item Category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     *            </p>
     * @param bOMExplosionIsMultilevel
     *            Multi-lev.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionIsMultilevel</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param materialProvisionFltrType
     *            Mat. Provision Ind.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialProvisionFltrType</b>
     *            </p>
     * @param bOMExplosionAssembly
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionAssembly</b>
     *            </p>
     * @param bOMExplosionDate
     *            Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMExplosionDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ExplodeBOM</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ExplodeBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ExplodeBOMFluentHelper explodeBOM(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String bOMExplosionApplication,
        @Nullable final BigDecimal requiredQuantity,
        @Nullable final Boolean bOMExplosionIsLimited,
        @Nullable final String bOMItmQtyIsScrapRelevant,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String bOMExplosionAssembly,
        @Nullable final LocalDateTime bOMExplosionDate,
        @Nullable final BigDecimal bOMExplosionLevel,
        @Nullable final Boolean bOMExplosionIsMultilevel,
        @Nullable final String materialProvisionFltrType,
        @Nullable final String sparePartFltrType,
        @Nullable final String bOMHeaderBaseUnit,
        @Nullable final Boolean finalPriceIndicator,
        @Nullable final Boolean bOMExplosionIsAlternatePrio );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseVersionBOM</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseVersionBOM</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ReleaseVersionBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseVersionBOMFluentHelper releaseVersionBOM(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant );

}
