/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.GetPDFFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.batch.BillingDocumentServiceBatch;

/**
 * <p>
 *
 * Consumers of this inbound service can read and cancel billing documents inside your system by sending OData requests.
 * In addition, they can request entire billing documents in PDF format. The service makes billing document data
 * available through its header, item, business partner, and pricing element entities..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fe/6f3eda2f914d81b512493fd79e9769/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILLING_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILLING_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Billing Integration(SAP_COM_0120), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Z6'>External Billing(1Z6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OZ6'>External Billing(OZ6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Billing Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BillingDocumentService extends BatchService<BillingDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BILLING_DOCUMENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BillingDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocument
     * BillingDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocument
     *         BillingDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentFluentHelper getAllBillingDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocument
     * BillingDocument} entity using key fields.
     *
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocument
     *         BillingDocument} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentByKeyFluentHelper getBillingDocumentByKey( final String billingDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem
     * BillingDocumentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem
     *         BillingDocumentItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemFluentHelper getAllBillingDocumentItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem
     * BillingDocumentItem} entity using key fields.
     *
     * @param billingDocumentItem
     *            Billing Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItem
     *         BillingDocumentItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemByKeyFluentHelper
        getBillingDocumentItemByKey( final String billingDocument, final String billingDocumentItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartner
     * BillingDocumentItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartner
     *         BillingDocumentItemPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemPartnerFluentHelper getAllBillingDocumentItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartner
     * BillingDocumentItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billingDocumentItem
     *            Billing Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartner
     *         BillingDocumentItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemPartnerByKeyFluentHelper getBillingDocumentItemPartnerByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String partnerFunction );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmnt
     * BillingDocumentItemPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmnt
     *         BillingDocumentItemPrcgElmnt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemPrcgElmntFluentHelper getAllBillingDocumentItemPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmnt
     * BillingDocumentItemPrcgElmnt} entity using key fields.
     *
     * @param billingDocumentItem
     *            Billing Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmnt
     *         BillingDocumentItemPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemPrcgElmntByKeyFluentHelper getBillingDocumentItemPrcgElmntByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
     * BillingDocumentItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
     *         BillingDocumentItemText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemTextFluentHelper getAllBillingDocumentItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
     * BillingDocumentItemText} entity using key fields.
     *
     * @param billingDocumentItem
     *            Billing Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemText
     *         BillingDocumentItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentItemTextByKeyFluentHelper getBillingDocumentItemTextByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String language,
        final String longTextID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartner
     * BillingDocumentPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartner
     *         BillingDocumentPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentPartnerFluentHelper getAllBillingDocumentPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartner
     * BillingDocumentPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartner
     *         BillingDocumentPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentPartnerByKeyFluentHelper
        getBillingDocumentPartnerByKey( final String billingDocument, final String partnerFunction );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt
     * BillingDocumentPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt
     *         BillingDocumentPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentPrcgElmntFluentHelper getAllBillingDocumentPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt
     * BillingDocumentPrcgElmnt} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmnt
     *         BillingDocumentPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentPrcgElmntByKeyFluentHelper getBillingDocumentPrcgElmntByKey(
        final String billingDocument,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentText
     * BillingDocumentText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentText
     *         BillingDocumentText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentTextFluentHelper getAllBillingDocumentText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentText
     * BillingDocumentText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentText
     *         BillingDocumentText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentTextByKeyFluentHelper
        getBillingDocumentTextByKey( final String billingDocument, final String language, final String longTextID );

    /**
     * <p>
     * Creates a fluent helper for the <b>Cancel</b> OData function import.
     * </p>
     *
     * @param billingDocument
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillingDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Cancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.CancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelFluentHelper cancel( @Nonnull final String billingDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetPDF</b> OData function import.
     * </p>
     *
     * @param billingDocument
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillingDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetPDF</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.GetPDFFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetPDFFluentHelper getPDF( @Nonnull final String billingDocument );

}
