/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlaceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.batch.BrazilBusinessPlaceServiceBatch;

/**
 * <p>
 * This service is based on the OData protocol and can be consumed in Brazilian integration scenarios. Once the business
 * place and company code numbers have been informed, the system returns business place data such as address, tax
 * jurisdiction, telephone, CNPJ number, and municipal tax number.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/59/5d6255f1d54e2ba285b37705548e1f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LOGBR_BUSINESS_PLACE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LOGBR_BUSINESS_PLACE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Brazil Business Place Detail Integration(SAP_COM_0365)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1J5'>Invoice, Taxes and Complementary Postings(1J5)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>BR_BusinessPlace</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/API_GLO_BUSINESSPLACE_SRV"> successor API</a> instead.
 */
@Deprecated
public interface BrazilBusinessPlaceService extends BatchService<BrazilBusinessPlaceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_LOGBR_BUSINESS_PLACE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BrazilBusinessPlaceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace
     * BusinessPlace} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param branch
     *            Business Place
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace
     *         BusinessPlace} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlaceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPlaceByKeyFluentHelper getBusinessPlaceByKey( final String branch, final String companyCode );

}
