/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.batch.BrazilNotaFiscalServiceBatch;

/**
 * <p>
 * This service is based on the OData and can be consumed in Brazilian integration scenarios. To create a nota fiscal
 * document, enter the nota fiscal data - the system generates the nota fiscal and returns the document number. To
 * update a nota fiscal document, enter the document number and the data to be changed - the system updates the nota
 * fiscal accordingly.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6a/7e35da2f4e45ee9a0be69b61bf7765/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LOGBR_NOTAFISCAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LOGBR_NOTAFISCAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Brazil Nota Fiscal Integration(SAP_COM_0387)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2RP'>Electronic Documents(2RP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Nota Fiscal</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BrazilNotaFiscalService extends BatchService<BrazilNotaFiscalServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_LOGBR_NOTAFISCAL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BrazilNotaFiscalService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     * BR_NFAdditionalInformation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     *         BR_NFAdditionalInformation} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFAdditionalInformationFluentHelper getAllBR_NFAdditionalInformation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     * BR_NFAdditionalInformation} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NFAdditionalInformationID
     *            Field ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param bR_NFInfoFieldUsage
     *            Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     *         BR_NFAdditionalInformation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFAdditionalInformationByKeyFluentHelper getBR_NFAdditionalInformationByKey(
        final String bR_NotaFiscal,
        final String bR_NFInfoFieldUsage,
        final String bR_NFAdditionalInformationID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     * BR_NFAdditionalInformation} entity and save it to the S/4HANA system.
     *
     * @param bR_NFAdditionalInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     *            BR_NFAdditionalInformation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     *         BR_NFAdditionalInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFAdditionalInformationUpdateFluentHelper
        updateBR_NFAdditionalInformation( @Nonnull final BR_NFAdditionalInformation bR_NFAdditionalInformation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     * BR_NFAdditionImportDoc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     *         BR_NFAdditionImportDoc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFAdditionImportDocFluentHelper getAllBR_NFAdditionImportDoc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     * BR_NFAdditionImportDoc} entity using key fields.
     *
     * @param bR_NFAddition
     *            Addition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param bR_NFImportDocument
     *            Import Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFItemSequenceNumber
     *            Number of the Item /XML Tag <nSeqAdic>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     *         BR_NFAdditionImportDoc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFAdditionImportDocByKeyFluentHelper getBR_NFAdditionImportDocByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFImportDocument,
        final String bR_NFAddition,
        final String bR_NFItemSequenceNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     * BR_NFAdditionImportDoc} entity and save it to the S/4HANA system.
     *
     * @param bR_NFAdditionImportDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     *            BR_NFAdditionImportDoc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     *         BR_NFAdditionImportDoc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFAdditionImportDocUpdateFluentHelper
        updateBR_NFAdditionImportDoc( @Nonnull final BR_NFAdditionImportDoc bR_NFAdditionImportDoc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     * BR_NFDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument BR_NFDocument}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentFluentHelper getAllBR_NFDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     * BR_NFDocument} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument BR_NFDocument}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentByKeyFluentHelper getBR_NFDocumentByKey( final String bR_NotaFiscal );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     * BR_NFDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     *            BR_NFDocument} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument BR_NFDocument}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentCreateFluentHelper createBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     * BR_NFDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     *            BR_NFDocument} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument BR_NFDocument}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentUpdateFluentHelper updateBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     * BR_NFDocumentReference} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     *         BR_NFDocumentReference} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentReferenceFluentHelper getAllBR_NFDocumentReference();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     * BR_NFDocumentReference} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NFDocRefSequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     *         BR_NFDocumentReference} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentReferenceByKeyFluentHelper
        getBR_NFDocumentReferenceByKey( final String bR_NotaFiscal, final String bR_NFDocRefSequenceNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     * BR_NFDocumentReference} entity and save it to the S/4HANA system.
     *
     * @param bR_NFDocumentReference
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     *            BR_NFDocumentReference} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     *         BR_NFDocumentReference} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFDocumentReferenceUpdateFluentHelper
        updateBR_NFDocumentReference( @Nonnull final BR_NFDocumentReference bR_NFDocumentReference );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment
     * BR_NFePayment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment BR_NFePayment}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFePaymentFluentHelper getAllBR_NFePayment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment
     * BR_NFePayment} entity using key fields.
     *
     * @param sequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment BR_NFePayment}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFePaymentByKeyFluentHelper getBR_NFePaymentByKey( final String bR_NotaFiscal, final String sequenceNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment
     * BR_NFePayment} entity and save it to the S/4HANA system.
     *
     * @param bR_NFePayment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment
     *            BR_NFePayment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment BR_NFePayment}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFePaymentUpdateFluentHelper updateBR_NFePayment( @Nonnull final BR_NFePayment bR_NFePayment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     * BR_NFePharmaceutical} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     *         BR_NFePharmaceutical} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFePharmaceuticalFluentHelper getAllBR_NFePharmaceutical();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     * BR_NFePharmaceutical} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     *         BR_NFePharmaceutical} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFePharmaceuticalByKeyFluentHelper
        getBR_NFePharmaceuticalByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     * BR_NFePharmaceutical} entity and save it to the S/4HANA system.
     *
     * @param bR_NFePharmaceutical
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     *            BR_NFePharmaceutical} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     *         BR_NFePharmaceutical} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFePharmaceuticalUpdateFluentHelper
        updateBR_NFePharmaceutical( @Nonnull final BR_NFePharmaceutical bR_NFePharmaceutical );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     * BR_NFeProductTraceability} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     *         BR_NFeProductTraceability} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFeProductTraceabilityFluentHelper getAllBR_NFeProductTraceability();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     * BR_NFeProductTraceability} entity using key fields.
     *
     * @param sequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     *         BR_NFeProductTraceability} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFeProductTraceabilityByKeyFluentHelper getBR_NFeProductTraceabilityByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String sequenceNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     * BR_NFeProductTraceability} entity and save it to the S/4HANA system.
     *
     * @param bR_NFeProductTraceability
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     *            BR_NFeProductTraceability} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     *         BR_NFeProductTraceability} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFeProductTraceabilityUpdateFluentHelper
        updateBR_NFeProductTraceability( @Nonnull final BR_NFeProductTraceability bR_NFeProductTraceability );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     * BR_NFExportDeclaration} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     *         BR_NFExportDeclaration} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFExportDeclarationFluentHelper getAllBR_NFExportDeclaration();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     * BR_NFExportDeclaration} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     *         BR_NFExportDeclaration} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFExportDeclarationByKeyFluentHelper getBR_NFExportDeclarationByKey( final String bR_NotaFiscal );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     * BR_NFExportDeclaration} entity and save it to the S/4HANA system.
     *
     * @param bR_NFExportDeclaration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     *            BR_NFExportDeclaration} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     *         BR_NFExportDeclaration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFExportDeclarationUpdateFluentHelper
        updateBR_NFExportDeclaration( @Nonnull final BR_NFExportDeclaration bR_NFExportDeclaration );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     * BR_NFExportDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     *         BR_NFExportDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFExportDocumentFluentHelper getAllBR_NFExportDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     * BR_NFExportDocument} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFItemExprtSqncNumber
     *            Export Sequence Nmbr
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     *         BR_NFExportDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFExportDocumentByKeyFluentHelper getBR_NFExportDocumentByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFItemExprtSqncNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     * BR_NFExportDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFExportDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     *            BR_NFExportDocument} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     *         BR_NFExportDocument} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFExportDocumentUpdateFluentHelper
        updateBR_NFExportDocument( @Nonnull final BR_NFExportDocument bR_NFExportDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFFuelFluentHelper getAllBR_NFFuel();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel}
     * entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFFuelByKeyFluentHelper getBR_NFFuelByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel
     * BR_NFFuel} entity and save it to the S/4HANA system.
     *
     * @param bR_NFFuel
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFFuelUpdateFluentHelper updateBR_NFFuel( @Nonnull final BR_NFFuel bR_NFFuel );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     * BR_NFFuelOriginIndicator} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     *         BR_NFFuelOriginIndicator} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFFuelOriginIndicatorFluentHelper getAllBR_NFFuelOriginIndicator();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     * BR_NFFuelOriginIndicator} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFOriginRegion
     *            UF of origin of producer or importer
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param bR_NFImportIndicatorFuelOrigin
     *            Import indicator
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     *         BR_NFFuelOriginIndicator} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFFuelOriginIndicatorByKeyFluentHelper getBR_NFFuelOriginIndicatorByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFImportIndicatorFuelOrigin,
        final String bR_NFOriginRegion );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     * BR_NFFuelOriginIndicator} entity and save it to the S/4HANA system.
     *
     * @param bR_NFFuelOriginIndicator
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     *            BR_NFFuelOriginIndicator} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     *         BR_NFFuelOriginIndicator} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFFuelOriginIndicatorUpdateFluentHelper
        updateBR_NFFuelOriginIndicator( @Nonnull final BR_NFFuelOriginIndicator bR_NFFuelOriginIndicator );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     * BR_NFHeaderText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     *         BR_NFHeaderText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFHeaderTextFluentHelper getAllBR_NFHeaderText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     * BR_NFHeaderText} entity using key fields.
     *
     * @param bR_NFTextType
     *            NF text type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param bR_NFTextSequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     *         BR_NFHeaderText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFHeaderTextByKeyFluentHelper getBR_NFHeaderTextByKey(
        final String bR_NotaFiscal,
        final String bR_NFTextType,
        final String bR_NFTextSequenceNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     * BR_NFHeaderText} entity and save it to the S/4HANA system.
     *
     * @param bR_NFHeaderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     *            BR_NFHeaderText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     *         BR_NFHeaderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFHeaderTextUpdateFluentHelper updateBR_NFHeaderText( @Nonnull final BR_NFHeaderText bR_NFHeaderText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     * BR_NFImportDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     *         BR_NFImportDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFImportDocumentFluentHelper getAllBR_NFImportDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     * BR_NFImportDocument} entity using key fields.
     *
     * @param bR_NFImportDocument
     *            Import Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     *         BR_NFImportDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFImportDocumentByKeyFluentHelper
        getBR_NFImportDocumentByKey( final String bR_NotaFiscal, final String bR_NFImportDocument );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     * BR_NFImportDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFImportDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     *            BR_NFImportDocument} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     *         BR_NFImportDocument} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFImportDocumentUpdateFluentHelper
        updateBR_NFImportDocument( @Nonnull final BR_NFImportDocument bR_NFImportDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemFluentHelper getAllBR_NFItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem}
     * entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemByKeyFluentHelper getBR_NFItemByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem
     * BR_NFItem} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemUpdateFluentHelper updateBR_NFItem( @Nonnull final BR_NFItem bR_NFItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     * BR_NFItemAdditionalInfo} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     *         BR_NFItemAdditionalInfo} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemAdditionalInfoFluentHelper getAllBR_NFItemAdditionalInfo();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     * BR_NFItemAdditionalInfo} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFInfoFieldUsage
     *            Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     *         BR_NFItemAdditionalInfo} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemAdditionalInfoByKeyFluentHelper getBR_NFItemAdditionalInfoByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFInfoFieldUsage );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     * BR_NFItemAdditionalInfo} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItemAdditionalInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     *            BR_NFItemAdditionalInfo} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     *         BR_NFItemAdditionalInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemAdditionalInfoUpdateFluentHelper
        updateBR_NFItemAdditionalInfo( @Nonnull final BR_NFItemAdditionalInfo bR_NFItemAdditionalInfo );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE
     * BR_NFItemNVE} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE BR_NFItemNVE}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemNVEFluentHelper getAllBR_NFItemNVE();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE
     * BR_NFItemNVE} entity using key fields.
     *
     * @param bR_NVECode
     *            NF-e NVE Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE BR_NFItemNVE}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemNVEByKeyFluentHelper
        getBR_NFItemNVEByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem, final String bR_NVECode );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE
     * BR_NFItemNVE} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItemNVE
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE BR_NFItemNVE}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE BR_NFItemNVE}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemNVEUpdateFluentHelper updateBR_NFItemNVE( @Nonnull final BR_NFItemNVE bR_NFItemNVE );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText
     * BR_NFItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText BR_NFItemText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemTextFluentHelper getAllBR_NFItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText
     * BR_NFItemText} entity using key fields.
     *
     * @param bR_NFTextType
     *            NF text type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param bR_NFTextSequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText BR_NFItemText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemTextByKeyFluentHelper getBR_NFItemTextByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFTextType,
        final String bR_NFTextSequenceNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText
     * BR_NFItemText} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText
     *            BR_NFItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText BR_NFItemText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFItemTextUpdateFluentHelper updateBR_NFItemText( @Nonnull final BR_NFItemText bR_NFItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner
     * BR_NFPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner BR_NFPartner}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFPartnerFluentHelper getAllBR_NFPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner
     * BR_NFPartner} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NFPartnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner BR_NFPartner}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFPartnerByKeyFluentHelper getBR_NFPartnerByKey( final String bR_NotaFiscal, final String bR_NFPartnerFunction );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner
     * BR_NFPartner} entity and save it to the S/4HANA system.
     *
     * @param bR_NFPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner BR_NFPartner}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner BR_NFPartner}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFPartnerUpdateFluentHelper updateBR_NFPartner( @Nonnull final BR_NFPartner bR_NFPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     * BR_NFReferencedProcess} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     *         BR_NFReferencedProcess} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFReferencedProcessFluentHelper getAllBR_NFReferencedProcess();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     * BR_NFReferencedProcess} entity using key fields.
     *
     * @param bR_NFReferencedProcessSqncNmbr
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     *         BR_NFReferencedProcess} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFReferencedProcessByKeyFluentHelper
        getBR_NFReferencedProcessByKey( final String bR_NotaFiscal, final String bR_NFReferencedProcessSqncNmbr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     * BR_NFReferencedProcess} entity and save it to the S/4HANA system.
     *
     * @param bR_NFReferencedProcess
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     *            BR_NFReferencedProcess} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     *         BR_NFReferencedProcess} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFReferencedProcessUpdateFluentHelper
        updateBR_NFReferencedProcess( @Nonnull final BR_NFReferencedProcess bR_NFReferencedProcess );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     * BR_NFSugarCaneDeductible} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     *         BR_NFSugarCaneDeductible} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFSugarCaneDeductibleFluentHelper getAllBR_NFSugarCaneDeductible();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     * BR_NFSugarCaneDeductible} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param sugarcaneDcblSqncNmbr
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     *         BR_NFSugarCaneDeductible} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFSugarCaneDeductibleByKeyFluentHelper
        getBR_NFSugarCaneDeductibleByKey( final String bR_NotaFiscal, final String sugarcaneDcblSqncNmbr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     * BR_NFSugarCaneDeductible} entity and save it to the S/4HANA system.
     *
     * @param bR_NFSugarCaneDeductible
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     *            BR_NFSugarCaneDeductible} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     *         BR_NFSugarCaneDeductible} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFSugarCaneDeductibleUpdateFluentHelper
        updateBR_NFSugarCaneDeductible( @Nonnull final BR_NFSugarCaneDeductible bR_NFSugarCaneDeductible );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     * BR_NFSugarCaneSupply} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     *         BR_NFSugarCaneSupply} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFSugarCaneSupplyFluentHelper getAllBR_NFSugarCaneSupply();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     * BR_NFSugarCaneSupply} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param sugarcaneDayOfCurrentMnth
     *            Day of Current Month
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     *         BR_NFSugarCaneSupply} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFSugarCaneSupplyByKeyFluentHelper
        getBR_NFSugarCaneSupplyByKey( final String bR_NotaFiscal, final String sugarcaneDayOfCurrentMnth );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     * BR_NFSugarCaneSupply} entity and save it to the S/4HANA system.
     *
     * @param bR_NFSugarCaneSupply
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     *            BR_NFSugarCaneSupply} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     *         BR_NFSugarCaneSupply} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFSugarCaneSupplyUpdateFluentHelper
        updateBR_NFSugarCaneSupply( @Nonnull final BR_NFSugarCaneSupply bR_NFSugarCaneSupply );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTAXFluentHelper getAllBR_NFTAX();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX}
     * entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_TaxType
     *            Tax Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTAXByKeyFluentHelper
        getBR_NFTAXByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem, final String bR_TaxType );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX}
     * entity and save it to the S/4HANA system.
     *
     * @param bR_NFTAX
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTAXUpdateFluentHelper updateBR_NFTAX( @Nonnull final BR_NFTAX bR_NFTAX );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     * BR_NFTradeNote} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     *         BR_NFTradeNote} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTradeNoteFluentHelper getAllBR_NFTradeNote();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     * BR_NFTradeNote} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NFTradeNoteSequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     *         BR_NFTradeNote} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTradeNoteByKeyFluentHelper
        getBR_NFTradeNoteByKey( final String bR_NotaFiscal, final String bR_NFTradeNoteSequenceNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     * BR_NFTradeNote} entity and save it to the S/4HANA system.
     *
     * @param bR_NFTradeNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     *            BR_NFTradeNote} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     *         BR_NFTradeNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTradeNoteUpdateFluentHelper updateBR_NFTradeNote( @Nonnull final BR_NFTradeNote bR_NFTradeNote );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer
     * BR_NFTrailer} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer BR_NFTrailer}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTrailerFluentHelper getAllBR_NFTrailer();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer
     * BR_NFTrailer} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param trailerID
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer BR_NFTrailer}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTrailerByKeyFluentHelper getBR_NFTrailerByKey( final String bR_NotaFiscal, final String trailerID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer
     * BR_NFTrailer} entity and save it to the S/4HANA system.
     *
     * @param bR_NFTrailer
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer BR_NFTrailer}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer BR_NFTrailer}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTrailerUpdateFluentHelper updateBR_NFTrailer( @Nonnull final BR_NFTrailer bR_NFTrailer );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     * BR_NFTransportedVolume} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     *         BR_NFTransportedVolume} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTransportedVolumeFluentHelper getAllBR_NFTransportedVolume();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     * BR_NFTransportedVolume} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NFTransptVolumesSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     *         BR_NFTransportedVolume} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTransportedVolumeByKeyFluentHelper
        getBR_NFTransportedVolumeByKey( final String bR_NotaFiscal, final String bR_NFTransptVolumesSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     * BR_NFTransportedVolume} entity and save it to the S/4HANA system.
     *
     * @param bR_NFTransportedVolume
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     *            BR_NFTransportedVolume} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     *         BR_NFTransportedVolume} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFTransportedVolumeUpdateFluentHelper
        updateBR_NFTransportedVolume( @Nonnull final BR_NFTransportedVolume bR_NFTransportedVolume );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle
     * BR_NFVehicle} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle BR_NFVehicle}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFVehicleFluentHelper getAllBR_NFVehicle();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle
     * BR_NFVehicle} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle BR_NFVehicle}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFVehicleByKeyFluentHelper getBR_NFVehicleByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle
     * BR_NFVehicle} entity and save it to the S/4HANA system.
     *
     * @param bR_NFVehicle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle BR_NFVehicle}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle BR_NFVehicle}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_NFVehicleUpdateFluentHelper updateBR_NFVehicle( @Nonnull final BR_NFVehicle bR_NFVehicle );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     * BR_OneTimePartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     *         BR_OneTimePartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_OneTimePartnerFluentHelper getAllBR_OneTimePartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     * BR_OneTimePartner} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_PartnerFunction
     *            Nota Fiscal Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     *         BR_OneTimePartner} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_OneTimePartnerByKeyFluentHelper
        getBR_OneTimePartnerByKey( final String bR_NotaFiscal, final String bR_PartnerFunction );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     * BR_OneTimePartner} entity and save it to the S/4HANA system.
     *
     * @param bR_OneTimePartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     *            BR_OneTimePartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     *         BR_OneTimePartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_OneTimePartnerUpdateFluentHelper updateBR_OneTimePartner( @Nonnull final BR_OneTimePartner bR_OneTimePartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     * BR_TechnicalResponsible} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     *         BR_TechnicalResponsible} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_TechnicalResponsibleFluentHelper getAllBR_TechnicalResponsible();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     * BR_TechnicalResponsible} entity using key fields.
     *
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     *         BR_TechnicalResponsible} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_TechnicalResponsibleByKeyFluentHelper getBR_TechnicalResponsibleByKey( final String bR_NotaFiscal );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     * BR_TechnicalResponsible} entity and save it to the S/4HANA system.
     *
     * @param bR_TechnicalResponsible
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     *            BR_TechnicalResponsible} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     *         BR_TechnicalResponsible} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BR_TechnicalResponsibleUpdateFluentHelper
        updateBR_TechnicalResponsible( @Nonnull final BR_TechnicalResponsible bR_TechnicalResponsible );

}
