/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.batch.BudgetAccountServiceBatch;

/**
 * <p>
 * This service enables you to read the budget account master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fe/2e1ab0627041989ff48a2edad5ea3a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETACCOUNTCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETACCOUNTCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BudgetAccountService extends BatchService<BudgetAccountServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUDGETACCOUNTCORE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BudgetAccountService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore
     * BudgetAccountCore} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore
     *         BudgetAccountCore} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetAccountCoreFluentHelper getAllBudgetAccountCore();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore
     * BudgetAccountCore} entity using key fields.
     *
     * @param pubSecBudgetAccount
     *            Budget Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pubSecBudgetAccountCoCode
     *            Budget Account Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore
     *         BudgetAccountCore} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetAccountCoreByKeyFluentHelper
        getBudgetAccountCoreByKey( final String pubSecBudgetAccount, final String pubSecBudgetAccountCoCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText
     * BudgetAccountCoreText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText
     *         BudgetAccountCoreText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetAccountCoreTextFluentHelper getAllBudgetAccountCoreText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText
     * BudgetAccountCoreText} entity using key fields.
     *
     * @param pubSecBudgetAccount
     *            Budget Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param pubSecBudgetAccountCoCode
     *            Budget Account Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText
     *         BudgetAccountCoreText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetAccountCoreTextByKeyFluentHelper getBudgetAccountCoreTextByKey(
        final String pubSecBudgetAccount,
        final String pubSecBudgetAccountCoCode,
        final String language );

}
