/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.batch.BudgetPeriodHierarchyServiceBatch;

/**
 * <p>
 *
 * This service enables you to read the budget period hierarchy data from SAP S/4HANA Cloud system. This service is
 * based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6a/b585980a7b4885a8ea01280ab218f0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETPERIODCOREHIER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETPERIODCOREHIER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Budget Period</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BudgetPeriodHierarchyService extends BatchService<BudgetPeriodHierarchyServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUDGETPERIODCOREHIER";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BudgetPeriodHierarchyService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy
     * BudgetPeriodCoreHierarchy} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy
     *         BudgetPeriodCoreHierarchy} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierarchyFluentHelper getAllBudgetPeriodCoreHierarchy();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy
     * BudgetPeriodCoreHierarchy} entity using key fields.
     *
     * @param budgetPeriodHierarchy
     *            Budget Period Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy
     *         BudgetPeriodCoreHierarchy} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierarchyByKeyFluentHelper
        getBudgetPeriodCoreHierarchyByKey( final String budgetPeriodHierarchy, final LocalDateTime validityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText
     * BudgetPeriodCoreHierarchyText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText
     *         BudgetPeriodCoreHierarchyText} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierarchyTextFluentHelper getAllBudgetPeriodCoreHierarchyText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText
     * BudgetPeriodCoreHierarchyText} entity using key fields.
     *
     * @param budgetPeriodHierarchy
     *            Budget Period Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText
     *         BudgetPeriodCoreHierarchyText} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierarchyTextByKeyFluentHelper getBudgetPeriodCoreHierarchyTextByKey(
        final String budgetPeriodHierarchy,
        final LocalDateTime validityEndDate,
        final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode
     * BudgetPeriodCoreHierNode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode
     *         BudgetPeriodCoreHierNode} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierNodeFluentHelper getAllBudgetPeriodCoreHierNode();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode
     * BudgetPeriodCoreHierNode} entity using key fields.
     *
     * @param budgetPeriodHierarchy
     *            Budget Period Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode
     *         BudgetPeriodCoreHierNode} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierNodeByKeyFluentHelper getBudgetPeriodCoreHierNodeByKey(
        final String budgetPeriodHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeText
     * BudgetPeriodCoreHierarchyNodeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeText
     *         BudgetPeriodCoreHierarchyNodeText} entities. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierarchyNodeTextFluentHelper getAllBudgetPeriodCoreHierarchyNodeText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeText
     * BudgetPeriodCoreHierarchyNodeText} entity using key fields.
     *
     * @param budgetPeriodHierarchy
     *            Budget Period Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeText
     *         BudgetPeriodCoreHierarchyNodeText} entity using key fields. This fluent helper allows methods which
     *         modify the underlying query to be called before executing the query itself. To perform execution, call
     *         the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper getBudgetPeriodCoreHierarchyNodeTextByKey(
        final String budgetPeriodHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language );

}
