/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.batch.BudgetPeriodServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the budget period master data from SAP S/4HANA Cloud
 * system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/3b/2bfd60176c444f8fdd2eaf3bbb0251/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETPERIODCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETPERIODCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Budget Period</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BudgetPeriodService extends BatchService<BudgetPeriodServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUDGETPERIODCORE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BudgetPeriodService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodFluentHelper getAllBudgetPeriod();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     * entity using key fields.
     *
     * @param budgetPeriod
     *            Budget Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodByKeyFluentHelper getBudgetPeriodByKey( final String budgetPeriod );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     * entity and save it to the S/4HANA system.
     *
     * @param budgetPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCreateFluentHelper createBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod
     * BudgetPeriod} entity and save it to the S/4HANA system.
     *
     * @param budgetPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodUpdateFluentHelper updateBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod
     * BudgetPeriod} entity in the S/4HANA system.
     *
     * @param budgetPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodDeleteFluentHelper deleteBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     * BudgetPeriodCoreText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     *         BudgetPeriodCoreText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreTextFluentHelper getAllBudgetPeriodCoreText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     * BudgetPeriodCoreText} entity using key fields.
     *
     * @param budgetPeriod
     *            Budget Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     *         BudgetPeriodCoreText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreTextByKeyFluentHelper
        getBudgetPeriodCoreTextByKey( final String language, final String budgetPeriod );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     * BudgetPeriodCoreText} entity and save it to the S/4HANA system.
     *
     * @param budgetPeriodCoreText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     *            BudgetPeriodCoreText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     *         BudgetPeriodCoreText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodCoreTextUpdateFluentHelper
        updateBudgetPeriodCoreText( @Nonnull final BudgetPeriodCoreText budgetPeriodCoreText );

}
