/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetailsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetailsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.batch.BufferProfileServiceBatch;

/**
 * <p>
 *
 * The service contains header and item entities. For read operations, filter information must be sent according to the
 * OData protocol. All filter information is utilized when retrieving buffer profile. The buffer profile assigned to
 * plant and the buffer profile details are sent in the response. If any issues arise when buffer profiles are
 * retrieved, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8a/10dda19ed746158b6b2b2c5a020316/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUFFER_PROFILE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUFFER_PROFILE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Buffer Profile Integration(SAP_COM_0349)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Y2'>Demand-Driven Buffer Level Management(1Y2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BufferProfileService extends BatchService<BufferProfileServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUFFER_PROFILE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BufferProfileService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails
     * ProfileDetails} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails ProfileDetails}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetailsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfileDetailsFluentHelper getAllProfileDetails();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails
     * ProfileDetails} entity using key fields.
     *
     * @param isMinOrderQtyConsidered
     *            Is Minimum Order Quantity Considered
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param variabilityCode
     *            Variability Co-efficient Indicator
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param replenishmentLeadTimeCode
     *            Decoupled Lead Time Indicator
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param procurementType
     *            Procurement Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails ProfileDetails}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetailsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfileDetailsByKeyFluentHelper getProfileDetailsByKey(
        final String plant,
        final String procurementType,
        final String variabilityCode,
        final String replenishmentLeadTimeCode,
        final String isMinOrderQtyConsidered );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant
     * ProfileAssignedToPlant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant
     *         ProfileAssignedToPlant} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfileAssignedToPlantFluentHelper getAllProfileAssignedToPlant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant
     * ProfileAssignedToPlant} entity using key fields.
     *
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant
     *         ProfileAssignedToPlant} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfileAssignedToPlantByKeyFluentHelper getProfileAssignedToPlantByKey( final String plant );

}
