/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStockByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.AdoptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DiscardFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ResumeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.SuspendFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.batch.BufferSizingServiceBatch;

/**
 * <p>
 *
 * The service contains header and item entities. For read operations, filter information must be sent according to the
 * OData protocol. All filter information is utilized when retrieving buffer sizing data, such as, buffer proposals,
 * average daily usage (ADU), decoupled lead time (DLT), demand and zone adjustments. The buffer proposal, ADU, DLT,
 * longest path in BOM, and actual stock level details are sent in the response. If any issues arise when buffer sizing
 * details are retrieved, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/9f71272fd044d1958f2a08474086a0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUFFERSIZING_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUFFERSIZING_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Buffer Sizing Integration(SAP_COM_0359)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Y2'>Demand-Driven Buffer Level Management(1Y2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BufferSizingService extends BatchService<BufferSizingServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUFFERSIZING_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BufferSizingService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     * DemandAdjustments} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     *         DemandAdjustments} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandAdjustmentsFluentHelper getAllDemandAdjustments();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     * DemandAdjustments} entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param proposalDmndAdjmtFctrStartDate
     *            Proposal Details Valid From
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param proposalStartDate
     *            Proposal Validity From Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     *         DemandAdjustments} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandAdjustmentsByKeyFluentHelper getDemandAdjustmentsByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final LocalDateTime proposalDmndAdjmtFctrStartDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     * DemandAdjustments} entity and save it to the S/4HANA system.
     *
     * @param demandAdjustments
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     *            DemandAdjustments} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     *         DemandAdjustments} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandAdjustmentsUpdateFluentHelper updateDemandAdjustments( @Nonnull final DemandAdjustments demandAdjustments );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     * DemandAdjustmentFactors} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     *         DemandAdjustmentFactors} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandAdjustmentFactorsFluentHelper getAllDemandAdjustmentFactors();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     * DemandAdjustmentFactors} entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param proposalDmndAdjmtFctrStartDate
     *            Proposal Details Valid From
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param proposalStartDate
     *            Proposal Validity From Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     *         DemandAdjustmentFactors} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandAdjustmentFactorsByKeyFluentHelper getDemandAdjustmentFactorsByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final LocalDateTime proposalDmndAdjmtFctrStartDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     * DemandAdjustmentFactors} entity and save it to the S/4HANA system.
     *
     * @param demandAdjustmentFactors
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     *            DemandAdjustmentFactors} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     *         DemandAdjustmentFactors} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandAdjustmentFactorsUpdateFluentHelper
        updateDemandAdjustmentFactors( @Nonnull final DemandAdjustmentFactors demandAdjustmentFactors );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments
     * ZoneAdjustments} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments ZoneAdjustments}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ZoneAdjustmentsFluentHelper getAllZoneAdjustments();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments
     * ZoneAdjustments} entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bufPrpslZoneAdjmtFctrStartDate
     *            Proposal Zones Valid From
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param proposalStartDate
     *            Proposal Validity From Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments ZoneAdjustments}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ZoneAdjustmentsByKeyFluentHelper getZoneAdjustmentsByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final LocalDateTime bufPrpslZoneAdjmtFctrStartDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments
     * ZoneAdjustments} entity and save it to the S/4HANA system.
     *
     * @param zoneAdjustments
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments
     *            ZoneAdjustments} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments ZoneAdjustments}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ZoneAdjustmentsUpdateFluentHelper updateZoneAdjustments( @Nonnull final ZoneAdjustments zoneAdjustments );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader
     * ProposalHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader ProposalHeader}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProposalHeaderFluentHelper getAllProposalHeader();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader
     * ProposalHeader} entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param proposalStartDate
     *            Proposal Validity From Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader ProposalHeader}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProposalHeaderByKeyFluentHelper getProposalHeaderByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader
     * ProposalHeader} entity and save it to the S/4HANA system.
     *
     * @param proposalHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader ProposalHeader}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader ProposalHeader}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProposalHeaderCreateFluentHelper createProposalHeader( @Nonnull final ProposalHeader proposalHeader );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock ActualStock}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock ActualStock}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualStockFluentHelper getAllActualStock();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock ActualStock}
     * entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bufferLevelStartDate
     *            Valid-From Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock ActualStock} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStockByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualStockByKeyFluentHelper getActualStockByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime bufferLevelStartDate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM
     * LongestPathInBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM
     *         LongestPathInBOM} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LongestPathInBOMFluentHelper getAllLongestPathInBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM
     * LongestPathInBOM} entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param billOfMaterialComponent
     *            BOM component
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param billOfMaterialUUID
     *            Internal Key for BOMID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param parentComponent
     *            Parent BOM Component
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param componentPlant
     *            Component Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param parentPlant
     *            Parent Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param proposalStartDate
     *            Proposal Validity From Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM
     *         LongestPathInBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LongestPathInBOMByKeyFluentHelper getLongestPathInBOMByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final UUID billOfMaterialUUID,
        final String parentComponent,
        final String parentPlant,
        final String billOfMaterialComponent,
        final String componentPlant );

    /**
     * <p>
     * Creates a fluent helper for the <b>Adopt</b> OData function import.
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MRPArea</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalVersion</b>
     *            </p>
     * @param proposalStartDate
     *            Proposal Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalStartDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Adopt</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.AdoptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AdoptFluentHelper adopt(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion );

    /**
     * <p>
     * Creates a fluent helper for the <b>Discard</b> OData function import.
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MRPArea</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalVersion</b>
     *            </p>
     * @param proposalStartDate
     *            Proposal Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalStartDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Discard</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DiscardFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DiscardFluentHelper discard(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion );

    /**
     * <p>
     * Creates a fluent helper for the <b>Resume</b> OData function import.
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MRPArea</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalVersion</b>
     *            </p>
     * @param proposalStartDate
     *            Proposal Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalStartDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Resume</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ResumeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResumeFluentHelper resume(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion );

    /**
     * <p>
     * Creates a fluent helper for the <b>Suspend</b> OData function import.
     * </p>
     *
     * @param proposalRunSuspendedToDate
     *            Prpsl Run Susp End
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalRunSuspendedToDate</b>
     *            </p>
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MRPArea</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param proposalVersion
     *            Proposal Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalVersion</b>
     *            </p>
     * @param proposalRunSuspendedFromDate
     *            Prpsl Run Susp Start
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalRunSuspendedFromDate</b>
     *            </p>
     * @param stockLevelProposalStatus
     *            Proposal Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StockLevelProposalStatus</b>
     *            </p>
     * @param proposalStartDate
     *            Proposal Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProposalStartDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Suspend</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.SuspendFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuspendFluentHelper suspend(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion,
        @Nullable final String stockLevelProposalStatus,
        @Nullable final LocalDateTime proposalRunSuspendedFromDate,
        @Nullable final LocalDateTime proposalRunSuspendedToDate );

}
