/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BehqueuedataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BehqueuedataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjectsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjectsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeysByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeysFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.batch.BusinessEventQueueServiceBatch;

/**
 * <p>
 *
 * The service reads business events from a queue for a given subscriber. The business event contains the type and the
 * key of the object triggering the event and the action. There are appropriate checks for restricted values and
 * authorizations. The system displays a failure message in the response if the entry is invalid..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6a/c73813685a44ddaadb2fbdd86e92a5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/C_BEHQUEUEDATA_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>C_BEHQUEUEDATA_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>OpenText Business Event Integration(SAP_COM_0007), Business Event Handling Integration
 * (Obsolete)(SAP_COM_0121)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NN'>Business Event Handling(1NN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessEventQueueService extends BatchService<BusinessEventQueueServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/C_BEHQUEUEDATA_CDS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessEventQueueService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata
     * Behqueuedata} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata Behqueuedata}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BehqueuedataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BehqueuedataFluentHelper getAllBehqueuedata();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata
     * Behqueuedata} entity using key fields.
     *
     * @param businessEvent
     *            GUID of an Event
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata Behqueuedata}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BehqueuedataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BehqueuedataByKeyFluentHelper getBehqueuedataByKey( final UUID businessEvent );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys
     * BusinessObjectKeys} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys
     *         BusinessObjectKeys} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeysFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessObjectKeysFluentHelper getAllBusinessObjectKeys();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys
     * BusinessObjectKeys} entity using key fields.
     *
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys
     *         BusinessObjectKeys} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeysByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessObjectKeysByKeyFluentHelper getBusinessObjectKeysByKey( final String sAPObjectType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects
     * BusObjects} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects BusObjects}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjectsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusObjectsFluentHelper getAllBusObjects();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects
     * BusObjects} entity using key fields.
     *
     * @param sAPObjectTaskCode
     *            Business Event Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param sAPObjectTypeName
     *            SAP Object Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 80
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param sAPObjectTaskTypeName
     *            SAP Object Task Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 80
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects BusObjects}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjectsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusObjectsByKeyFluentHelper getBusObjectsByKey(
        final String sAPObjectType,
        final String sAPObjectTypeName,
        final String sAPObjectTaskCode,
        final String sAPObjectTaskTypeName );

}
