/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionReadByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionReadFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.batch.BusinessEventSubscriptionServiceBatch;

/**
 * <p>
 *
 * This service enables the caller to create a subscription for business events for a given subscriber. A subscription
 * is required to activate the events so they are delivered to the event queue where they can be read. The information
 * sent in the request as a payload is used to maintain a business events subscription, make the appropriate checks for
 * restricted values and authorizations. Once an event subscription is maintained, the system displays a success or
 * failure message in the response.
 *
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/31/ca00d025e14973a1d9cd727cc09419/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CA_BEH_SUBSCRIPTION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CA_BEH_SUBSCRIPTION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>OpenText Business Event Integration(SAP_COM_0007), Business Event Handling Integration
 * (Obsolete)(SAP_COM_0121)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NN'>Business Event Handling(1NN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessEventSubscriptionService extends BatchService<BusinessEventSubscriptionServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/CA_BEH_SUBSCRIPTION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessEventSubscriptionService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     * SubscriptionMaintain} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *         SubscriptionMaintain} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubscriptionMaintainFluentHelper getAllSubscriptionMaintain();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     * SubscriptionMaintain} entity using key fields.
     *
     * @param busEventSubscriberCode
     *            Subscriber ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param sAPObjectTaskCode
     *            SAP Object Task Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *         SubscriptionMaintain} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubscriptionMaintainByKeyFluentHelper getSubscriptionMaintainByKey(
        final String busEventSubscriberCode,
        final String sAPObjectType,
        final String sAPObjectTaskCode );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     * SubscriptionMaintain} entity and save it to the S/4HANA system.
     *
     * @param subscriptionMaintain
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *            SubscriptionMaintain} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *         SubscriptionMaintain} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubscriptionMaintainCreateFluentHelper
        createSubscriptionMaintain( @Nonnull final SubscriptionMaintain subscriptionMaintain );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     * SubscriptionMaintain} entity and save it to the S/4HANA system.
     *
     * @param subscriptionMaintain
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *            SubscriptionMaintain} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *         SubscriptionMaintain} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubscriptionMaintainUpdateFluentHelper
        updateSubscriptionMaintain( @Nonnull final SubscriptionMaintain subscriptionMaintain );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
     * SubscriptionRead} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
     *         SubscriptionRead} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionReadFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubscriptionReadFluentHelper getAllSubscriptionRead();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
     * SubscriptionRead} entity using key fields.
     *
     * @param busEventSubscriberCode
     *            Subscriber ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param sAPObjectTaskCode
     *            SAP Object Task Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
     *         SubscriptionRead} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionReadByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubscriptionReadByKeyFluentHelper getSubscriptionReadByKey(
        final String busEventSubscriberCode,
        final String sAPObjectType,
        final String sAPObjectTaskCode );

}
