/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.batch.BusinessPartnerServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, display, update, and delete data related to Business Partner, Supplier, and
 * Customer with the data provided in a payload, in an API call. This service also supports create deep entity operation
 * and batch processing..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/85/043858ea0f9244e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUSINESS_PARTNER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUSINESS_PARTNER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Partner, Customer and Supplier Integration(SAP_COM_0008), SAP Analytics Cloud for Planning
 * Integration(SAP_COM_0087), SAP Real Estate Contract API Integration(SAP_COM_0393), Excise Tax
 * Integration(SAP_COM_0568), Delivery Insights Replication App Integration (Obsolete)(SAP_COM_0571), Procurement -
 * Supplier Quotation Management Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1RO'>Master Data Integration(1RO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4N6'>SAP Central Invoice Management Backend Enablement(4N6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1T6'>Lease-In Accounting(1T6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/21Q'>Lease-Out Accounting(21Q)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/21R'>Service Contract(21R)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O1Q'>Lease-Out Accounting(O1Q)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O1R'>Service Contract(O1R)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OT6'>Lease-In Accounting(OT6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4X3'>Integration of SAP S/4HANA and SAP Cloud for Real
 * Estate(4X3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax
 * Management(4LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights Enabled by IoT(4IH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Partner</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessPartnerService extends BatchService<BusinessPartnerServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUSINESS_PARTNER";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessPartnerService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *         AddressEmailAddress} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressEmailAddressFluentHelper getAllAddressEmailAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity using key fields.
     *
     * @param ordinalNumber
     *            Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param person
     *            Person Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *         AddressEmailAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressEmailAddressByKeyFluentHelper
        getAddressEmailAddressByKey( final String addressID, final String person, final String ordinalNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity and save it to the S/4HANA system.
     *
     * @param addressEmailAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *            AddressEmailAddress} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *         AddressEmailAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressEmailAddressCreateFluentHelper
        createAddressEmailAddress( @Nonnull final AddressEmailAddress addressEmailAddress );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity and save it to the S/4HANA system.
     *
     * @param addressEmailAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *            AddressEmailAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *         AddressEmailAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressEmailAddressUpdateFluentHelper
        updateAddressEmailAddress( @Nonnull final AddressEmailAddress addressEmailAddress );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity in the S/4HANA system.
     *
     * @param addressEmailAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *            AddressEmailAddress} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *         AddressEmailAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressEmailAddressDeleteFluentHelper
        deleteAddressEmailAddress( @Nonnull final AddressEmailAddress addressEmailAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *         AddressFaxNumber} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressFaxNumberFluentHelper getAllAddressFaxNumber();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity using key fields.
     *
     * @param ordinalNumber
     *            Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param person
     *            Person Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *         AddressFaxNumber} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressFaxNumberByKeyFluentHelper
        getAddressFaxNumberByKey( final String addressID, final String person, final String ordinalNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity and save it to the S/4HANA system.
     *
     * @param addressFaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *            AddressFaxNumber} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *         AddressFaxNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressFaxNumberCreateFluentHelper createAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity and save it to the S/4HANA system.
     *
     * @param addressFaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *            AddressFaxNumber} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *         AddressFaxNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressFaxNumberUpdateFluentHelper updateAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity in the S/4HANA system.
     *
     * @param addressFaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *            AddressFaxNumber} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *         AddressFaxNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressFaxNumberDeleteFluentHelper deleteAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *         AddressHomePageURL} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressHomePageURLFluentHelper getAllAddressHomePageURL();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity using key fields.
     *
     * @param ordinalNumber
     *            Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param validityStartDate
     *            Valid-from date - in current Release only 00010101 possible
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param isDefaultURLAddress
     *            Flag: this address is the default address
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param person
     *            Person Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *         AddressHomePageURL} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressHomePageURLByKeyFluentHelper getAddressHomePageURLByKey(
        final String addressID,
        final String person,
        final String ordinalNumber,
        final LocalDateTime validityStartDate,
        final Boolean isDefaultURLAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity and save it to the S/4HANA system.
     *
     * @param addressHomePageURL
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *            AddressHomePageURL} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *         AddressHomePageURL} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressHomePageURLCreateFluentHelper
        createAddressHomePageURL( @Nonnull final AddressHomePageURL addressHomePageURL );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity and save it to the S/4HANA system.
     *
     * @param addressHomePageURL
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *            AddressHomePageURL} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *         AddressHomePageURL} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressHomePageURLUpdateFluentHelper
        updateAddressHomePageURL( @Nonnull final AddressHomePageURL addressHomePageURL );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity in the S/4HANA system.
     *
     * @param addressHomePageURL
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *            AddressHomePageURL} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *         AddressHomePageURL} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressHomePageURLDeleteFluentHelper
        deleteAddressHomePageURL( @Nonnull final AddressHomePageURL addressHomePageURL );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *         AddressPhoneNumber} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressPhoneNumberFluentHelper getAllAddressPhoneNumber();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity using key fields.
     *
     * @param ordinalNumber
     *            Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param person
     *            Person Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *         AddressPhoneNumber} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressPhoneNumberByKeyFluentHelper
        getAddressPhoneNumberByKey( final String addressID, final String person, final String ordinalNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity and save it to the S/4HANA system.
     *
     * @param addressPhoneNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *            AddressPhoneNumber} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *         AddressPhoneNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressPhoneNumberCreateFluentHelper
        createAddressPhoneNumber( @Nonnull final AddressPhoneNumber addressPhoneNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity and save it to the S/4HANA system.
     *
     * @param addressPhoneNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *            AddressPhoneNumber} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *         AddressPhoneNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressPhoneNumberUpdateFluentHelper
        updateAddressPhoneNumber( @Nonnull final AddressPhoneNumber addressPhoneNumber );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity in the S/4HANA system.
     *
     * @param addressPhoneNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *            AddressPhoneNumber} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *         AddressPhoneNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddressPhoneNumberDeleteFluentHelper
        deleteAddressPhoneNumber( @Nonnull final AddressPhoneNumber addressPhoneNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *         BPAddrDepdntIntlLocNumber} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPAddrDepdntIntlLocNumberFluentHelper getAllBPAddrDepdntIntlLocNumber();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *         BPAddrDepdntIntlLocNumber} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPAddrDepdntIntlLocNumberByKeyFluentHelper
        getBPAddrDepdntIntlLocNumberByKey( final String businessPartner, final String addressID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity and save it to the S/4HANA system.
     *
     * @param bPAddrDepdntIntlLocNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *            BPAddrDepdntIntlLocNumber} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *         BPAddrDepdntIntlLocNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPAddrDepdntIntlLocNumberCreateFluentHelper
        createBPAddrDepdntIntlLocNumber( @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity and save it to the S/4HANA system.
     *
     * @param bPAddrDepdntIntlLocNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *            BPAddrDepdntIntlLocNumber} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *         BPAddrDepdntIntlLocNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPAddrDepdntIntlLocNumberUpdateFluentHelper
        updateBPAddrDepdntIntlLocNumber( @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity in the S/4HANA system.
     *
     * @param bPAddrDepdntIntlLocNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *            BPAddrDepdntIntlLocNumber} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *         BPAddrDepdntIntlLocNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPAddrDepdntIntlLocNumberDeleteFluentHelper
        deleteBPAddrDepdntIntlLocNumber( @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     * BPContactToAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     *         BPContactToAddress} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPContactToAddressFluentHelper getAllBPContactToAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     * BPContactToAddress} entity using key fields.
     *
     * @param businessPartnerPerson
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerCompany
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Validity Date (Valid To)
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param relationshipNumber
     *            BP Relationship Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     *         BPContactToAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPContactToAddressByKeyFluentHelper getBPContactToAddressByKey(
        final String relationshipNumber,
        final String businessPartnerCompany,
        final String businessPartnerPerson,
        final LocalDateTime validityEndDate,
        final String addressID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     * BPContactToAddress} entity and save it to the S/4HANA system.
     *
     * @param bPContactToAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     *            BPContactToAddress} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     *         BPContactToAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPContactToAddressCreateFluentHelper
        createBPContactToAddress( @Nonnull final BPContactToAddress bPContactToAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     * BPContactToFuncAndDept} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     *         BPContactToFuncAndDept} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPContactToFuncAndDeptFluentHelper getAllBPContactToFuncAndDept();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     * BPContactToFuncAndDept} entity using key fields.
     *
     * @param businessPartnerPerson
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerCompany
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Validity Date (Valid To)
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param relationshipNumber
     *            BP Relationship Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     *         BPContactToFuncAndDept} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPContactToFuncAndDeptByKeyFluentHelper getBPContactToFuncAndDeptByKey(
        final String relationshipNumber,
        final String businessPartnerCompany,
        final String businessPartnerPerson,
        final LocalDateTime validityEndDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     * BPContactToFuncAndDept} entity and save it to the S/4HANA system.
     *
     * @param bPContactToFuncAndDept
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     *            BPContactToFuncAndDept} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     *         BPContactToFuncAndDept} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPContactToFuncAndDeptUpdateFluentHelper
        updateBPContactToFuncAndDept( @Nonnull final BPContactToFuncAndDept bPContactToFuncAndDept );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     * BPCreditWorthiness} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *         BPCreditWorthiness} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPCreditWorthinessFluentHelper getAllBPCreditWorthiness();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     * BPCreditWorthiness} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *         BPCreditWorthiness} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPCreditWorthinessByKeyFluentHelper getBPCreditWorthinessByKey( final String businessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     * BPCreditWorthiness} entity and save it to the S/4HANA system.
     *
     * @param bPCreditWorthiness
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *            BPCreditWorthiness} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *         BPCreditWorthiness} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPCreditWorthinessCreateFluentHelper
        createBPCreditWorthiness( @Nonnull final BPCreditWorthiness bPCreditWorthiness );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     * BPCreditWorthiness} entity and save it to the S/4HANA system.
     *
     * @param bPCreditWorthiness
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *            BPCreditWorthiness} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *         BPCreditWorthiness} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPCreditWorthinessUpdateFluentHelper
        updateBPCreditWorthiness( @Nonnull final BPCreditWorthiness bPCreditWorthiness );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     * BPFinancialServicesExtn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *         BPFinancialServicesExtn} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesExtnFluentHelper getAllBPFinancialServicesExtn();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     * BPFinancialServicesExtn} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *         BPFinancialServicesExtn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesExtnByKeyFluentHelper getBPFinancialServicesExtnByKey( final String businessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     * BPFinancialServicesExtn} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesExtn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *            BPFinancialServicesExtn} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *         BPFinancialServicesExtn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesExtnCreateFluentHelper
        createBPFinancialServicesExtn( @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     * BPFinancialServicesExtn} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesExtn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *            BPFinancialServicesExtn} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *         BPFinancialServicesExtn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesExtnUpdateFluentHelper
        updateBPFinancialServicesExtn( @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     * BPFinancialServicesReporting} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *         BPFinancialServicesReporting} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesReportingFluentHelper getAllBPFinancialServicesReporting();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     * BPFinancialServicesReporting} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *         BPFinancialServicesReporting} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesReportingByKeyFluentHelper getBPFinancialServicesReportingByKey( final String businessPartner );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     * BPFinancialServicesReporting} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesReporting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *            BPFinancialServicesReporting} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *         BPFinancialServicesReporting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesReportingCreateFluentHelper
        createBPFinancialServicesReporting( @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     * BPFinancialServicesReporting} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesReporting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *            BPFinancialServicesReporting} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *         BPFinancialServicesReporting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFinancialServicesReportingUpdateFluentHelper
        updateBPFinancialServicesReporting( @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *         BPFiscalYearInformation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFiscalYearInformationFluentHelper getAllBPFiscalYearInformation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerFiscalYear
     *            Fiscal year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *         BPFiscalYearInformation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFiscalYearInformationByKeyFluentHelper
        getBPFiscalYearInformationByKey( final String businessPartner, final String businessPartnerFiscalYear );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity and save it to the S/4HANA system.
     *
     * @param bPFiscalYearInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *            BPFiscalYearInformation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *         BPFiscalYearInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFiscalYearInformationCreateFluentHelper
        createBPFiscalYearInformation( @Nonnull final BPFiscalYearInformation bPFiscalYearInformation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity and save it to the S/4HANA system.
     *
     * @param bPFiscalYearInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *            BPFiscalYearInformation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *         BPFiscalYearInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFiscalYearInformationUpdateFluentHelper
        updateBPFiscalYearInformation( @Nonnull final BPFiscalYearInformation bPFiscalYearInformation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity in the S/4HANA system.
     *
     * @param bPFiscalYearInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *            BPFiscalYearInformation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *         BPFiscalYearInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPFiscalYearInformationDeleteFluentHelper
        deleteBPFiscalYearInformation( @Nonnull final BPFiscalYearInformation bPFiscalYearInformation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship BPRelationship}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPRelationshipFluentHelper getAllBPRelationship();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity using key fields.
     *
     * @param businessPartner2
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartner1
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Validity Date (Valid To)
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param relationshipNumber
     *            BP Relationship Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship BPRelationship}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPRelationshipByKeyFluentHelper getBPRelationshipByKey(
        final String relationshipNumber,
        final String businessPartner1,
        final String businessPartner2,
        final LocalDateTime validityEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity and save it to the S/4HANA system.
     *
     * @param bPRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     *            BPRelationship} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship BPRelationship}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPRelationshipCreateFluentHelper createBPRelationship( @Nonnull final BPRelationship bPRelationship );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity and save it to the S/4HANA system.
     *
     * @param bPRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     *            BPRelationship} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship BPRelationship}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPRelationshipUpdateFluentHelper updateBPRelationship( @Nonnull final BPRelationship bPRelationship );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity in the S/4HANA system.
     *
     * @param bPRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     *            BPRelationship} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship BPRelationship}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BPRelationshipDeleteFluentHelper deleteBPRelationship( @Nonnull final BPRelationship bPRelationship );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *         BuPaAddressUsage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaAddressUsageFluentHelper getAllBuPaAddressUsage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Validity End of a Business Partner Address Usage
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param addressUsage
     *            Address Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *         BuPaAddressUsage} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaAddressUsageByKeyFluentHelper getBuPaAddressUsageByKey(
        final String businessPartner,
        final ZonedDateTime validityEndDate,
        final String addressUsage,
        final String addressID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity and save it to the S/4HANA system.
     *
     * @param buPaAddressUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *            BuPaAddressUsage} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *         BuPaAddressUsage} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaAddressUsageCreateFluentHelper createBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity and save it to the S/4HANA system.
     *
     * @param buPaAddressUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *            BuPaAddressUsage} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *         BuPaAddressUsage} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaAddressUsageUpdateFluentHelper updateBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity in the S/4HANA system.
     *
     * @param buPaAddressUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *            BuPaAddressUsage} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *         BuPaAddressUsage} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaAddressUsageDeleteFluentHelper deleteBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *         BuPaIdentification} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIdentificationFluentHelper getAllBuPaIdentification();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bPIdentificationNumber
     *            Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param bPIdentificationType
     *            Identification Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *         BuPaIdentification} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIdentificationByKeyFluentHelper getBuPaIdentificationByKey(
        final String businessPartner,
        final String bPIdentificationType,
        final String bPIdentificationNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity and save it to the S/4HANA system.
     *
     * @param buPaIdentification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *            BuPaIdentification} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *         BuPaIdentification} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIdentificationCreateFluentHelper
        createBuPaIdentification( @Nonnull final BuPaIdentification buPaIdentification );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity and save it to the S/4HANA system.
     *
     * @param buPaIdentification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *            BuPaIdentification} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *         BuPaIdentification} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIdentificationUpdateFluentHelper
        updateBuPaIdentification( @Nonnull final BuPaIdentification buPaIdentification );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity in the S/4HANA system.
     *
     * @param buPaIdentification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *            BuPaIdentification} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *         BuPaIdentification} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIdentificationDeleteFluentHelper
        deleteBuPaIdentification( @Nonnull final BuPaIdentification buPaIdentification );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIndustryFluentHelper getAllBuPaIndustry();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity using key fields.
     *
     * @param industrySector
     *            Industry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param industrySystemType
     *            Industry System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIndustryByKeyFluentHelper getBuPaIndustryByKey(
        final String industrySector,
        final String industrySystemType,
        final String businessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity and save it to the S/4HANA system.
     *
     * @param buPaIndustry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIndustryCreateFluentHelper createBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity and save it to the S/4HANA system.
     *
     * @param buPaIndustry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIndustryUpdateFluentHelper updateBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity in the S/4HANA system.
     *
     * @param buPaIndustry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BuPaIndustryDeleteFluentHelper deleteBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     * BusinessPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *         BusinessPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerFluentHelper getAllBusinessPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     * BusinessPartner} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *         BusinessPartner} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerByKeyFluentHelper getBusinessPartnerByKey( final String businessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     * BusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param businessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *            BusinessPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *         BusinessPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerCreateFluentHelper createBusinessPartner( @Nonnull final BusinessPartner businessPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     * BusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param businessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *            BusinessPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *         BusinessPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerUpdateFluentHelper updateBusinessPartner( @Nonnull final BusinessPartner businessPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *         BusinessPartnerAddress} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerAddressFluentHelper getAllBusinessPartnerAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *         BusinessPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerAddressByKeyFluentHelper
        getBusinessPartnerAddressByKey( final String businessPartner, final String addressID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *            BusinessPartnerAddress} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *         BusinessPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerAddressCreateFluentHelper
        createBusinessPartnerAddress( @Nonnull final BusinessPartnerAddress businessPartnerAddress );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *            BusinessPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *         BusinessPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerAddressUpdateFluentHelper
        updateBusinessPartnerAddress( @Nonnull final BusinessPartnerAddress businessPartnerAddress );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity in the S/4HANA system.
     *
     * @param businessPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *            BusinessPartnerAddress} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *         BusinessPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerAddressDeleteFluentHelper
        deleteBusinessPartnerAddress( @Nonnull final BusinessPartnerAddress businessPartnerAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *         BusinessPartnerBank} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerBankFluentHelper getAllBusinessPartnerBank();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bankIdentification
     *            Bank Details ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *         BusinessPartnerBank} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerBankByKeyFluentHelper
        getBusinessPartnerBankByKey( final String businessPartner, final String bankIdentification );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerBank
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *            BusinessPartnerBank} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *         BusinessPartnerBank} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerBankCreateFluentHelper
        createBusinessPartnerBank( @Nonnull final BusinessPartnerBank businessPartnerBank );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerBank
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *            BusinessPartnerBank} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *         BusinessPartnerBank} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerBankUpdateFluentHelper
        updateBusinessPartnerBank( @Nonnull final BusinessPartnerBank businessPartnerBank );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity in the S/4HANA system.
     *
     * @param businessPartnerBank
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *            BusinessPartnerBank} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *         BusinessPartnerBank} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerBankDeleteFluentHelper
        deleteBusinessPartnerBank( @Nonnull final BusinessPartnerBank businessPartnerBank );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *         BusinessPartnerContact} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerContactFluentHelper getAllBusinessPartnerContact();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity using key fields.
     *
     * @param businessPartnerPerson
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerCompany
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Validity Date (Valid To)
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param relationshipNumber
     *            BP Relationship Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *         BusinessPartnerContact} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerContactByKeyFluentHelper getBusinessPartnerContactByKey(
        final String relationshipNumber,
        final String businessPartnerCompany,
        final String businessPartnerPerson,
        final LocalDateTime validityEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *            BusinessPartnerContact} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *         BusinessPartnerContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerContactCreateFluentHelper
        createBusinessPartnerContact( @Nonnull final BusinessPartnerContact businessPartnerContact );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *            BusinessPartnerContact} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *         BusinessPartnerContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerContactUpdateFluentHelper
        updateBusinessPartnerContact( @Nonnull final BusinessPartnerContact businessPartnerContact );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity in the S/4HANA system.
     *
     * @param businessPartnerContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *            BusinessPartnerContact} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *         BusinessPartnerContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerContactDeleteFluentHelper
        deleteBusinessPartnerContact( @Nonnull final BusinessPartnerContact businessPartnerContact );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *         BusinessPartnerRating} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRatingFluentHelper getAllBusinessPartnerRating();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity using key fields.
     *
     * @param bPRatingValidityEndDate
     *            Valid-to Date for Rating
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerRatingProcedure
     *            Rating Procedure
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *         BusinessPartnerRating} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRatingByKeyFluentHelper getBusinessPartnerRatingByKey(
        final String businessPartner,
        final String businessPartnerRatingProcedure,
        final LocalDateTime bPRatingValidityEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRating
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *            BusinessPartnerRating} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *         BusinessPartnerRating} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRatingCreateFluentHelper
        createBusinessPartnerRating( @Nonnull final BusinessPartnerRating businessPartnerRating );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRating
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *            BusinessPartnerRating} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *         BusinessPartnerRating} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRatingUpdateFluentHelper
        updateBusinessPartnerRating( @Nonnull final BusinessPartnerRating businessPartnerRating );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity in the S/4HANA system.
     *
     * @param businessPartnerRating
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *            BusinessPartnerRating} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *         BusinessPartnerRating} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRatingDeleteFluentHelper
        deleteBusinessPartnerRating( @Nonnull final BusinessPartnerRating businessPartnerRating );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     * BusinessPartnerRole} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *         BusinessPartnerRole} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRoleFluentHelper getAllBusinessPartnerRole();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     * BusinessPartnerRole} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerRole
     *            BP Role
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *         BusinessPartnerRole} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRoleByKeyFluentHelper
        getBusinessPartnerRoleByKey( final String businessPartner, final String businessPartnerRole );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     * BusinessPartnerRole} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *            BusinessPartnerRole} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *         BusinessPartnerRole} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRoleCreateFluentHelper
        createBusinessPartnerRole( @Nonnull final BusinessPartnerRole businessPartnerRole );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     * BusinessPartnerRole} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *            BusinessPartnerRole} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *         BusinessPartnerRole} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerRoleUpdateFluentHelper
        updateBusinessPartnerRole( @Nonnull final BusinessPartnerRole businessPartnerRole );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *         BusinessPartnerTaxNumber} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerTaxNumberFluentHelper getAllBusinessPartnerTaxNumber();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity using key fields.
     *
     * @param bPTaxType
     *            Tax Number Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *         BusinessPartnerTaxNumber} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerTaxNumberByKeyFluentHelper
        getBusinessPartnerTaxNumberByKey( final String businessPartner, final String bPTaxType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerTaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *            BusinessPartnerTaxNumber} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *         BusinessPartnerTaxNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerTaxNumberCreateFluentHelper
        createBusinessPartnerTaxNumber( @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerTaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *            BusinessPartnerTaxNumber} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *         BusinessPartnerTaxNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerTaxNumberUpdateFluentHelper
        updateBusinessPartnerTaxNumber( @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity in the S/4HANA system.
     *
     * @param businessPartnerTaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *            BusinessPartnerTaxNumber} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *         BusinessPartnerTaxNumber} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPartnerTaxNumberDeleteFluentHelper
        deleteBusinessPartnerTaxNumber( @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *         BusPartAddrDepdntTaxNmbr} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusPartAddrDepdntTaxNmbrFluentHelper getAllBusPartAddrDepdntTaxNmbr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity using key fields.
     *
     * @param bPTaxType
     *            Tax Number Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *         BusPartAddrDepdntTaxNmbr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusPartAddrDepdntTaxNmbrByKeyFluentHelper getBusPartAddrDepdntTaxNmbrByKey(
        final String businessPartner,
        final String addressID,
        final String bPTaxType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity and save it to the S/4HANA system.
     *
     * @param busPartAddrDepdntTaxNmbr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *            BusPartAddrDepdntTaxNmbr} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *         BusPartAddrDepdntTaxNmbr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusPartAddrDepdntTaxNmbrCreateFluentHelper
        createBusPartAddrDepdntTaxNmbr( @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity and save it to the S/4HANA system.
     *
     * @param busPartAddrDepdntTaxNmbr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *            BusPartAddrDepdntTaxNmbr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *         BusPartAddrDepdntTaxNmbr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusPartAddrDepdntTaxNmbrUpdateFluentHelper
        updateBusPartAddrDepdntTaxNmbr( @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity in the S/4HANA system.
     *
     * @param busPartAddrDepdntTaxNmbr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *            BusPartAddrDepdntTaxNmbr} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *         BusPartAddrDepdntTaxNmbr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusPartAddrDepdntTaxNmbrDeleteFluentHelper
        deleteBusPartAddrDepdntTaxNmbr( @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *         CustAddrDepdntExtIdentifier} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntExtIdentifierFluentHelper getAllCustAddrDepdntExtIdentifier();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity using key fields.
     *
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *         CustAddrDepdntExtIdentifier} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntExtIdentifierByKeyFluentHelper
        getCustAddrDepdntExtIdentifierByKey( final String customer, final String addressID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntExtIdentifier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *            CustAddrDepdntExtIdentifier} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *         CustAddrDepdntExtIdentifier} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntExtIdentifierCreateFluentHelper
        createCustAddrDepdntExtIdentifier( @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntExtIdentifier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *            CustAddrDepdntExtIdentifier} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *         CustAddrDepdntExtIdentifier} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntExtIdentifierUpdateFluentHelper
        updateCustAddrDepdntExtIdentifier( @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity in the S/4HANA system.
     *
     * @param custAddrDepdntExtIdentifier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *            CustAddrDepdntExtIdentifier} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *         CustAddrDepdntExtIdentifier} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntExtIdentifierDeleteFluentHelper
        deleteCustAddrDepdntExtIdentifier( @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *         CustAddrDepdntInformation} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntInformationFluentHelper getAllCustAddrDepdntInformation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity using key fields.
     *
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *         CustAddrDepdntInformation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntInformationByKeyFluentHelper
        getCustAddrDepdntInformationByKey( final String customer, final String addressID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *            CustAddrDepdntInformation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *         CustAddrDepdntInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntInformationCreateFluentHelper
        createCustAddrDepdntInformation( @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *            CustAddrDepdntInformation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *         CustAddrDepdntInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntInformationUpdateFluentHelper
        updateCustAddrDepdntInformation( @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity in the S/4HANA system.
     *
     * @param custAddrDepdntInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *            CustAddrDepdntInformation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *         CustAddrDepdntInformation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustAddrDepdntInformationDeleteFluentHelper
        deleteCustAddrDepdntInformation( @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerFluentHelper getAllCustomer();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer}
     * entity using key fields.
     *
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerByKeyFluentHelper getCustomerByKey( final String customer );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     * and save it to the S/4HANA system.
     *
     * @param customer
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCreateFluentHelper createCustomer( @Nonnull final Customer customer );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer}
     * entity and save it to the S/4HANA system.
     *
     * @param customer
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerUpdateFluentHelper updateCustomer( @Nonnull final Customer customer );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     * CustomerCompany} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *         CustomerCompany} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyFluentHelper getAllCustomerCompany();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     * CustomerCompany} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *         CustomerCompany} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyByKeyFluentHelper getCustomerCompanyByKey( final String customer, final String companyCode );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     * CustomerCompany} entity and save it to the S/4HANA system.
     *
     * @param customerCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *            CustomerCompany} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *         CustomerCompany} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyCreateFluentHelper createCustomerCompany( @Nonnull final CustomerCompany customerCompany );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     * CustomerCompany} entity and save it to the S/4HANA system.
     *
     * @param customerCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *            CustomerCompany} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *         CustomerCompany} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyUpdateFluentHelper updateCustomerCompany( @Nonnull final CustomerCompany customerCompany );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *         CustomerCompanyText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyTextFluentHelper getAllCustomerCompanyText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *         CustomerCompanyText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyTextByKeyFluentHelper getCustomerCompanyTextByKey(
        final String customer,
        final String companyCode,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity and save it to the S/4HANA system.
     *
     * @param customerCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *            CustomerCompanyText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *         CustomerCompanyText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyTextCreateFluentHelper
        createCustomerCompanyText( @Nonnull final CustomerCompanyText customerCompanyText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity and save it to the S/4HANA system.
     *
     * @param customerCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *            CustomerCompanyText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *         CustomerCompanyText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyTextUpdateFluentHelper
        updateCustomerCompanyText( @Nonnull final CustomerCompanyText customerCompanyText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity in the S/4HANA system.
     *
     * @param customerCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *            CustomerCompanyText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *         CustomerCompanyText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerCompanyTextDeleteFluentHelper
        deleteCustomerCompanyText( @Nonnull final CustomerCompanyText customerCompanyText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *         CustomerDunning} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerDunningFluentHelper getAllCustomerDunning();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param dunningArea
     *            Dunning Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *         CustomerDunning} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerDunningByKeyFluentHelper
        getCustomerDunningByKey( final String customer, final String companyCode, final String dunningArea );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity and save it to the S/4HANA system.
     *
     * @param customerDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *            CustomerDunning} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *         CustomerDunning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerDunningCreateFluentHelper createCustomerDunning( @Nonnull final CustomerDunning customerDunning );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity and save it to the S/4HANA system.
     *
     * @param customerDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *            CustomerDunning} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *         CustomerDunning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerDunningUpdateFluentHelper updateCustomerDunning( @Nonnull final CustomerDunning customerDunning );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity in the S/4HANA system.
     *
     * @param customerDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *            CustomerDunning} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *         CustomerDunning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerDunningDeleteFluentHelper deleteCustomerDunning( @Nonnull final CustomerDunning customerDunning );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     * CustomerSalesArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *         CustomerSalesArea} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaFluentHelper getAllCustomerSalesArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     * CustomerSalesArea} entity using key fields.
     *
     * @param division
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *         CustomerSalesArea} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaByKeyFluentHelper getCustomerSalesAreaByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     * CustomerSalesArea} entity and save it to the S/4HANA system.
     *
     * @param customerSalesArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *            CustomerSalesArea} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *         CustomerSalesArea} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaCreateFluentHelper createCustomerSalesArea( @Nonnull final CustomerSalesArea customerSalesArea );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     * CustomerSalesArea} entity and save it to the S/4HANA system.
     *
     * @param customerSalesArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *            CustomerSalesArea} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *         CustomerSalesArea} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaUpdateFluentHelper updateCustomerSalesArea( @Nonnull final CustomerSalesArea customerSalesArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     * CustomerSalesAreaTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *         CustomerSalesAreaTax} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTaxFluentHelper getAllCustomerSalesAreaTax();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     * CustomerSalesAreaTax} entity using key fields.
     *
     * @param division
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param distributionChannel
     *            Reference distrib.channel for cust.and material masters
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customerTaxCategory
     *            Tax Condition Type (Sales Tax, Value-Added Tax,...)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *         CustomerSalesAreaTax} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTaxByKeyFluentHelper getCustomerSalesAreaTaxByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String departureCountry,
        final String customerTaxCategory );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     * CustomerSalesAreaTax} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *            CustomerSalesAreaTax} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *         CustomerSalesAreaTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTaxCreateFluentHelper
        createCustomerSalesAreaTax( @Nonnull final CustomerSalesAreaTax customerSalesAreaTax );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     * CustomerSalesAreaTax} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *            CustomerSalesAreaTax} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *         CustomerSalesAreaTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTaxUpdateFluentHelper
        updateCustomerSalesAreaTax( @Nonnull final CustomerSalesAreaTax customerSalesAreaTax );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *         CustomerSalesAreaText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTextFluentHelper getAllCustomerSalesAreaText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity using key fields.
     *
     * @param division
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param language
     *            Language key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *         CustomerSalesAreaText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTextByKeyFluentHelper getCustomerSalesAreaTextByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *            CustomerSalesAreaText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *         CustomerSalesAreaText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTextCreateFluentHelper
        createCustomerSalesAreaText( @Nonnull final CustomerSalesAreaText customerSalesAreaText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *            CustomerSalesAreaText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *         CustomerSalesAreaText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTextUpdateFluentHelper
        updateCustomerSalesAreaText( @Nonnull final CustomerSalesAreaText customerSalesAreaText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity in the S/4HANA system.
     *
     * @param customerSalesAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *            CustomerSalesAreaText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *         CustomerSalesAreaText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerSalesAreaTextDeleteFluentHelper
        deleteCustomerSalesAreaText( @Nonnull final CustomerSalesAreaText customerSalesAreaText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     * CustomerTaxGrouping} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *         CustomerTaxGrouping} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTaxGroupingFluentHelper getAllCustomerTaxGrouping();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     * CustomerTaxGrouping} entity using key fields.
     *
     * @param customerTaxGroupingCode
     *            Category indicator for tax codes
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *         CustomerTaxGrouping} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTaxGroupingByKeyFluentHelper
        getCustomerTaxGroupingByKey( final String customer, final String customerTaxGroupingCode );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     * CustomerTaxGrouping} entity and save it to the S/4HANA system.
     *
     * @param customerTaxGrouping
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *            CustomerTaxGrouping} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *         CustomerTaxGrouping} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTaxGroupingUpdateFluentHelper
        updateCustomerTaxGrouping( @Nonnull final CustomerTaxGrouping customerTaxGrouping );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     * CustomerTaxGrouping} entity in the S/4HANA system.
     *
     * @param customerTaxGrouping
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *            CustomerTaxGrouping} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *         CustomerTaxGrouping} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTaxGroupingDeleteFluentHelper
        deleteCustomerTaxGrouping( @Nonnull final CustomerTaxGrouping customerTaxGrouping );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTextFluentHelper getAllCustomerText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity using key fields.
     *
     * @param language
     *            Language key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTextByKeyFluentHelper
        getCustomerTextByKey( final String customer, final String language, final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity and save it to the S/4HANA system.
     *
     * @param customerText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTextCreateFluentHelper createCustomerText( @Nonnull final CustomerText customerText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity and save it to the S/4HANA system.
     *
     * @param customerText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTextUpdateFluentHelper updateCustomerText( @Nonnull final CustomerText customerText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity in the S/4HANA system.
     *
     * @param customerText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerTextDeleteFluentHelper deleteCustomerText( @Nonnull final CustomerText customerText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *         CustomerUnloadingPoint} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerUnloadingPointFluentHelper getAllCustomerUnloadingPoint();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity using key fields.
     *
     * @param unloadingPointName
     *            Unloading Point
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *         CustomerUnloadingPoint} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerUnloadingPointByKeyFluentHelper
        getCustomerUnloadingPointByKey( final String customer, final String unloadingPointName );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity and save it to the S/4HANA system.
     *
     * @param customerUnloadingPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *            CustomerUnloadingPoint} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *         CustomerUnloadingPoint} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerUnloadingPointCreateFluentHelper
        createCustomerUnloadingPoint( @Nonnull final CustomerUnloadingPoint customerUnloadingPoint );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity and save it to the S/4HANA system.
     *
     * @param customerUnloadingPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *            CustomerUnloadingPoint} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *         CustomerUnloadingPoint} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerUnloadingPointUpdateFluentHelper
        updateCustomerUnloadingPoint( @Nonnull final CustomerUnloadingPoint customerUnloadingPoint );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity in the S/4HANA system.
     *
     * @param customerUnloadingPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *            CustomerUnloadingPoint} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *         CustomerUnloadingPoint} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerUnloadingPointDeleteFluentHelper
        deleteCustomerUnloadingPoint( @Nonnull final CustomerUnloadingPoint customerUnloadingPoint );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *         CustomerWithHoldingTax} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerWithHoldingTaxFluentHelper getAllCustomerWithHoldingTax();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param withholdingTaxType
     *            Indicator for Withholding Tax Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *         CustomerWithHoldingTax} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerWithHoldingTaxByKeyFluentHelper getCustomerWithHoldingTaxByKey(
        final String customer,
        final String companyCode,
        final String withholdingTaxType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param customerWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *            CustomerWithHoldingTax} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *         CustomerWithHoldingTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerWithHoldingTaxCreateFluentHelper
        createCustomerWithHoldingTax( @Nonnull final CustomerWithHoldingTax customerWithHoldingTax );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param customerWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *            CustomerWithHoldingTax} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *         CustomerWithHoldingTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerWithHoldingTaxUpdateFluentHelper
        updateCustomerWithHoldingTax( @Nonnull final CustomerWithHoldingTax customerWithHoldingTax );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity in the S/4HANA system.
     *
     * @param customerWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *            CustomerWithHoldingTax} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *         CustomerWithHoldingTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerWithHoldingTaxDeleteFluentHelper
        deleteCustomerWithHoldingTax( @Nonnull final CustomerWithHoldingTax customerWithHoldingTax );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *         CustSalesPartnerFunc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSalesPartnerFuncFluentHelper getAllCustSalesPartnerFunc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity using key fields.
     *
     * @param division
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *         CustSalesPartnerFunc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSalesPartnerFuncByKeyFluentHelper getCustSalesPartnerFuncByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String partnerCounter,
        final String partnerFunction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param custSalesPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *            CustSalesPartnerFunc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *         CustSalesPartnerFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSalesPartnerFuncCreateFluentHelper
        createCustSalesPartnerFunc( @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param custSalesPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *            CustSalesPartnerFunc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *         CustSalesPartnerFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSalesPartnerFuncUpdateFluentHelper
        updateCustSalesPartnerFunc( @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity in the S/4HANA system.
     *
     * @param custSalesPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *            CustSalesPartnerFunc} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *         CustSalesPartnerFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSalesPartnerFuncDeleteFluentHelper
        deleteCustSalesPartnerFunc( @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *         CustSlsAreaAddrDepdntInfo} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntInfoFluentHelper getAllCustSlsAreaAddrDepdntInfo();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity using key fields.
     *
     * @param division
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *         CustSlsAreaAddrDepdntInfo} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntInfoByKeyFluentHelper getCustSlsAreaAddrDepdntInfoByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String addressID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *            CustSlsAreaAddrDepdntInfo} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *         CustSlsAreaAddrDepdntInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntInfoCreateFluentHelper
        createCustSlsAreaAddrDepdntInfo( @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *            CustSlsAreaAddrDepdntInfo} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *         CustSlsAreaAddrDepdntInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntInfoUpdateFluentHelper
        updateCustSlsAreaAddrDepdntInfo( @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity in the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *            CustSlsAreaAddrDepdntInfo} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *         CustSlsAreaAddrDepdntInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntInfoDeleteFluentHelper
        deleteCustSlsAreaAddrDepdntInfo( @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *         CustSlsAreaAddrDepdntTaxInfo} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntTaxInfoFluentHelper getAllCustSlsAreaAddrDepdntTaxInfo();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity using key fields.
     *
     * @param division
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param distributionChannel
     *            Reference distrib.channel for cust.and material masters
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customerTaxCategory
     *            Tax Condition Type (Sales Tax, Value-Added Tax,...)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *         CustSlsAreaAddrDepdntTaxInfo} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntTaxInfoByKeyFluentHelper getCustSlsAreaAddrDepdntTaxInfoByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String addressID,
        final String departureCountry,
        final String customerTaxCategory );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntTaxInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *            CustSlsAreaAddrDepdntTaxInfo} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *         CustSlsAreaAddrDepdntTaxInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntTaxInfoCreateFluentHelper
        createCustSlsAreaAddrDepdntTaxInfo( @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntTaxInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *            CustSlsAreaAddrDepdntTaxInfo} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *         CustSlsAreaAddrDepdntTaxInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntTaxInfoUpdateFluentHelper
        updateCustSlsAreaAddrDepdntTaxInfo( @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity in the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntTaxInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *            CustSlsAreaAddrDepdntTaxInfo} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *         CustSlsAreaAddrDepdntTaxInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustSlsAreaAddrDepdntTaxInfoDeleteFluentHelper
        deleteCustSlsAreaAddrDepdntTaxInfo( @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *         CustUnldgPtAddrDepdntInfo} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustUnldgPtAddrDepdntInfoFluentHelper getAllCustUnldgPtAddrDepdntInfo();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity using key fields.
     *
     * @param unloadingPointName
     *            Unloading Point
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *         CustUnldgPtAddrDepdntInfo} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustUnldgPtAddrDepdntInfoByKeyFluentHelper getCustUnldgPtAddrDepdntInfoByKey(
        final String customer,
        final String addressID,
        final String unloadingPointName );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custUnldgPtAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *            CustUnldgPtAddrDepdntInfo} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *         CustUnldgPtAddrDepdntInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustUnldgPtAddrDepdntInfoCreateFluentHelper
        createCustUnldgPtAddrDepdntInfo( @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custUnldgPtAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *            CustUnldgPtAddrDepdntInfo} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *         CustUnldgPtAddrDepdntInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustUnldgPtAddrDepdntInfoUpdateFluentHelper
        updateCustUnldgPtAddrDepdntInfo( @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity in the S/4HANA system.
     *
     * @param custUnldgPtAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *            CustUnldgPtAddrDepdntInfo} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *         CustUnldgPtAddrDepdntInfo} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustUnldgPtAddrDepdntInfoDeleteFluentHelper
        deleteCustUnldgPtAddrDepdntInfo( @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierFluentHelper getAllSupplier();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier}
     * entity using key fields.
     *
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierByKeyFluentHelper getSupplierByKey( final String supplier );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     * and save it to the S/4HANA system.
     *
     * @param supplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCreateFluentHelper createSupplier( @Nonnull final Supplier supplier );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier}
     * entity and save it to the S/4HANA system.
     *
     * @param supplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierUpdateFluentHelper updateSupplier( @Nonnull final Supplier supplier );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     * SupplierCompany} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *         SupplierCompany} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyFluentHelper getAllSupplierCompany();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     * SupplierCompany} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *         SupplierCompany} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyByKeyFluentHelper getSupplierCompanyByKey( final String supplier, final String companyCode );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     * SupplierCompany} entity and save it to the S/4HANA system.
     *
     * @param supplierCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *            SupplierCompany} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *         SupplierCompany} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyCreateFluentHelper createSupplierCompany( @Nonnull final SupplierCompany supplierCompany );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     * SupplierCompany} entity and save it to the S/4HANA system.
     *
     * @param supplierCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *            SupplierCompany} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *         SupplierCompany} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyUpdateFluentHelper updateSupplierCompany( @Nonnull final SupplierCompany supplierCompany );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *         SupplierCompanyText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyTextFluentHelper getAllSupplierCompanyText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *         SupplierCompanyText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyTextByKeyFluentHelper getSupplierCompanyTextByKey(
        final String supplier,
        final String companyCode,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity and save it to the S/4HANA system.
     *
     * @param supplierCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *            SupplierCompanyText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *         SupplierCompanyText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyTextCreateFluentHelper
        createSupplierCompanyText( @Nonnull final SupplierCompanyText supplierCompanyText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity and save it to the S/4HANA system.
     *
     * @param supplierCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *            SupplierCompanyText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *         SupplierCompanyText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyTextUpdateFluentHelper
        updateSupplierCompanyText( @Nonnull final SupplierCompanyText supplierCompanyText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity in the S/4HANA system.
     *
     * @param supplierCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *            SupplierCompanyText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *         SupplierCompanyText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierCompanyTextDeleteFluentHelper
        deleteSupplierCompanyText( @Nonnull final SupplierCompanyText supplierCompanyText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *         SupplierDunning} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierDunningFluentHelper getAllSupplierDunning();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param dunningArea
     *            Dunning Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *         SupplierDunning} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierDunningByKeyFluentHelper
        getSupplierDunningByKey( final String supplier, final String companyCode, final String dunningArea );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity and save it to the S/4HANA system.
     *
     * @param supplierDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *            SupplierDunning} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *         SupplierDunning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierDunningCreateFluentHelper createSupplierDunning( @Nonnull final SupplierDunning supplierDunning );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity and save it to the S/4HANA system.
     *
     * @param supplierDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *            SupplierDunning} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *         SupplierDunning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierDunningUpdateFluentHelper updateSupplierDunning( @Nonnull final SupplierDunning supplierDunning );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity in the S/4HANA system.
     *
     * @param supplierDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *            SupplierDunning} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *         SupplierDunning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierDunningDeleteFluentHelper deleteSupplierDunning( @Nonnull final SupplierDunning supplierDunning );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *         SupplierPartnerFunc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPartnerFuncFluentHelper getAllSupplierPartnerFunc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param supplierSubrange
     *            Supplier Subrange
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *         SupplierPartnerFunc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPartnerFuncByKeyFluentHelper getSupplierPartnerFuncByKey(
        final String supplier,
        final String purchasingOrganization,
        final String supplierSubrange,
        final String plant,
        final String partnerFunction,
        final String partnerCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param supplierPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *            SupplierPartnerFunc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *         SupplierPartnerFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPartnerFuncCreateFluentHelper
        createSupplierPartnerFunc( @Nonnull final SupplierPartnerFunc supplierPartnerFunc );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param supplierPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *            SupplierPartnerFunc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *         SupplierPartnerFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPartnerFuncUpdateFluentHelper
        updateSupplierPartnerFunc( @Nonnull final SupplierPartnerFunc supplierPartnerFunc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity in the S/4HANA system.
     *
     * @param supplierPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *            SupplierPartnerFunc} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *         SupplierPartnerFunc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPartnerFuncDeleteFluentHelper
        deleteSupplierPartnerFunc( @Nonnull final SupplierPartnerFunc supplierPartnerFunc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *         SupplierPurchasingOrg} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgFluentHelper getAllSupplierPurchasingOrg();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entity using key fields.
     *
     * @param supplier
     *            Supplier's Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *         SupplierPurchasingOrg} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgByKeyFluentHelper
        getSupplierPurchasingOrgByKey( final String supplier, final String purchasingOrganization );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *            SupplierPurchasingOrg} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *         SupplierPurchasingOrg} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgCreateFluentHelper
        createSupplierPurchasingOrg( @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *            SupplierPurchasingOrg} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *         SupplierPurchasingOrg} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgUpdateFluentHelper
        updateSupplierPurchasingOrg( @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *         SupplierPurchasingOrgText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgTextFluentHelper getAllSupplierPurchasingOrgText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity using key fields.
     *
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *         SupplierPurchasingOrgText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgTextByKeyFluentHelper getSupplierPurchasingOrgTextByKey(
        final String supplier,
        final String purchasingOrganization,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *            SupplierPurchasingOrgText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *         SupplierPurchasingOrgText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgTextCreateFluentHelper
        createSupplierPurchasingOrgText( @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *            SupplierPurchasingOrgText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *         SupplierPurchasingOrgText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgTextUpdateFluentHelper
        updateSupplierPurchasingOrgText( @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity in the S/4HANA system.
     *
     * @param supplierPurchasingOrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *            SupplierPurchasingOrgText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *         SupplierPurchasingOrgText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierPurchasingOrgTextDeleteFluentHelper
        deleteSupplierPurchasingOrgText( @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierTextFluentHelper getAllSupplierText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity using key fields.
     *
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierTextByKeyFluentHelper
        getSupplierTextByKey( final String supplier, final String language, final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity and save it to the S/4HANA system.
     *
     * @param supplierText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierTextCreateFluentHelper createSupplierText( @Nonnull final SupplierText supplierText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity and save it to the S/4HANA system.
     *
     * @param supplierText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierTextUpdateFluentHelper updateSupplierText( @Nonnull final SupplierText supplierText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity in the S/4HANA system.
     *
     * @param supplierText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierTextDeleteFluentHelper deleteSupplierText( @Nonnull final SupplierText supplierText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *         SupplierWithHoldingTax} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierWithHoldingTaxFluentHelper getAllSupplierWithHoldingTax();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param withholdingTaxType
     *            Indicator for Withholding Tax Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param supplier
     *            Account Number of Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *         SupplierWithHoldingTax} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierWithHoldingTaxByKeyFluentHelper getSupplierWithHoldingTaxByKey(
        final String supplier,
        final String companyCode,
        final String withholdingTaxType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param supplierWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *            SupplierWithHoldingTax} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *         SupplierWithHoldingTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierWithHoldingTaxCreateFluentHelper
        createSupplierWithHoldingTax( @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param supplierWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *            SupplierWithHoldingTax} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *         SupplierWithHoldingTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierWithHoldingTaxUpdateFluentHelper
        updateSupplierWithHoldingTax( @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity in the S/4HANA system.
     *
     * @param supplierWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *            SupplierWithHoldingTax} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *         SupplierWithHoldingTax} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierWithHoldingTaxDeleteFluentHelper
        deleteSupplierWithHoldingTax( @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax );

}
