/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.GetBusinessPlaceFieldPropertiesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.batch.BusinessPlaceServiceBatch;

/**
 * <p>
 *
 * This service provides queries about business places based on countries/regions or scenarios. The detailed information
 * you can query is as follows: - Enablement status of a business place in the current business scenario. Based on the
 * enablement status, customers can decide the field status of the business place on the UI, which can be invisible,
 * display only, optional or mandatory. - List of business places by input variants. - Detailed information about
 * business places, such as tax registration number and address. - Attributes of country/region-specific business
 * places..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/78/fc370156da42ada3adf104341ba32e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GLO_BUSINESSPLACE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GLO_BUSINESSPLACE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Place Integration(SAP_COM_0394)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J59'>Accounts Receivable(J59)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J60'>Accounts Payable(J60)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Place</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessPlaceService extends BatchService<BusinessPlaceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_GLO_BUSINESSPLACE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessPlaceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace
     * BusinessPlace} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace BusinessPlace}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPlaceFluentHelper getAllBusinessPlace();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace
     * BusinessPlace} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPlaceID
     *            Business Place
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlace BusinessPlace}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessPlaceByKeyFluentHelper getBusinessPlaceByKey( final String companyCode, final String businessPlaceID );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetBusinessPlaceFieldProperties</b> OData function import.
     * </p>
     *
     * @param companyCode
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompanyCode</b>
     *            </p>
     * @param scenarioID
     *            Constraints: Not nullable, Maximum length: 6
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ScenarioID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetBusinessPlaceFieldProperties</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.GetBusinessPlaceFieldPropertiesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetBusinessPlaceFieldPropertiesFluentHelper
        getBusinessPlaceFieldProperties( @Nonnull final String scenarioID, @Nonnull final String companyCode );

}
